/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.util.reactive;

import com.jetbrains.rider.util.lifetime.Lifetime;
import com.jetbrains.rider.util.reactive.IProperty;
import com.jetbrains.rider.util.reactive.ISource;
import com.jetbrains.rider.util.reactive.Signal;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR&\u0010\f\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00028\u0000@VX\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0010\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0004\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/util/reactive/Property;", "T", "Lcom/jetbrains/rider/util/reactive/IProperty;", "defaultValue", "(Ljava/lang/Object;)V", "_change", "Lcom/jetbrains/rider/util/reactive/Signal;", "change", "Lcom/jetbrains/rider/util/reactive/ISource;", "getChange", "()Lcom/jetbrains/rider/util/reactive/ISource;", "newValue", "value", "getValue", "()Ljava/lang/Object;", "setValue", "Ljava/lang/Object;", "set", "", "rd-core-jvm"})
public final class Property<T>
implements IProperty<T> {
    private T value;
    private final Signal<T> _change;

    @Override
    public void set(T newValue) {
        this.setValue(newValue);
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public void setValue(T newValue) {
        if (Intrinsics.areEqual(this.value, newValue)) {
            return;
        }
        this.value = newValue;
        this._change.fire(newValue);
    }

    @Override
    @NotNull
    public ISource<T> getChange() {
        return this._change;
    }

    public Property(T defaultValue) {
        this.value = defaultValue;
        this._change = new Signal();
    }

    @Override
    public T invoke() {
        return IProperty.DefaultImpls.invoke(this);
    }

    @Override
    public void advise(@NotNull Lifetime lifetime, @NotNull Function1<? super T, Unit> handler) {
        Intrinsics.checkParameterIsNotNull((Object)lifetime, (String)"lifetime");
        Intrinsics.checkParameterIsNotNull(handler, (String)"handler");
        IProperty.DefaultImpls.advise(this, lifetime, handler);
    }

    @Override
    public void view(@NotNull Lifetime lifetime, @NotNull Function2<? super Lifetime, ? super T, Unit> handler) {
        Intrinsics.checkParameterIsNotNull((Object)lifetime, (String)"lifetime");
        Intrinsics.checkParameterIsNotNull(handler, (String)"handler");
        IProperty.DefaultImpls.view(this, lifetime, handler);
    }

    @Override
    public boolean getChanging() {
        return IProperty.DefaultImpls.getChanging(this);
    }
}

