/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.initializr;

import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleNameLocationSettings;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiser;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.spring.boot.initializr.SpringInitializrApplicationInfoStep;
import com.intellij.spring.boot.initializr.SpringInitializrDownloader;
import com.intellij.spring.boot.initializr.SpringInitializrModuleBuilderPostTask;
import com.intellij.spring.boot.initializr.SpringInitializrOptions;
import com.intellij.spring.boot.initializr.SpringInitializrServiceChooserStep;
import com.intellij.spring.boot.initializr.dependencies.SpringInitializrDependenciesStep;
import com.intellij.spring.boot.options.SpringBootSettings;
import com.intellij.util.containers.ContainerUtil;
import icons.SpringBootApiIcons;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringInitializrModuleBuilder
extends ModuleBuilder {
    private SpringInitializrOptions myOptions;
    private String myServiceUrl;
    private static final Map<String, Set<String>> pluginIdToDependencies = ContainerUtil.immutableMapBuilder().put((Object)"com.intellij.aop", (Object)ContainerUtil.immutableSet((Object[])new String[]{"aop"})).put((Object)"com.intellij.spring.security", (Object)ContainerUtil.immutableSet((Object[])new String[]{"security"})).put((Object)"com.intellij.spring.mvc", (Object)ContainerUtil.immutableSet((Object[])new String[]{"web", "webflux", "data-rest"})).put((Object)"com.intellij.spring.batch", (Object)ContainerUtil.immutableSet((Object[])new String[]{"batch"})).put((Object)"com.intellij.spring.data", (Object)ContainerUtil.immutableSet((Object[])new String[]{"data-jpa"})).put((Object)"com.intellij.spring.integration", (Object)ContainerUtil.immutableSet((Object[])new String[]{"integration", "cloud-stream"})).put((Object)"com.intellij.spring.websocket", (Object)ContainerUtil.immutableSet((Object[])new String[]{"websocket"})).put((Object)"com.intellij.thymeleaf", (Object)ContainerUtil.immutableSet((Object[])new String[]{"thymeleaf"})).put((Object)"com.intellij.velocity", (Object)ContainerUtil.immutableSet((Object[])new String[]{"velocity"})).put((Object)"com.intellij.freemarker", (Object)ContainerUtil.immutableSet((Object[])new String[]{"freemarker"})).put((Object)"org.intellij.groovy", (Object)ContainerUtil.immutableSet((Object[])new String[]{"groovy-templates"})).put((Object)"com.dmarcotte.handlebars", (Object)ContainerUtil.immutableSet((Object[])new String[]{"mustache"})).put((Object)"Lombook Plugin", (Object)ContainerUtil.immutableSet((Object[])new String[]{"lombok"})).put((Object)"com.alivanov.intellij.plugins.liquigen", (Object)ContainerUtil.immutableSet((Object[])new String[]{"liquibase"})).put((Object)"com.alexanderpa.flyway.migration.creator", (Object)ContainerUtil.immutableSet((Object[])new String[]{"flyway"})).put((Object)"Mongo Plugin", (Object)ContainerUtil.immutableSet((Object[])new String[]{"mongodb", "data-mongodb-reactive"})).put((Object)"org.apache.camel", (Object)ContainerUtil.immutableSet((Object[])new String[]{"camel"})).put((Object)"jms-messenger", (Object)ContainerUtil.immutableSet((Object[])new String[]{"activemq", "artemis", "hornetq", "kafka", "kafka-streams"})).put((Object)"com.neueda4j.intellij.plugin.cypher", (Object)ContainerUtil.immutableSet((Object[])new String[]{"data-neo4j"})).put((Object)"com.google.gct.core", (Object)ContainerUtil.immutableSet((Object[])new String[]{"cloud-gcp", "cloud-gcp-pubsub", "cloud-gcp-storage"})).build();

    public SpringInitializrOptions getOptions() {
        return this.myOptions;
    }

    void setOptions(SpringInitializrOptions options) {
        this.myOptions = options;
    }

    String getServiceUrl() {
        return this.myServiceUrl;
    }

    void setServiceUrl(String serviceUrl) {
        this.myServiceUrl = serviceUrl;
    }

    @Nullable
    public ModuleWizardStep modifySettingsStep(@NotNull SettingsStep settingsStep) {
        ModuleNameLocationSettings moduleNameLocationSettings;
        if (settingsStep == null) {
            SpringInitializrModuleBuilder.$$$reportNull$$$0(0);
        }
        if ((moduleNameLocationSettings = settingsStep.getModuleNameLocationSettings()) != null) {
            moduleNameLocationSettings.setModuleName(this.myOptions.artifact);
        }
        return super.modifySettingsStep(settingsStep);
    }

    public ModuleWizardStep[] createWizardSteps(@NotNull WizardContext wizardContext, @NotNull ModulesProvider modulesProvider) {
        if (wizardContext == null) {
            SpringInitializrModuleBuilder.$$$reportNull$$$0(1);
        }
        if (modulesProvider == null) {
            SpringInitializrModuleBuilder.$$$reportNull$$$0(2);
        }
        return new ModuleWizardStep[]{new SpringInitializrApplicationInfoStep(this, wizardContext), new SpringInitializrDependenciesStep(this)};
    }

    @Nullable
    public ModuleWizardStep getCustomOptionsStep(WizardContext context, Disposable parentDisposable) {
        return new SpringInitializrServiceChooserStep(this);
    }

    @Nullable
    public String getBuilderId() {
        return "SpringInitializr";
    }

    public String getDescription() {
        return "Create <b>Spring Boot</b> applications using Spring Boot Starters.";
    }

    public String getPresentableName() {
        return "Spring Initializr";
    }

    public String getParentGroup() {
        return "Build Tools";
    }

    public int getWeight() {
        return 80;
    }

    public Icon getNodeIcon() {
        return SpringBootApiIcons.SpringBoot;
    }

    public ModuleType getModuleType() {
        return StdModuleTypes.JAVA;
    }

    public void setupRootModel(ModifiableRootModel modifiableRootModel) {
        LanguageLevelModuleExtension moduleExt;
        Sdk sdk;
        Sdk sdk2 = sdk = this.getModuleJdk() != null ? this.getModuleJdk() : ProjectRootManager.getInstance((Project)modifiableRootModel.getProject()).getProjectSdk();
        if (sdk != null) {
            modifiableRootModel.setSdk(sdk);
        }
        if ((moduleExt = (LanguageLevelModuleExtension)modifiableRootModel.getModuleExtension(LanguageLevelModuleExtension.class)) != null && sdk != null) {
            SpringInitializrOptions.Option selected = (SpringInitializrOptions.Option)((Object)this.myOptions.javaVersion.getSelected());
            assert (selected != null);
            JavaSdkVersion selectedVersion = JavaSdkVersion.fromVersionString((String)selected.id);
            JavaSdkVersion sdkVersion = JavaSdk.getInstance().getVersion(sdk);
            if (selectedVersion != null && sdkVersion != null && sdkVersion.isAtLeast(selectedVersion)) {
                moduleExt.setLanguageLevel(selectedVersion.getMaxLanguageLevel());
            }
        }
        this.doAddContentEntry(modifiableRootModel);
    }

    @NotNull
    public Module createModule(@NotNull ModifiableModuleModel moduleModel) throws InvalidDataException, IOException, ModuleWithNameAlreadyExists, JDOMException, ConfigurationException {
        if (moduleModel == null) {
            SpringInitializrModuleBuilder.$$$reportNull$$$0(3);
        }
        Module module = super.createModule(moduleModel);
        ApplicationManager.getApplication().invokeLater(() -> {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                try {
                    SpringInitializrDownloader downloader = new SpringInitializrDownloader(this);
                    downloader.execute(ProgressManager.getInstance().getProgressIndicator());
                }
                catch (IOException e) {
                    ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((String)("Error: " + e.getMessage()), (String)"Spring Initializr"));
                }
            }, "Downloading Spring Initializr Template...", true, null);
            Project project = module.getProject();
            if (SpringBootSettings.getInstance((Project)project).isReformatAfterCreation()) {
                ApplicationManager.getApplication().invokeLater(() -> ApplicationManager.getApplication().runWriteAction(() -> new ReformatCodeProcessor(project, module, false).run()), project.getDisposed());
            }
            for (SpringInitializrModuleBuilderPostTask task : (SpringInitializrModuleBuilderPostTask[])SpringInitializrModuleBuilderPostTask.EXTENSION_POINT_NAME.getExtensions()) {
                if (module.isDisposed()) {
                    return;
                }
                if (!task.runAfterSetup(module)) break;
            }
            this.verifyIdePlugins(project);
        }, ModalityState.current());
        Module module2 = module;
        if (module2 == null) {
            SpringInitializrModuleBuilder.$$$reportNull$$$0(4);
        }
        return module2;
    }

    private void verifyIdePlugins(Project project) {
        Set<String> selectedDependenciesIds = this.myOptions.selectedDependenciesIds;
        HashSet<String> requiredPluginIds = new HashSet<String>();
        for (Map.Entry<String, Set<String>> entry : pluginIdToDependencies.entrySet()) {
            if (!ContainerUtil.intersects((Collection)entry.getValue(), selectedDependenciesIds)) continue;
            requiredPluginIds.add(entry.getKey());
        }
        final HashSet<String> toInstallOrEnable = new HashSet<String>();
        for (String pluginId : requiredPluginIds) {
            IdeaPluginDescriptor ideaPluginDescriptor = PluginManager.getPlugin((PluginId)PluginId.getId((String)pluginId));
            if (ideaPluginDescriptor != null && ideaPluginDescriptor.isEnabled()) continue;
            toInstallOrEnable.add(pluginId);
        }
        if (toInstallOrEnable.isEmpty()) {
            return;
        }
        PluginsAdvertiser.NOTIFICATION_GROUP.createNotification("Plugins Suggestion", "Found plugins for chosen dependencies.", NotificationType.INFORMATION, null).addAction((AnAction)new NotificationAction("Enable plugins..."){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (notification == null) {
                    1.$$$reportNull$$$0(1);
                }
                PluginsAdvertiser.installAndEnablePlugins((Set)toInstallOrEnable, () -> {
                    if (notification == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    notification.expire();
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "notification";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/spring/boot/initializr/SpringInitializrModuleBuilder$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$actionPerformed$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }).notify(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsStep";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wizardContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulesProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/initializr/SpringInitializrModuleBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/initializr/SpringInitializrModuleBuilder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "modifySettingsStep";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createWizardSteps";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createModule";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

