/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.initializr;

import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.spring.boot.initializr.SpringInitializrModuleBuilder;
import com.intellij.spring.boot.initializr.SpringInitializrOptions;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.ZipUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SpringInitializrDownloader {
    private final SpringInitializrModuleBuilder myBuilder;
    private static final String FILENAME = "filename=";

    SpringInitializrDownloader(SpringInitializrModuleBuilder builder) {
        this.myBuilder = builder;
    }

    static String userAgent() {
        return ApplicationNamesInfo.getInstance().getFullProductName() + "/" + ApplicationInfo.getInstance().getFullVersion();
    }

    void execute(final ProgressIndicator indicator) throws IOException {
        final File tempFile = FileUtil.createTempFile((String)"spring-initializr", (String)".tmp", (boolean)true);
        DownloadResult result = (DownloadResult)HttpRequests.request((String)this.buildUrl()).userAgent(SpringInitializrDownloader.userAgent()).connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<DownloadResult>(){

            public DownloadResult process(@NotNull HttpRequests.Request request) throws IOException {
                String contentType;
                if (request == null) {
                    1.$$$reportNull$$$0(0);
                }
                boolean isZip = StringUtil.isNotEmpty((String)(contentType = request.getConnection().getContentType())) && contentType.startsWith("application/zip");
                String contentDisposition = request.getConnection().getHeaderField("Content-Disposition");
                String filename = SpringInitializrDownloader.getFilename(contentDisposition);
                indicator.setText(filename);
                request.saveToFile(tempFile, indicator);
                return new DownloadResult(isZip, filename);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/spring/boot/initializr/SpringInitializrDownloader$1", "process"));
            }
        });
        indicator.setText("Preparing Template...");
        String path = this.myBuilder.getContentEntryPath();
        assert (path != null);
        File contentEntryDir = new File(path);
        if (result.myUnzip) {
            ZipUtil.extract((File)tempFile, (File)contentEntryDir, null);
            SpringInitializrDownloader.fixExecutableFlag(contentEntryDir, "gradlew");
            SpringInitializrDownloader.fixExecutableFlag(contentEntryDir, "mvnw");
        } else {
            File targetFile = new File(contentEntryDir, result.myFilename);
            FileUtil.copy((File)tempFile, (File)targetFile);
        }
        VirtualFile vf = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(contentEntryDir);
        RefreshQueue.getInstance().refresh(false, true, null, new VirtualFile[]{vf});
    }

    private static void fixExecutableFlag(File containingDir, String relativePath) {
        File toFix = new File(containingDir, relativePath);
        if (toFix.exists()) {
            toFix.setExecutable(true, false);
        }
    }

    @NotNull
    private static String getFilename(@Nullable String contentDisposition) {
        if (StringUtil.isEmpty((String)contentDisposition)) {
            if ("unknown" == null) {
                SpringInitializrDownloader.$$$reportNull$$$0(0);
            }
            return "unknown";
        }
        int startIdx = contentDisposition.indexOf(FILENAME);
        int endIdx = contentDisposition.indexOf(59, startIdx);
        String fileName = contentDisposition.substring(startIdx + FILENAME.length(), endIdx > 0 ? endIdx : contentDisposition.length());
        if (StringUtil.startsWithChar((CharSequence)fileName, (char)'\"') && StringUtil.endsWithChar((CharSequence)fileName, (char)'\"')) {
            fileName = fileName.substring(1, fileName.length() - 1);
        }
        String string = fileName;
        if (string == null) {
            SpringInitializrDownloader.$$$reportNull$$$0(1);
        }
        return string;
    }

    private String buildUrl() {
        SpringInitializrOptions options = this.myBuilder.getOptions();
        SpringInitializrOptions.Option selectedType = (SpringInitializrOptions.Option)((Object)options.type.getSelected());
        assert (selectedType != null);
        String action = options.typeToAction.get(selectedType.id);
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("type", SpringInitializrDownloader.getParameter(options.type));
        parameters.put("packaging", SpringInitializrDownloader.getParameter(options.packaging));
        parameters.put("javaVersion", SpringInitializrDownloader.getParameter(options.javaVersion));
        parameters.put("language", SpringInitializrDownloader.getParameter(options.language));
        parameters.put("bootVersion", SpringInitializrDownloader.getParameter(options.bootVersion));
        parameters.put("groupId", options.group);
        parameters.put("artifactId", options.artifact);
        parameters.put("name", options.name);
        parameters.put("version", options.version);
        parameters.put("description", options.description);
        parameters.put("packageName", options.packageName);
        String serviceUrl = StringUtil.trimTrailing((String)this.myBuilder.getServiceUrl(), (char)'/');
        Url url = Urls.newFromEncoded((String)(serviceUrl + action)).addParameters(parameters);
        for (String id : options.selectedDependenciesIds) {
            url = url.addParameters(Collections.singletonMap("dependencies", id));
        }
        return url.toExternalForm();
    }

    private static String getParameter(CollectionComboBoxModel<SpringInitializrOptions.Option> model) {
        SpringInitializrOptions.Option item = (SpringInitializrOptions.Option)((Object)model.getSelected());
        assert (item != null) : model;
        return item.id;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/initializr/SpringInitializrDownloader", "getFilename"));
    }

    private static class DownloadResult {
        private final boolean myUnzip;
        private final String myFilename;

        DownloadResult(boolean unzip, String filename) {
            this.myUnzip = unzip;
            this.myFilename = filename;
        }
    }
}

