/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutinspector;

import com.android.layoutinspector.LayoutInspectorCaptureOptions;
import com.android.layoutinspector.LayoutInspectorResult;
import com.android.layoutinspector.model.ClientWindow;
import com.android.layoutinspector.model.ViewNode;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.concurrent.TimeUnit;

public class LayoutInspectorBridge {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LayoutInspectorResult captureView(ClientWindow window, LayoutInspectorCaptureOptions options) {
        byte[] hierarchy = window.loadWindowData(20L, TimeUnit.SECONDS);
        if (hierarchy == null) {
            return new LayoutInspectorResult(null, "Unexpected error: empty view hierarchy");
        }
        ViewNode root = ViewNode.parseFlatString(hierarchy);
        if (root == null) {
            return new LayoutInspectorResult(null, "Unable to parse view hierarchy");
        }
        byte[] preview = window.loadViewImage(root, 10L, TimeUnit.SECONDS);
        if (preview == null) {
            return new LayoutInspectorResult(null, "Unable to obtain preview image");
        }
        ByteArrayOutputStream bytes = new ByteArrayOutputStream(4096);
        ObjectOutputStream output = null;
        try {
            output = new ObjectOutputStream(bytes);
            output.writeUTF(options.toString());
            output.writeInt(hierarchy.length);
            output.write(hierarchy);
            output.writeInt(preview.length);
            output.write(preview);
        }
        catch (IOException e) {
            LayoutInspectorResult layoutInspectorResult = new LayoutInspectorResult(null, "Unexpected error while saving hierarchy snapshot: " + e);
            return layoutInspectorResult;
        }
        finally {
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (IOException e) {
                return new LayoutInspectorResult(null, "Unexpected error while closing hierarchy snapshot: " + e);
            }
        }
        return new LayoutInspectorResult(bytes.toByteArray(), "");
    }
}

