/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots;

import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.SdkVersionUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.lang.JavaVersion;
import java.io.File;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JdkVersionDetector;

public class SimpleJavaSdkType
extends SdkType
implements JavaSdkType {
    public static SimpleJavaSdkType getInstance() {
        return SdkType.findInstance(SimpleJavaSdkType.class);
    }

    public SimpleJavaSdkType() {
        super("SimpleJavaSdkType");
    }

    public Sdk createJdk(@NotNull String jdkName, @NotNull String home) {
        if (jdkName == null) {
            SimpleJavaSdkType.$$$reportNull$$$0(0);
        }
        if (home == null) {
            SimpleJavaSdkType.$$$reportNull$$$0(1);
        }
        Sdk jdk = ProjectJdkTable.getInstance().createSdk(jdkName, this);
        SdkModificator sdkModificator = jdk.getSdkModificator();
        sdkModificator.setHomePath(FileUtil.toSystemIndependentName((String)home));
        sdkModificator.commitChanges();
        return jdk;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = ProjectBundle.message("sdk.java.name", new Object[0]);
        if (string == null) {
            SimpleJavaSdkType.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public AdditionalDataConfigurable createAdditionalDataConfigurable(@NotNull SdkModel sdkModel, @NotNull SdkModificator sdkModificator) {
        if (sdkModel == null) {
            SimpleJavaSdkType.$$$reportNull$$$0(3);
        }
        if (sdkModificator == null) {
            SimpleJavaSdkType.$$$reportNull$$$0(4);
        }
        return null;
    }

    @Override
    public void saveAdditionalData(@NotNull SdkAdditionalData additionalData, @NotNull Element additional) {
        if (additionalData == null) {
            SimpleJavaSdkType.$$$reportNull$$$0(5);
        }
        if (additional == null) {
            SimpleJavaSdkType.$$$reportNull$$$0(6);
        }
    }

    @Override
    public String getBinPath(@NotNull Sdk sdk) {
        if (sdk == null) {
            SimpleJavaSdkType.$$$reportNull$$$0(7);
        }
        return new File(sdk.getHomePath(), "bin").getPath();
    }

    @Override
    public String getToolsPath(@NotNull Sdk sdk) {
        if (sdk == null) {
            SimpleJavaSdkType.$$$reportNull$$$0(8);
        }
        return new File(sdk.getHomePath(), "lib/tools.jar").getPath();
    }

    @Override
    public String getVMExecutablePath(@NotNull Sdk sdk) {
        if (sdk == null) {
            SimpleJavaSdkType.$$$reportNull$$$0(9);
        }
        return new File(sdk.getHomePath(), "bin/java").getPath();
    }

    @Override
    public String suggestHomePath() {
        return null;
    }

    @Override
    public boolean isValidSdkHome(String path2) {
        return JdkUtil.checkForJdk(path2);
    }

    @Override
    @NotNull
    public String suggestSdkName(String currentSdkName, String sdkHome) {
        String string = SimpleJavaSdkType.suggestJavaSdkName(this, currentSdkName, sdkHome);
        if (string == null) {
            SimpleJavaSdkType.$$$reportNull$$$0(10);
        }
        return string;
    }

    public static String suggestJavaSdkName(JavaSdkType javaSdkType, String currentSdkName, String sdkHome) {
        assert (javaSdkType instanceof SdkType);
        JavaVersion version = JavaVersion.tryParse((String)((SdkType)((Object)javaSdkType)).getVersionString(sdkHome));
        if (version == null) {
            return currentSdkName;
        }
        StringBuilder suggested = new StringBuilder();
        if (version.feature < 9) {
            suggested.append("1.");
        }
        suggested.append(version.feature);
        if (version.ea) {
            suggested.append("-ea");
        }
        return suggested.toString();
    }

    @Override
    public final String getVersionString(String sdkHome) {
        JdkVersionDetector.JdkVersionInfo jdkInfo = SdkVersionUtil.getJdkVersionInfo(sdkHome);
        return jdkInfo != null ? JdkVersionDetector.formatVersionString(jdkInfo.version) : null;
    }

    @NotNull
    public static Condition<SdkTypeId> notSimpleJavaSdkType() {
        Condition condition = sdkTypeId -> !(sdkTypeId instanceof SimpleJavaSdkType);
        if (condition == null) {
            SimpleJavaSdkType.$$$reportNull$$$0(11);
        }
        return condition;
    }

    @NotNull
    public static Condition<SdkTypeId> notSimpleJavaSdkType(@Nullable Condition<? super SdkTypeId> condition) {
        Condition condition2 = sdkTypeId -> SimpleJavaSdkType.notSimpleJavaSdkType().value(sdkTypeId) && (condition == null || condition.value(sdkTypeId));
        if (condition2 == null) {
            SimpleJavaSdkType.$$$reportNull$$$0(12);
        }
        return condition2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdkName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "home";
                break;
            }
            case 2: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/SimpleJavaSdkType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkModificator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalData";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additional";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/SimpleJavaSdkType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestSdkName";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "notSimpleJavaSdkType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createJdk";
                break;
            }
            case 2: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createAdditionalDataConfigurable";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "saveAdditionalData";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getBinPath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getToolsPath";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getVMExecutablePath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

