/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find;

import com.intellij.find.FindModel;
import com.intellij.find.FindModelListener;
import com.intellij.find.FindResult;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.messages.Topic;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FindManager {
    public static final Topic<FindModelListener> FIND_MODEL_TOPIC = new Topic("FindManager's model changes", FindModelListener.class);

    public abstract FindModel createReplaceInFileModel();

    @Nullable
    public abstract FindModel getPreviousFindModel();

    public abstract void setPreviousFindModel(FindModel var1);

    public abstract void showSettingsAndFindUsages(@NotNull NavigationItem[] var1);

    public static FindManager getInstance(Project project) {
        return ServiceManager.getService(project, FindManager.class);
    }

    public abstract void showFindDialog(@NotNull FindModel var1, @NotNull Runnable var2);

    @PromptResultValue
    public abstract int showPromptDialog(@NotNull FindModel var1, String var2);

    @NotNull
    public abstract FindModel getFindInFileModel();

    @NotNull
    public abstract FindModel getFindInProjectModel();

    @NotNull
    public abstract FindResult findString(@NotNull CharSequence var1, int var2, @NotNull FindModel var3);

    @NotNull
    public abstract FindResult findString(@NotNull CharSequence var1, int var2, @NotNull FindModel var3, @Nullable VirtualFile var4);

    @PromptResultValue
    public abstract int showMalformedReplacementPrompt(@NotNull FindModel var1, String var2, MalformedReplacementStringException var3);

    public abstract String getStringToReplace(@NotNull String var1, @NotNull FindModel var2, int var3, @NotNull CharSequence var4) throws MalformedReplacementStringException;

    public abstract boolean findWasPerformed();

    public abstract void setFindWasPerformed();

    public abstract boolean selectNextOccurrenceWasPerformed();

    public abstract void setSelectNextOccurrenceWasPerformed();

    public abstract void clearFindingNextUsageInFile();

    public abstract void setFindNextModel(FindModel var1);

    public abstract FindModel getFindNextModel();

    public abstract FindModel getFindNextModel(@NotNull Editor var1);

    public abstract boolean canFindUsages(@NotNull PsiElement var1);

    public abstract void findUsages(@NotNull PsiElement var1);

    public abstract void findUsagesInScope(@NotNull PsiElement var1, @NotNull SearchScope var2);

    public abstract void findUsages(@NotNull PsiElement var1, boolean var2);

    public abstract void findUsagesInEditor(@NotNull PsiElement var1, @NotNull FileEditor var2);

    public abstract boolean findNextUsageInEditor(@NotNull FileEditor var1);

    public abstract boolean findPreviousUsageInEditor(@NotNull FileEditor var1);

    public static interface PromptResult {
        public static final int OK = 0;
        public static final int CANCEL = 1;
        public static final int SKIP = 2;
        public static final int ALL = 3;
        public static final int ALL_IN_THIS_FILE = 4;
        public static final int ALL_FILES = 5;
        public static final int SKIP_ALL_IN_THIS_FILE = 6;
    }

    public static @interface PromptResultValue {
    }

    public static class MalformedReplacementStringException
    extends Exception {
        public MalformedReplacementStringException(String s, Throwable throwable) {
            super(s, throwable);
        }
    }
}

