/*
 * Decompiled with CFR 0.152.
 */
package libcore.util;

public class TimeZoneDataFiles {
    private static final String ANDROID_ROOT_ENV = "ANDROID_ROOT";
    private static final String ANDROID_DATA_ENV = "ANDROID_DATA";

    private TimeZoneDataFiles() {
    }

    public static String[] getTimeZoneFilePaths(String fileName) {
        return new String[]{TimeZoneDataFiles.getDataTimeZoneFile(fileName), TimeZoneDataFiles.getSystemTimeZoneFile(fileName)};
    }

    private static String getDataTimeZoneFile(String fileName) {
        return System.getenv(ANDROID_DATA_ENV) + "/misc/zoneinfo/current/" + fileName;
    }

    public static String getSystemTimeZoneFile(String fileName) {
        return System.getenv(ANDROID_ROOT_ENV) + "/usr/share/zoneinfo/" + fileName;
    }

    public static String generateIcuDataPath() {
        String systemIcuDataPath;
        StringBuilder icuDataPathBuilder = new StringBuilder();
        String dataIcuDataPath = TimeZoneDataFiles.getEnvironmentPath(ANDROID_DATA_ENV, "/misc/zoneinfo/current/icu");
        if (dataIcuDataPath != null) {
            icuDataPathBuilder.append(dataIcuDataPath);
        }
        if ((systemIcuDataPath = TimeZoneDataFiles.getEnvironmentPath(ANDROID_ROOT_ENV, "/usr/icu")) != null) {
            if (icuDataPathBuilder.length() > 0) {
                icuDataPathBuilder.append(":");
            }
            icuDataPathBuilder.append(systemIcuDataPath);
        }
        return icuDataPathBuilder.toString();
    }

    private static String getEnvironmentPath(String environmentVariable, String path) {
        String variable = System.getenv(environmentVariable);
        if (variable == null) {
            return null;
        }
        return variable + path;
    }
}

