/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.telephony.OperatorInfo;
import java.util.ArrayList;
import java.util.List;

public class CellNetworkScanResult
implements Parcelable {
    public static final int STATUS_SUCCESS = 1;
    public static final int STATUS_RADIO_NOT_AVAILABLE = 2;
    public static final int STATUS_RADIO_GENERIC_FAILURE = 3;
    public static final int STATUS_UNKNOWN_ERROR = 4;
    private final int mStatus;
    private final List<OperatorInfo> mOperators;
    public static final Parcelable.Creator<CellNetworkScanResult> CREATOR = new Parcelable.Creator<CellNetworkScanResult>(){

        @Override
        public CellNetworkScanResult createFromParcel(Parcel in) {
            return new CellNetworkScanResult(in);
        }

        public CellNetworkScanResult[] newArray(int size) {
            return new CellNetworkScanResult[size];
        }
    };

    public CellNetworkScanResult(int status, List<OperatorInfo> operators) {
        this.mStatus = status;
        this.mOperators = operators;
    }

    private CellNetworkScanResult(Parcel in) {
        this.mStatus = in.readInt();
        int len = in.readInt();
        if (len > 0) {
            this.mOperators = new ArrayList<OperatorInfo>();
            for (int i = 0; i < len; ++i) {
                this.mOperators.add(OperatorInfo.CREATOR.createFromParcel(in));
            }
        } else {
            this.mOperators = null;
        }
    }

    public int getStatus() {
        return this.mStatus;
    }

    public List<OperatorInfo> getOperators() {
        return this.mOperators;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mStatus);
        if (this.mOperators != null && this.mOperators.size() > 0) {
            out.writeInt(this.mOperators.size());
            for (OperatorInfo network : this.mOperators) {
                network.writeToParcel(out, flags);
            }
        } else {
            out.writeInt(0);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("CellNetworkScanResult: {");
        sb.append(" status:").append(this.mStatus);
        if (this.mOperators != null) {
            for (OperatorInfo network : this.mOperators) {
                sb.append(" network:").append(network);
            }
        }
        sb.append("}");
        return sb.toString();
    }
}

