/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Parcel;
import java.util.HashMap;

public class PooledStringWriter {
    private final Parcel mOut;
    private final HashMap<String, Integer> mPool;
    private int mStart;
    private int mNext;

    public PooledStringWriter(Parcel out) {
        this.mOut = out;
        this.mPool = new HashMap();
        this.mStart = out.dataPosition();
        out.writeInt(0);
    }

    public void writeString(String str) {
        Integer cur = this.mPool.get(str);
        if (cur != null) {
            this.mOut.writeInt(cur);
        } else {
            this.mPool.put(str, this.mNext);
            this.mOut.writeInt(-(this.mNext + 1));
            this.mOut.writeString(str);
            ++this.mNext;
        }
    }

    public int getStringCount() {
        return this.mPool.size();
    }

    public void finish() {
        int pos = this.mOut.dataPosition();
        this.mOut.setDataPosition(this.mStart);
        this.mOut.writeInt(this.mNext);
        this.mOut.setDataPosition(pos);
    }
}

