/*
 * Decompiled with CFR 0.152.
 */
package android.inputmethodservice;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;

public class CompactExtractEditLayout
extends LinearLayout {
    private View mInputExtractEditText;
    private View mInputExtractAccessories;
    private View mInputExtractAction;
    private boolean mPerformLayoutChanges;

    public CompactExtractEditLayout(Context context) {
        super(context);
    }

    public CompactExtractEditLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public CompactExtractEditLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mInputExtractEditText = this.findViewById(16908325);
        this.mInputExtractAccessories = this.findViewById(16908963);
        this.mInputExtractAction = this.findViewById(16908964);
        if (this.mInputExtractEditText != null && this.mInputExtractAccessories != null && this.mInputExtractAction != null) {
            this.mPerformLayoutChanges = true;
        }
    }

    private int applyFractionInt(int fraction2, int whole) {
        return Math.round(this.getResources().getFraction(fraction2, whole, whole));
    }

    private static void setLayoutHeight(View v, int px) {
        ViewGroup.LayoutParams lp = v.getLayoutParams();
        lp.height = px;
        v.setLayoutParams(lp);
    }

    private static void setLayoutMarginBottom(View v, int px) {
        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)v.getLayoutParams();
        lp.bottomMargin = px;
        v.setLayoutParams(lp);
    }

    private void applyProportionalLayout(int screenWidthPx, int screenHeightPx) {
        if (this.getResources().getConfiguration().isScreenRound()) {
            this.setGravity(80);
        }
        CompactExtractEditLayout.setLayoutHeight(this, this.applyFractionInt(18022406, screenHeightPx));
        this.setPadding(this.applyFractionInt(18022407, screenWidthPx), 0, this.applyFractionInt(18022409, screenWidthPx), 0);
        CompactExtractEditLayout.setLayoutMarginBottom(this.mInputExtractEditText, this.applyFractionInt(18022410, screenHeightPx));
        CompactExtractEditLayout.setLayoutMarginBottom(this.mInputExtractAccessories, this.applyFractionInt(18022405, screenHeightPx));
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mPerformLayoutChanges) {
            Resources res = this.getResources();
            Configuration cfg = res.getConfiguration();
            DisplayMetrics dm = res.getDisplayMetrics();
            int widthPixels = dm.widthPixels;
            int heightPixels = dm.heightPixels;
            if (cfg.isScreenRound() && heightPixels < widthPixels) {
                heightPixels = widthPixels;
            }
            this.applyProportionalLayout(widthPixels, heightPixels);
        }
    }
}

