/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl.number.formatters;

import android.icu.impl.number.Format;
import android.icu.impl.number.FormatQuantity;
import android.icu.impl.number.ModifierHolder;
import android.icu.impl.number.Properties;

public class MagnitudeMultiplier
extends Format.BeforeFormat {
    private static final MagnitudeMultiplier DEFAULT = new MagnitudeMultiplier(0);
    final int delta;

    public static boolean useMagnitudeMultiplier(IProperties properties) {
        return properties.getMagnitudeMultiplier() != 0;
    }

    public static Format.BeforeFormat getInstance(Properties properties) {
        if (properties.getMagnitudeMultiplier() == 0) {
            return DEFAULT;
        }
        return new MagnitudeMultiplier(properties.getMagnitudeMultiplier());
    }

    private MagnitudeMultiplier(int delta) {
        this.delta = delta;
    }

    @Override
    public void before(FormatQuantity input, ModifierHolder mods) {
        input.adjustMagnitude(this.delta);
    }

    @Override
    public void export(Properties properties) {
        properties.setMagnitudeMultiplier(this.delta);
    }

    public static interface IProperties {
        public static final int DEFAULT_MAGNITUDE_MULTIPLIER = 0;

        public int getMagnitudeMultiplier();

        public IProperties setMagnitudeMultiplier(int var1);
    }
}

