/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl.number;

import android.icu.impl.number.Modifier;
import android.icu.impl.number.NumberStringBuilder;
import java.util.ArrayDeque;

public class ModifierHolder {
    private ArrayDeque<Modifier> mods = new ArrayDeque();

    public ModifierHolder clear() {
        this.mods.clear();
        return this;
    }

    public void add(Modifier modifier) {
        if (modifier != null) {
            this.mods.addFirst(modifier);
        }
    }

    public Modifier peekLast() {
        return this.mods.peekLast();
    }

    public Modifier removeLast() {
        return this.mods.removeLast();
    }

    public int applyAll(NumberStringBuilder string2, int leftIndex, int rightIndex) {
        int addedLength = 0;
        while (!this.mods.isEmpty()) {
            Modifier mod = this.mods.removeFirst();
            addedLength += mod.apply(string2, leftIndex, rightIndex + addedLength);
        }
        return addedLength;
    }

    public int applyStrong(NumberStringBuilder string2, int leftIndex, int rightIndex) {
        int addedLength = 0;
        while (!this.mods.isEmpty() && this.mods.peekFirst().isStrong()) {
            Modifier mod = this.mods.removeFirst();
            addedLength += mod.apply(string2, leftIndex, rightIndex + addedLength);
        }
        return addedLength;
    }

    public int totalLength() {
        int length = 0;
        for (Modifier mod : this.mods) {
            if (mod == null) continue;
            length += mod.length();
        }
        return length;
    }
}

