/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.usb;

import android.annotation.SuppressLint;
import android.content.Context;
import android.hardware.usb.UsbConfiguration;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbRequest;
import android.os.ParcelFileDescriptor;
import com.android.internal.util.Preconditions;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.system.CloseGuard;
import java.io.FileDescriptor;
import java.util.concurrent.TimeoutException;

public class UsbDeviceConnection {
    private static final String TAG = "UsbDeviceConnection";
    private final UsbDevice mDevice;
    private Context mContext;
    private long mNativeContext;
    private final CloseGuard mCloseGuard = CloseGuard.get();

    public UsbDeviceConnection(UsbDevice device) {
        this.mDevice = device;
    }

    boolean open(String name, ParcelFileDescriptor pfd, Context context) {
        this.mContext = context.getApplicationContext();
        boolean wasOpened = this.native_open(name, pfd.getFileDescriptor());
        if (wasOpened) {
            this.mCloseGuard.open("close");
        }
        return wasOpened;
    }

    public Context getContext() {
        return this.mContext;
    }

    public void close() {
        if (this.mNativeContext != 0L) {
            this.native_close();
            this.mCloseGuard.close();
        }
    }

    public int getFileDescriptor() {
        return this.native_get_fd();
    }

    public byte[] getRawDescriptors() {
        return this.native_get_desc();
    }

    public boolean claimInterface(UsbInterface intf, boolean force) {
        return this.native_claim_interface(intf.getId(), force);
    }

    public boolean releaseInterface(UsbInterface intf) {
        return this.native_release_interface(intf.getId());
    }

    public boolean setInterface(UsbInterface intf) {
        return this.native_set_interface(intf.getId(), intf.getAlternateSetting());
    }

    public boolean setConfiguration(UsbConfiguration configuration) {
        return this.native_set_configuration(configuration.getId());
    }

    public int controlTransfer(int requestType, int request, int value, int index, byte[] buffer, int length, int timeout) {
        return this.controlTransfer(requestType, request, value, index, buffer, 0, length, timeout);
    }

    public int controlTransfer(int requestType, int request, int value, int index, byte[] buffer, int offset, int length, int timeout) {
        UsbDeviceConnection.checkBounds(buffer, offset, length);
        return this.native_control_request(requestType, request, value, index, buffer, offset, length, timeout);
    }

    public int bulkTransfer(UsbEndpoint endpoint, byte[] buffer, int length, int timeout) {
        return this.bulkTransfer(endpoint, buffer, 0, length, timeout);
    }

    public int bulkTransfer(UsbEndpoint endpoint, byte[] buffer, int offset, int length, int timeout) {
        UsbDeviceConnection.checkBounds(buffer, offset, length);
        return this.native_bulk_request(endpoint.getAddress(), buffer, offset, length, timeout);
    }

    @SuppressLint(value={"Doclava125"})
    public boolean resetDevice() {
        return this.native_reset_device();
    }

    public UsbRequest requestWait() {
        UsbRequest request = null;
        try {
            request = this.native_request_wait(-1L);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        if (request != null) {
            request.dequeue(this.mContext.getApplicationInfo().targetSdkVersion >= 26);
        }
        return request;
    }

    public UsbRequest requestWait(long timeout) throws TimeoutException {
        UsbRequest request = this.native_request_wait(timeout = Preconditions.checkArgumentNonnegative(timeout, "timeout"));
        if (request != null) {
            request.dequeue(true);
        }
        return request;
    }

    public String getSerial() {
        return this.native_get_serial();
    }

    private static void checkBounds(byte[] buffer, int start, int length) {
        int bufferLength;
        int n = bufferLength = buffer != null ? buffer.length : 0;
        if (length < 0 || start < 0 || start + length > bufferLength) {
            throw new IllegalArgumentException("Buffer start or length out of bounds.");
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
        }
        finally {
            super.finalize();
        }
    }

    private boolean native_open(String string2, FileDescriptor fileDescriptor) {
        return OverrideMethod.invokeI("android.hardware.usb.UsbDeviceConnection#native_open(Ljava/lang/String;Ljava/io/FileDescriptor;)Z", true, this) != 0;
    }

    private void native_close() {
        OverrideMethod.invokeV("android.hardware.usb.UsbDeviceConnection#native_close()V", true, this);
    }

    private int native_get_fd() {
        return OverrideMethod.invokeI("android.hardware.usb.UsbDeviceConnection#native_get_fd()I", true, this);
    }

    private byte[] native_get_desc() {
        return (byte[])OverrideMethod.invokeA("android.hardware.usb.UsbDeviceConnection#native_get_desc()[B", true, this);
    }

    private boolean native_claim_interface(int n, boolean bl) {
        return OverrideMethod.invokeI("android.hardware.usb.UsbDeviceConnection#native_claim_interface(IZ)Z", true, this) != 0;
    }

    private boolean native_release_interface(int n) {
        return OverrideMethod.invokeI("android.hardware.usb.UsbDeviceConnection#native_release_interface(I)Z", true, this) != 0;
    }

    private boolean native_set_interface(int n, int n2) {
        return OverrideMethod.invokeI("android.hardware.usb.UsbDeviceConnection#native_set_interface(II)Z", true, this) != 0;
    }

    private boolean native_set_configuration(int n) {
        return OverrideMethod.invokeI("android.hardware.usb.UsbDeviceConnection#native_set_configuration(I)Z", true, this) != 0;
    }

    private int native_control_request(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6, int n7) {
        return OverrideMethod.invokeI("android.hardware.usb.UsbDeviceConnection#native_control_request(IIII[BIII)I", true, this);
    }

    private int native_bulk_request(int n, byte[] byArray, int n2, int n3, int n4) {
        return OverrideMethod.invokeI("android.hardware.usb.UsbDeviceConnection#native_bulk_request(I[BIII)I", true, this);
    }

    private UsbRequest native_request_wait(long l) throws TimeoutException {
        return (UsbRequest)OverrideMethod.invokeA("android.hardware.usb.UsbDeviceConnection#native_request_wait(J)Landroid/hardware/usb/UsbRequest;", true, this);
    }

    private String native_get_serial() {
        return (String)OverrideMethod.invokeA("android.hardware.usb.UsbDeviceConnection#native_get_serial()Ljava/lang/String;", true, this);
    }

    private boolean native_reset_device() {
        return OverrideMethod.invokeI("android.hardware.usb.UsbDeviceConnection#native_reset_device()Z", true, this) != 0;
    }
}

