/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.Shader;
import android.graphics.drawable.AdaptiveIconDrawable_Delegate;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.PathParser;
import com.android.internal.R;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class AdaptiveIconDrawable
extends Drawable
implements Drawable.Callback {
    public static final float MASK_SIZE = 100.0f;
    private static final float SAFEZONE_SCALE = 0.9166667f;
    private static final float EXTRA_INSET_PERCENTAGE = 0.25f;
    private static final float DEFAULT_VIEW_PORT_SCALE = 0.6666667f;
    public static Path sMask;
    private final Path mMask;
    private final Matrix mMaskMatrix;
    private final Region mTransparentRegion;
    private Bitmap mMaskBitmap;
    private static final int BACKGROUND_ID = 0;
    private static final int FOREGROUND_ID = 1;
    LayerState mLayerState;
    private Shader mLayersShader;
    private Bitmap mLayersBitmap;
    private final Rect mTmpOutRect = new Rect();
    private Rect mHotspotBounds;
    private boolean mMutated;
    private boolean mSuspendChildInvalidation;
    private boolean mChildRequestedInvalidation;
    private final Canvas mCanvas;
    private Paint mPaint = new Paint(7);

    AdaptiveIconDrawable() {
        this((LayerState)null, null);
        AdaptiveIconDrawable_Delegate.constructor_after(this);
    }

    AdaptiveIconDrawable(LayerState state, Resources res) {
        this.mLayerState = this.createConstantState(state, res);
        if (sMask == null) {
            sMask = PathParser.createPathFromPathData(Resources.getSystem().getString(17039671));
        }
        this.mMask = PathParser.createPathFromPathData(Resources.getSystem().getString(17039671));
        this.mMaskMatrix = new Matrix();
        this.mCanvas = new Canvas();
        this.mTransparentRegion = new Region();
        AdaptiveIconDrawable_Delegate.constructor_after(this);
    }

    private ChildDrawable createChildDrawable(Drawable drawable2) {
        ChildDrawable layer = new ChildDrawable(this.mLayerState.mDensity);
        layer.mDrawable = drawable2;
        layer.mDrawable.setCallback(this);
        this.mLayerState.mChildrenChangingConfigurations |= layer.mDrawable.getChangingConfigurations();
        return layer;
    }

    LayerState createConstantState(LayerState state, Resources res) {
        return new LayerState(state, this, res);
    }

    public AdaptiveIconDrawable(Drawable backgroundDrawable, Drawable foregroundDrawable) {
        this((LayerState)null, null);
        if (backgroundDrawable != null) {
            this.addLayer(0, this.createChildDrawable(backgroundDrawable));
        }
        if (foregroundDrawable != null) {
            this.addLayer(1, this.createChildDrawable(foregroundDrawable));
        }
        AdaptiveIconDrawable_Delegate.constructor_after(this);
    }

    private void addLayer(int index, ChildDrawable layer) {
        this.mLayerState.mChildren[index] = layer;
        this.mLayerState.invalidateCache();
    }

    @Override
    public void inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        super.inflate(r, parser, attrs, theme);
        LayerState state = this.mLayerState;
        if (state == null) {
            return;
        }
        int deviceDensity = Drawable.resolveDensity(r, 0);
        state.setDensity(deviceDensity);
        state.mSrcDensityOverride = this.mSrcDensityOverride;
        ChildDrawable[] array2 = state.mChildren;
        for (int i = 0; i < state.mChildren.length; ++i) {
            ChildDrawable layer = array2[i];
            layer.setDensity(deviceDensity);
        }
        this.inflateLayers(r, parser, attrs, theme);
    }

    public static float getExtraInsetFraction() {
        return 0.25f;
    }

    public static float getExtraInsetPercentage() {
        return 0.25f;
    }

    public Path getIconMask() {
        return this.mMask;
    }

    public Drawable getForeground() {
        return this.mLayerState.mChildren[1].mDrawable;
    }

    public Drawable getBackground() {
        return this.mLayerState.mChildren[0].mDrawable;
    }

    @Override
    protected void onBoundsChange(Rect bounds) {
        if (bounds.isEmpty()) {
            return;
        }
        this.updateLayerBounds(bounds);
    }

    private void updateLayerBounds(Rect bounds) {
        if (bounds.isEmpty()) {
            return;
        }
        try {
            this.suspendChildInvalidation();
            this.updateLayerBoundsInternal(bounds);
            this.updateMaskBoundsInternal(bounds);
        }
        finally {
            this.resumeChildInvalidation();
        }
    }

    private void updateLayerBoundsInternal(Rect bounds) {
        int cX = bounds.width() / 2;
        int cY = bounds.height() / 2;
        int count = 2;
        for (int i = 0; i < count; ++i) {
            Drawable d;
            ChildDrawable r = this.mLayerState.mChildren[i];
            if (r == null || (d = r.mDrawable) == null) continue;
            int insetWidth = (int)((float)bounds.width() / 1.3333334f);
            int insetHeight = (int)((float)bounds.height() / 1.3333334f);
            Rect outRect = this.mTmpOutRect;
            outRect.set(cX - insetWidth, cY - insetHeight, cX + insetWidth, cY + insetHeight);
            d.setBounds(outRect);
        }
    }

    private void updateMaskBoundsInternal(Rect b) {
        this.mMaskMatrix.setScale((float)b.width() / 100.0f, (float)b.height() / 100.0f);
        sMask.transform(this.mMaskMatrix, this.mMask);
        if (this.mMaskBitmap == null || this.mMaskBitmap.getWidth() != b.width() || this.mMaskBitmap.getHeight() != b.height()) {
            this.mMaskBitmap = Bitmap.createBitmap(b.width(), b.height(), Bitmap.Config.ALPHA_8);
            this.mLayersBitmap = Bitmap.createBitmap(b.width(), b.height(), Bitmap.Config.ARGB_8888);
        }
        this.mCanvas.setBitmap(this.mMaskBitmap);
        this.mPaint.setShader(null);
        this.mCanvas.drawPath(this.mMask, this.mPaint);
        this.mMaskMatrix.postTranslate(b.left, b.top);
        this.mMask.reset();
        sMask.transform(this.mMaskMatrix, this.mMask);
        this.mTransparentRegion.setEmpty();
        this.mLayersShader = null;
    }

    @Override
    public void draw(Canvas canvas) {
        if (this.mLayersBitmap == null) {
            return;
        }
        if (this.mLayersShader == null) {
            this.mCanvas.setBitmap(this.mLayersBitmap);
            this.mCanvas.drawColor(-16777216);
            int i = 0;
            while (true) {
                Drawable dr;
                if (i >= 2) break;
                if (this.mLayerState.mChildren[i] != null && (dr = this.mLayerState.mChildren[i].mDrawable) != null) {
                    dr.draw(this.mCanvas);
                }
                ++i;
            }
            this.mLayersShader = new BitmapShader(this.mLayersBitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
            this.mPaint.setShader(this.mLayersShader);
        }
        if (this.mMaskBitmap != null) {
            Rect bounds = this.getBounds();
            canvas.drawBitmap(this.mMaskBitmap, bounds.left, bounds.top, this.mPaint);
        }
    }

    @Override
    public void invalidateSelf() {
        this.mLayersShader = null;
        super.invalidateSelf();
    }

    @Override
    public void getOutline(Outline outline) {
        outline.setConvexPath(this.mMask);
    }

    public Region getSafeZone() {
        this.mMaskMatrix.reset();
        this.mMaskMatrix.setScale(0.9166667f, 0.9166667f, this.getBounds().centerX(), this.getBounds().centerY());
        Path p = new Path();
        this.mMask.transform(this.mMaskMatrix, p);
        Region safezoneRegion = new Region(this.getBounds());
        safezoneRegion.setPath(p, safezoneRegion);
        return safezoneRegion;
    }

    @Override
    public Region getTransparentRegion() {
        if (this.mTransparentRegion.isEmpty()) {
            this.mMask.toggleInverseFillType();
            this.mTransparentRegion.set(this.getBounds());
            this.mTransparentRegion.setPath(this.mMask, this.mTransparentRegion);
            this.mMask.toggleInverseFillType();
        }
        return this.mTransparentRegion;
    }

    @Override
    public void applyTheme(Resources.Theme t) {
        super.applyTheme(t);
        LayerState state = this.mLayerState;
        if (state == null) {
            return;
        }
        int density = Drawable.resolveDensity(t.getResources(), 0);
        state.setDensity(density);
        ChildDrawable[] array2 = state.mChildren;
        int i = 0;
        while (true) {
            Drawable d;
            if (i >= 2) break;
            ChildDrawable layer = array2[i];
            layer.setDensity(density);
            if (layer.mThemeAttrs != null) {
                TypedArray a = t.resolveAttributes(layer.mThemeAttrs, R.styleable.AdaptiveIconDrawableLayer);
                this.updateLayerFromTypedArray(layer, a);
                a.recycle();
            }
            if ((d = layer.mDrawable) != null && d.canApplyTheme()) {
                d.applyTheme(t);
                state.mChildrenChangingConfigurations |= d.getChangingConfigurations();
            }
            ++i;
        }
    }

    private void inflateLayers(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        int depth;
        int type;
        LayerState state = this.mLayerState;
        int innerDepth = parser.getDepth() + 1;
        int childIndex = 0;
        while ((type = parser.next()) != 1 && ((depth = parser.getDepth()) >= innerDepth || type != 3)) {
            if (type != 2 || depth > innerDepth) continue;
            String tagName = parser.getName();
            if (tagName.equals("background")) {
                childIndex = 0;
            } else {
                if (!tagName.equals("foreground")) continue;
                childIndex = 1;
            }
            ChildDrawable layer = new ChildDrawable(state.mDensity);
            TypedArray a = AdaptiveIconDrawable.obtainAttributes(r, theme, attrs, R.styleable.AdaptiveIconDrawableLayer);
            this.updateLayerFromTypedArray(layer, a);
            a.recycle();
            if (layer.mDrawable == null && layer.mThemeAttrs == null) {
                while ((type = parser.next()) == 4) {
                }
                if (type != 2) {
                    throw new XmlPullParserException(parser.getPositionDescription() + ": <foreground> or <background> tag requires a 'drawable'attribute or child tag defining a drawable");
                }
                layer.mDrawable = Drawable.createFromXmlInnerForDensity(r, parser, attrs, this.mLayerState.mSrcDensityOverride, theme);
                layer.mDrawable.setCallback(this);
                state.mChildrenChangingConfigurations |= layer.mDrawable.getChangingConfigurations();
            }
            this.addLayer(childIndex, layer);
        }
    }

    private void updateLayerFromTypedArray(ChildDrawable layer, TypedArray a) {
        LayerState state = this.mLayerState;
        state.mChildrenChangingConfigurations |= a.getChangingConfigurations();
        layer.mThemeAttrs = a.extractThemeAttrs();
        Drawable dr = a.getDrawableForDensity(0, state.mSrcDensityOverride);
        if (dr != null) {
            if (layer.mDrawable != null) {
                layer.mDrawable.setCallback(null);
            }
            layer.mDrawable = dr;
            layer.mDrawable.setCallback(this);
            state.mChildrenChangingConfigurations |= layer.mDrawable.getChangingConfigurations();
        }
    }

    @Override
    public boolean canApplyTheme() {
        return this.mLayerState != null && this.mLayerState.canApplyTheme() || super.canApplyTheme();
    }

    @Override
    public boolean isProjected() {
        if (super.isProjected()) {
            return true;
        }
        ChildDrawable[] layers = this.mLayerState.mChildren;
        int i = 0;
        while (true) {
            if (i >= 2) break;
            if (layers[i].mDrawable.isProjected()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void suspendChildInvalidation() {
        this.mSuspendChildInvalidation = true;
    }

    private void resumeChildInvalidation() {
        this.mSuspendChildInvalidation = false;
        if (this.mChildRequestedInvalidation) {
            this.mChildRequestedInvalidation = false;
            this.invalidateSelf();
        }
    }

    @Override
    public void invalidateDrawable(Drawable who) {
        if (this.mSuspendChildInvalidation) {
            this.mChildRequestedInvalidation = true;
        } else {
            this.invalidateSelf();
        }
    }

    @Override
    public void scheduleDrawable(Drawable who, Runnable what, long when) {
        this.scheduleSelf(what, when);
    }

    @Override
    public void unscheduleDrawable(Drawable who, Runnable what) {
        this.unscheduleSelf(what);
    }

    @Override
    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mLayerState.getChangingConfigurations();
    }

    @Override
    public void setHotspot(float x, float y) {
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int i = 0;
        while (true) {
            if (i >= 2) break;
            Drawable dr = array2[i].mDrawable;
            if (dr != null) {
                dr.setHotspot(x, y);
            }
            ++i;
        }
    }

    @Override
    public void setHotspotBounds(int left, int top, int right, int bottom) {
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int i = 0;
        while (true) {
            if (i >= 2) break;
            Drawable dr = array2[i].mDrawable;
            if (dr != null) {
                dr.setHotspotBounds(left, top, right, bottom);
            }
            ++i;
        }
        if (this.mHotspotBounds == null) {
            this.mHotspotBounds = new Rect(left, top, right, bottom);
        } else {
            this.mHotspotBounds.set(left, top, right, bottom);
        }
    }

    @Override
    public void getHotspotBounds(Rect outRect) {
        if (this.mHotspotBounds != null) {
            outRect.set(this.mHotspotBounds);
        } else {
            super.getHotspotBounds(outRect);
        }
    }

    @Override
    public boolean setVisible(boolean visible, boolean restart) {
        boolean changed = super.setVisible(visible, restart);
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int i = 0;
        while (true) {
            if (i >= 2) break;
            Drawable dr = array2[i].mDrawable;
            if (dr != null) {
                dr.setVisible(visible, restart);
            }
            ++i;
        }
        return changed;
    }

    @Override
    public void setDither(boolean dither) {
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int i = 0;
        while (true) {
            if (i >= 2) break;
            Drawable dr = array2[i].mDrawable;
            if (dr != null) {
                dr.setDither(dither);
            }
            ++i;
        }
    }

    @Override
    public void setAlpha(int alpha) {
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int i = 0;
        while (true) {
            if (i >= 2) break;
            Drawable dr = array2[i].mDrawable;
            if (dr != null) {
                dr.setAlpha(alpha);
            }
            ++i;
        }
    }

    @Override
    public int getAlpha() {
        return -3;
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int i = 0;
        while (true) {
            if (i >= 2) break;
            Drawable dr = array2[i].mDrawable;
            if (dr != null) {
                dr.setColorFilter(colorFilter);
            }
            ++i;
        }
    }

    @Override
    public void setTintList(ColorStateList tint) {
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = 2;
        for (int i = 0; i < N; ++i) {
            Drawable dr = array2[i].mDrawable;
            if (dr == null) continue;
            dr.setTintList(tint);
        }
    }

    @Override
    public void setTintMode(PorterDuff.Mode tintMode) {
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = 2;
        for (int i = 0; i < N; ++i) {
            Drawable dr = array2[i].mDrawable;
            if (dr == null) continue;
            dr.setTintMode(tintMode);
        }
    }

    public void setOpacity(int opacity) {
        this.mLayerState.mOpacityOverride = opacity;
    }

    @Override
    public int getOpacity() {
        if (this.mLayerState.mOpacityOverride != 0) {
            return this.mLayerState.mOpacityOverride;
        }
        return this.mLayerState.getOpacity();
    }

    @Override
    public void setAutoMirrored(boolean mirrored) {
        this.mLayerState.mAutoMirrored = mirrored;
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int i = 0;
        while (true) {
            if (i >= 2) break;
            Drawable dr = array2[i].mDrawable;
            if (dr != null) {
                dr.setAutoMirrored(mirrored);
            }
            ++i;
        }
    }

    @Override
    public boolean isAutoMirrored() {
        return this.mLayerState.mAutoMirrored;
    }

    @Override
    public void jumpToCurrentState() {
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int i = 0;
        while (true) {
            if (i >= 2) break;
            Drawable dr = array2[i].mDrawable;
            if (dr != null) {
                dr.jumpToCurrentState();
            }
            ++i;
        }
    }

    @Override
    public boolean isStateful() {
        return this.mLayerState.isStateful();
    }

    @Override
    public boolean hasFocusStateSpecified() {
        return this.mLayerState.hasFocusStateSpecified();
    }

    @Override
    protected boolean onStateChange(int[] state) {
        boolean changed = false;
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int i = 0;
        while (true) {
            if (i >= 2) break;
            Drawable dr = array2[i].mDrawable;
            if (dr != null && dr.isStateful() && dr.setState(state)) {
                changed = true;
            }
            ++i;
        }
        if (changed) {
            this.updateLayerBounds(this.getBounds());
        }
        return changed;
    }

    @Override
    protected boolean onLevelChange(int level) {
        boolean changed = false;
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int i = 0;
        while (true) {
            if (i >= 2) break;
            Drawable dr = array2[i].mDrawable;
            if (dr != null && dr.setLevel(level)) {
                changed = true;
            }
            ++i;
        }
        if (changed) {
            this.updateLayerBounds(this.getBounds());
        }
        return changed;
    }

    @Override
    public int getIntrinsicWidth() {
        return (int)((float)this.getMaxIntrinsicWidth() * 0.6666667f);
    }

    private int getMaxIntrinsicWidth() {
        int width = -1;
        int i = 0;
        while (true) {
            int w;
            if (i >= 2) break;
            ChildDrawable r = this.mLayerState.mChildren[i];
            if (r.mDrawable != null && (w = r.mDrawable.getIntrinsicWidth()) > width) {
                width = w;
            }
            ++i;
        }
        return width;
    }

    @Override
    public int getIntrinsicHeight() {
        return (int)((float)this.getMaxIntrinsicHeight() * 0.6666667f);
    }

    private int getMaxIntrinsicHeight() {
        int height = -1;
        int i = 0;
        while (true) {
            int h;
            if (i >= 2) break;
            ChildDrawable r = this.mLayerState.mChildren[i];
            if (r.mDrawable != null && (h = r.mDrawable.getIntrinsicHeight()) > height) {
                height = h;
            }
            ++i;
        }
        return height;
    }

    @Override
    public Drawable.ConstantState getConstantState() {
        if (this.mLayerState.canConstantState()) {
            this.mLayerState.mChangingConfigurations = this.getChangingConfigurations();
            return this.mLayerState;
        }
        return null;
    }

    @Override
    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mLayerState = this.createConstantState(this.mLayerState, null);
            int i = 0;
            while (true) {
                if (i >= 2) break;
                Drawable dr = this.mLayerState.mChildren[i].mDrawable;
                if (dr != null) {
                    dr.mutate();
                }
                ++i;
            }
            this.mMutated = true;
        }
        return this;
    }

    @Override
    public void clearMutated() {
        super.clearMutated();
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int i = 0;
        while (true) {
            if (i >= 2) break;
            Drawable dr = array2[i].mDrawable;
            if (dr != null) {
                dr.clearMutated();
            }
            ++i;
        }
        this.mMutated = false;
    }

    static class LayerState
    extends Drawable.ConstantState {
        private int[] mThemeAttrs;
        static final int N_CHILDREN = 2;
        ChildDrawable[] mChildren;
        int mDensity;
        int mSrcDensityOverride = 0;
        int mOpacityOverride = 0;
        int mChangingConfigurations;
        int mChildrenChangingConfigurations;
        private boolean mCheckedOpacity;
        private int mOpacity;
        private boolean mCheckedStateful;
        private boolean mIsStateful;
        private boolean mAutoMirrored = false;

        LayerState(LayerState orig, AdaptiveIconDrawable owner, Resources res) {
            this.mDensity = Drawable.resolveDensity(res, orig != null ? orig.mDensity : 0);
            this.mChildren = new ChildDrawable[2];
            if (orig != null) {
                ChildDrawable[] origChildDrawable = orig.mChildren;
                this.mChangingConfigurations = orig.mChangingConfigurations;
                this.mChildrenChangingConfigurations = orig.mChildrenChangingConfigurations;
                for (int i = 0; i < 2; ++i) {
                    ChildDrawable or = origChildDrawable[i];
                    this.mChildren[i] = new ChildDrawable(or, owner, res);
                }
                this.mCheckedOpacity = orig.mCheckedOpacity;
                this.mOpacity = orig.mOpacity;
                this.mCheckedStateful = orig.mCheckedStateful;
                this.mIsStateful = orig.mIsStateful;
                this.mAutoMirrored = orig.mAutoMirrored;
                this.mThemeAttrs = orig.mThemeAttrs;
                this.mOpacityOverride = orig.mOpacityOverride;
                this.mSrcDensityOverride = orig.mSrcDensityOverride;
            } else {
                for (int i = 0; i < 2; ++i) {
                    this.mChildren[i] = new ChildDrawable(this.mDensity);
                }
            }
        }

        public void setDensity(int targetDensity) {
            if (this.mDensity != targetDensity) {
                this.mDensity = targetDensity;
            }
        }

        @Override
        public boolean canApplyTheme() {
            if (this.mThemeAttrs != null || super.canApplyTheme()) {
                return true;
            }
            ChildDrawable[] array2 = this.mChildren;
            for (int i = 0; i < 2; ++i) {
                ChildDrawable layer = array2[i];
                if (!layer.canApplyTheme()) continue;
                return true;
            }
            return false;
        }

        @Override
        public Drawable newDrawable() {
            return new AdaptiveIconDrawable(this, null);
        }

        @Override
        public Drawable newDrawable(Resources res) {
            return new AdaptiveIconDrawable(this, res);
        }

        @Override
        public int getChangingConfigurations() {
            return this.mChangingConfigurations | this.mChildrenChangingConfigurations;
        }

        public int getOpacity() {
            if (this.mCheckedOpacity) {
                return this.mOpacity;
            }
            ChildDrawable[] array2 = this.mChildren;
            int firstIndex = -1;
            for (int i = 0; i < 2; ++i) {
                if (array2[i].mDrawable == null) continue;
                firstIndex = i;
                break;
            }
            int op = firstIndex >= 0 ? array2[firstIndex].mDrawable.getOpacity() : -2;
            for (int i = firstIndex + 1; i < 2; ++i) {
                Drawable dr = array2[i].mDrawable;
                if (dr == null) continue;
                op = Drawable.resolveOpacity(op, dr.getOpacity());
            }
            this.mOpacity = op;
            this.mCheckedOpacity = true;
            return op;
        }

        public boolean isStateful() {
            if (this.mCheckedStateful) {
                return this.mIsStateful;
            }
            ChildDrawable[] array2 = this.mChildren;
            boolean isStateful = false;
            for (int i = 0; i < 2; ++i) {
                Drawable dr = array2[i].mDrawable;
                if (dr == null || !dr.isStateful()) continue;
                isStateful = true;
                break;
            }
            this.mIsStateful = isStateful;
            this.mCheckedStateful = true;
            return isStateful;
        }

        public boolean hasFocusStateSpecified() {
            ChildDrawable[] array2 = this.mChildren;
            for (int i = 0; i < 2; ++i) {
                Drawable dr = array2[i].mDrawable;
                if (dr == null || !dr.hasFocusStateSpecified()) continue;
                return true;
            }
            return false;
        }

        public boolean canConstantState() {
            ChildDrawable[] array2 = this.mChildren;
            for (int i = 0; i < 2; ++i) {
                Drawable dr = array2[i].mDrawable;
                if (dr == null || dr.getConstantState() != null) continue;
                return false;
            }
            return true;
        }

        public void invalidateCache() {
            this.mCheckedOpacity = false;
            this.mCheckedStateful = false;
        }
    }

    static class ChildDrawable {
        public Drawable mDrawable;
        public int[] mThemeAttrs;
        public int mDensity = 160;

        ChildDrawable(int density) {
            this.mDensity = density;
        }

        ChildDrawable(ChildDrawable orig, AdaptiveIconDrawable owner, Resources res) {
            Drawable clone;
            Drawable dr = orig.mDrawable;
            if (dr != null) {
                Drawable.ConstantState cs = dr.getConstantState();
                clone = cs == null ? dr : (res != null ? cs.newDrawable(res) : cs.newDrawable());
                clone.setCallback(owner);
                clone.setBounds(dr.getBounds());
                clone.setLevel(dr.getLevel());
            } else {
                clone = null;
            }
            this.mDrawable = clone;
            this.mThemeAttrs = orig.mThemeAttrs;
            this.mDensity = Drawable.resolveDensity(res, orig.mDensity);
        }

        public boolean canApplyTheme() {
            return this.mThemeAttrs != null || this.mDrawable != null && this.mDrawable.canApplyTheme();
        }

        public void setDensity(int targetDensity) {
            if (this.mDensity != targetDensity) {
                this.mDensity = targetDensity;
            }
        }
    }
}

