/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm.split;

import android.content.pm.PackageParser;
import android.content.pm.split.SplitAssetLoader;
import android.content.pm.split.SplitDependencyLoader;
import android.content.res.AssetManager;
import android.os._Original_Build;
import android.util.SparseArray;
import java.util.ArrayList;
import java.util.Collections;
import libcore.io.IoUtils;

public class SplitAssetDependencyLoader
extends SplitDependencyLoader<PackageParser.PackageParserException>
implements SplitAssetLoader {
    private final String[] mSplitPaths;
    private final int mFlags;
    private String[][] mCachedPaths;
    private AssetManager[] mCachedAssetManagers;

    public SplitAssetDependencyLoader(PackageParser.PackageLite pkg, SparseArray<int[]> dependencies, int flags) {
        super(dependencies);
        this.mSplitPaths = new String[pkg.splitCodePaths.length + 1];
        this.mSplitPaths[0] = pkg.baseCodePath;
        System.arraycopy(pkg.splitCodePaths, 0, this.mSplitPaths, 1, pkg.splitCodePaths.length);
        this.mFlags = flags;
        this.mCachedPaths = new String[this.mSplitPaths.length][];
        this.mCachedAssetManagers = new AssetManager[this.mSplitPaths.length];
    }

    @Override
    protected boolean isSplitCached(int splitIdx) {
        return this.mCachedAssetManagers[splitIdx] != null;
    }

    private static AssetManager createAssetManagerWithPaths(String[] assetPaths, int flags) throws PackageParser.PackageParserException {
        AssetManager assets = new AssetManager();
        try {
            assets.setConfiguration(0, 0, null, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, _Original_Build.VERSION.RESOURCES_SDK_INT);
            for (String assetPath : assetPaths) {
                if ((flags & 4) != 0 && !PackageParser.isApkPath(assetPath)) {
                    throw new PackageParser.PackageParserException(-100, "Invalid package file: " + assetPath);
                }
                if (assets.addAssetPath(assetPath) != 0) continue;
                throw new PackageParser.PackageParserException(-101, "Failed adding asset path: " + assetPath);
            }
            return assets;
        }
        catch (Throwable e) {
            IoUtils.closeQuietly(assets);
            throw e;
        }
    }

    @Override
    protected void constructSplit(int splitIdx, int[] configSplitIndices, int parentSplitIdx) throws PackageParser.PackageParserException {
        ArrayList<String> assetPaths = new ArrayList<String>();
        if (parentSplitIdx >= 0) {
            Collections.addAll(assetPaths, this.mCachedPaths[parentSplitIdx]);
        }
        assetPaths.add(this.mSplitPaths[splitIdx]);
        for (int configSplitIdx : configSplitIndices) {
            assetPaths.add(this.mSplitPaths[configSplitIdx]);
        }
        this.mCachedPaths[splitIdx] = assetPaths.toArray(new String[assetPaths.size()]);
        this.mCachedAssetManagers[splitIdx] = SplitAssetDependencyLoader.createAssetManagerWithPaths(this.mCachedPaths[splitIdx], this.mFlags);
    }

    @Override
    public AssetManager getBaseAssetManager() throws PackageParser.PackageParserException {
        this.loadDependenciesForSplit(0);
        return this.mCachedAssetManagers[0];
    }

    @Override
    public AssetManager getSplitAssetManager(int idx) throws PackageParser.PackageParserException {
        this.loadDependenciesForSplit(idx + 1);
        return this.mCachedAssetManagers[idx + 1];
    }

    @Override
    public void close() throws Exception {
        for (AssetManager assets : this.mCachedAssetManagers) {
            IoUtils.closeQuietly(assets);
        }
    }
}

