/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.ArrayUtils;
import java.io.ByteArrayInputStream;
import java.lang.ref.SoftReference;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;

public class Signature
implements Parcelable {
    private final byte[] mSignature;
    private int mHashCode;
    private boolean mHaveHashCode;
    private SoftReference<String> mStringRef;
    private Certificate[] mCertificateChain;
    public static final Parcelable.Creator<Signature> CREATOR = new Parcelable.Creator<Signature>(){

        @Override
        public Signature createFromParcel(Parcel source) {
            return new Signature(source);
        }

        public Signature[] newArray(int size) {
            return new Signature[size];
        }
    };

    public Signature(byte[] signature) {
        this.mSignature = (byte[])signature.clone();
        this.mCertificateChain = null;
    }

    public Signature(Certificate[] certificateChain) throws CertificateEncodingException {
        this.mSignature = certificateChain[0].getEncoded();
        if (certificateChain.length > 1) {
            this.mCertificateChain = Arrays.copyOfRange(certificateChain, 1, certificateChain.length);
        }
    }

    private static int parseHexDigit(int nibble) {
        if (48 <= nibble && nibble <= 57) {
            return nibble - 48;
        }
        if (97 <= nibble && nibble <= 102) {
            return nibble - 97 + 10;
        }
        if (65 <= nibble && nibble <= 70) {
            return nibble - 65 + 10;
        }
        throw new IllegalArgumentException("Invalid character " + nibble + " in hex string");
    }

    public Signature(String text) {
        byte[] input = text.getBytes();
        int N = input.length;
        if (N % 2 != 0) {
            throw new IllegalArgumentException("text size " + N + " is not even");
        }
        byte[] sig = new byte[N / 2];
        int sigIndex = 0;
        int i = 0;
        while (i < N) {
            int hi = Signature.parseHexDigit(input[i++]);
            int lo = Signature.parseHexDigit(input[i++]);
            sig[sigIndex++] = (byte)(hi << 4 | lo);
        }
        this.mSignature = sig;
    }

    public char[] toChars() {
        return this.toChars(null, null);
    }

    public char[] toChars(char[] existingArray, int[] outLen) {
        byte[] sig = this.mSignature;
        int N = sig.length;
        int N2 = N * 2;
        char[] text = existingArray == null || N2 > existingArray.length ? new char[N2] : existingArray;
        for (int j = 0; j < N; ++j) {
            byte v = sig[j];
            int d = v >> 4 & 0xF;
            text[j * 2] = (char)(d >= 10 ? 97 + d - 10 : 48 + d);
            d = v & 0xF;
            text[j * 2 + 1] = (char)(d >= 10 ? 97 + d - 10 : 48 + d);
        }
        if (outLen != null) {
            outLen[0] = N;
        }
        return text;
    }

    public String toCharsString() {
        String str;
        String string2 = str = this.mStringRef == null ? null : this.mStringRef.get();
        if (str != null) {
            return str;
        }
        str = new String(this.toChars());
        this.mStringRef = new SoftReference<String>(str);
        return str;
    }

    public byte[] toByteArray() {
        byte[] bytes = new byte[this.mSignature.length];
        System.arraycopy(this.mSignature, 0, bytes, 0, this.mSignature.length);
        return bytes;
    }

    public PublicKey getPublicKey() throws CertificateException {
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream bais = new ByteArrayInputStream(this.mSignature);
        Certificate cert = certFactory.generateCertificate(bais);
        return cert.getPublicKey();
    }

    public Signature[] getChainSignatures() throws CertificateEncodingException {
        if (this.mCertificateChain == null) {
            return new Signature[]{this};
        }
        Signature[] chain = new Signature[1 + this.mCertificateChain.length];
        chain[0] = this;
        int i = 1;
        for (Certificate c : this.mCertificateChain) {
            chain[i++] = new Signature(c.getEncoded());
        }
        return chain;
    }

    public boolean equals(Object obj) {
        try {
            if (obj != null) {
                Signature other = (Signature)obj;
                return this == other || Arrays.equals(this.mSignature, other.mSignature);
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return false;
    }

    public int hashCode() {
        if (this.mHaveHashCode) {
            return this.mHashCode;
        }
        this.mHashCode = Arrays.hashCode(this.mSignature);
        this.mHaveHashCode = true;
        return this.mHashCode;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int parcelableFlags) {
        dest.writeByteArray(this.mSignature);
    }

    private Signature(Parcel source) {
        this.mSignature = source.createByteArray();
    }

    public static boolean areExactMatch(Signature[] a, Signature[] b) {
        return a.length == b.length && ArrayUtils.containsAll(a, b) && ArrayUtils.containsAll(b, a);
    }

    public static boolean areEffectiveMatch(Signature[] a, Signature[] b) throws CertificateException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        Signature[] aPrime = new Signature[a.length];
        for (int i = 0; i < a.length; ++i) {
            aPrime[i] = Signature.bounce(cf, a[i]);
        }
        Signature[] bPrime = new Signature[b.length];
        for (int i = 0; i < b.length; ++i) {
            bPrime[i] = Signature.bounce(cf, b[i]);
        }
        return Signature.areExactMatch(aPrime, bPrime);
    }

    public static Signature bounce(CertificateFactory cf, Signature s) throws CertificateException {
        ByteArrayInputStream is = new ByteArrayInputStream(s.mSignature);
        X509Certificate cert = (X509Certificate)cf.generateCertificate(is);
        Signature sPrime = new Signature(cert.getEncoded());
        if (Math.abs(sPrime.mSignature.length - s.mSignature.length) > 2) {
            throw new CertificateException("Bounced cert length looks fishy; before " + s.mSignature.length + ", after " + sPrime.mSignature.length);
        }
        return sPrime;
    }
}

