/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.cloudfoundry.agent.cloud;

import com.intellij.javaee.cloudfoundry.agent.base.cloud.CFCloudAgentBase;
import com.intellij.javaee.cloudfoundry.agent.cloud.CFCloudAgentApplicationV2Impl;
import com.intellij.javaee.cloudfoundry.agent.cloud.CFCloudAgentConfiguration;
import com.intellij.javaee.cloudfoundry.agent.cloud.CFCloudAgentDeploymentConfiguration;
import com.intellij.javaee.cloudfoundry.agent.cloud.CFCloudAgentDeploymentV2Impl;
import com.intellij.javaee.cloudfoundry.agent.cloud.CFCloudAgentV2;
import com.intellij.javaee.cloudfoundry.agent.cloud.WarningBypassingErrorHandler;
import com.intellij.javaee.cloudfoundry.agent.settings.CFAppSettingsRange;
import com.intellij.javaee.cloudfoundry.agent.settings.CFAppSettingsRangeImpl;
import com.intellij.javaee.cloudfoundry.agent.wrappers.CFApplication;
import com.intellij.javaee.cloudfoundry.agent.wrappers.CFApplicationV2Impl;
import com.intellij.javaee.cloudfoundry.agent.wrappers.CFOrganization;
import com.intellij.javaee.cloudfoundry.agent.wrappers.CFOrganizationImpl;
import com.intellij.javaee.cloudfoundry.agent.wrappers.CFSpacesDomain;
import com.intellij.remoteServer.agent.util.CloudAgentApplication;
import com.intellij.remoteServer.agent.util.CloudAgentDeployment;
import com.intellij.remoteServer.agent.util.CloudAgentLoggingHandler;
import com.intellij.remoteServer.agent.util.CloudProxySettings;
import com.intellij.remoteServer.agent.util.CloudRemoteApplication;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.cloudfoundry.client.lib.CloudCredentials;
import org.cloudfoundry.client.lib.CloudFoundryClient;
import org.cloudfoundry.client.lib.HttpProxyConfiguration;
import org.cloudfoundry.client.lib.domain.CloudApplication;
import org.cloudfoundry.client.lib.domain.CloudOrganization;
import org.cloudfoundry.client.lib.domain.CloudSpace;
import org.springframework.web.client.ResponseErrorHandler;

public class CFCloudAgentV2Impl
extends CFCloudAgentBase
implements CFCloudAgentV2 {
    private final WarningBypassingErrorHandler myResponseErrorHandler = new WarningBypassingErrorHandler();
    private CloudFoundryClient myClient;

    protected void doConnect(CFCloudAgentConfiguration config) throws MalformedURLException {
        String providerUrl = config.getLocationApiUrl();
        URL apiUrl = new URL(providerUrl);
        CloudCredentials credentials = new CloudCredentials(config.getEmail(), config.getPasswordSafe());
        String organization = config.getOrganization();
        String space = config.getSpace();
        CloudProxySettings proxySettings = config.getProxySettings();
        HttpProxyConfiguration proxyConfiguration = null;
        if (proxySettings.useHttpProxy()) {
            proxyConfiguration = new HttpProxyConfiguration(proxySettings.getHost(), proxySettings.getPort());
        }
        boolean trustSelfSignedCert = config.isTrustSelfSignedCert();
        this.myClient = !organization.isEmpty() || !space.isEmpty() ? new CloudFoundryClient(credentials, apiUrl, organization, space, proxyConfiguration, trustSelfSignedCert) : new CloudFoundryClient(credentials, apiUrl, proxyConfiguration, trustSelfSignedCert);
        this.myClient.setResponseErrorHandler((ResponseErrorHandler)this.myResponseErrorHandler);
        this.myClient.login();
    }

    public WarningBypassingErrorHandler getResponseErrorHandler() {
        return this.myResponseErrorHandler;
    }

    public CloudAgentDeployment createDeployment(CFCloudAgentDeploymentConfiguration config, CloudAgentLoggingHandler loggingHandler) {
        return new CFCloudAgentDeploymentV2Impl(this, this.myClient, config, loggingHandler);
    }

    public CFAppSettingsRange getAppSettingsRange() {
        return (CFAppSettingsRange)new CFCloudAgentBase.ApiTask<CFAppSettingsRange>(){

            protected CFAppSettingsRange doPerform() {
                int[] generalChoices = new int[]{64, 128, 256, 512, 1024, 2048};
                int maxMemory = CFCloudAgentV2Impl.this.myClient.getCloudInfo().getLimits().getMaxTotalMemory();
                int length = 0;
                for (int generalChoice : generalChoices) {
                    if (generalChoice > maxMemory) continue;
                    ++length;
                }
                int[] memoryChoices = new int[length];
                System.arraycopy(generalChoices, 0, memoryChoices, 0, length);
                return new CFAppSettingsRangeImpl(memoryChoices);
            }
        }.perform();
    }

    public CFSpacesDomain getSpacesDomain() {
        return (CFSpacesDomain)new CFCloudAgentBase.ApiTask<CFSpacesDomain>(){

            protected CFSpacesDomain doPerform() {
                return new CFSpacesDomainImpl();
            }
        }.perform();
    }

    public List<CFApplication> doGetApplications() {
        ArrayList<CFApplication> result = new ArrayList<CFApplication>();
        for (CloudApplication application : this.myClient.getApplications()) {
            result.add(new CFApplicationV2Impl(application));
        }
        return result;
    }

    public CloudAgentApplication createApplication(CloudRemoteApplication applicationIdentity) {
        return new CFCloudAgentApplicationV2Impl(this, this.myClient, applicationIdentity.getName());
    }

    private class CFSpacesDomainImpl
    implements CFSpacesDomain {
        private final List<CFOrganization> myOrganizations = new ArrayList<CFOrganization>();

        CFSpacesDomainImpl() {
            List organizations = CFCloudAgentV2Impl.this.myClient.getOrganizations();
            HashMap<String, CFOrganizationImpl> organizationsMap = new HashMap<String, CFOrganizationImpl>();
            for (CloudOrganization organization : organizations) {
                CFOrganizationImpl org = new CFOrganizationImpl(organization);
                this.myOrganizations.add(org);
                organizationsMap.put(organization.getName(), org);
            }
            for (CloudSpace space : CFCloudAgentV2Impl.this.myClient.getSpaces()) {
                String orgName = space.getOrganization().getName();
                String spaceName = space.getName();
                ((CFOrganizationImpl)organizationsMap.get(orgName)).addSpace(spaceName);
            }
        }

        public CFOrganization[] getOrganizations() {
            return this.myOrganizations.toArray(new CFOrganization[0]);
        }
    }
}

