/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.play.utils.processors;

import com.intellij.play.utils.PlayPathUtils;
import com.intellij.play.utils.PlayUtils;
import com.intellij.play.utils.beans.PlayImplicitVariable;
import com.intellij.play.utils.processors.PlayDeclarationsProcessor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.SearchScope;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class RenderArgProcessor
implements PlayDeclarationsProcessor {
    @Override
    public boolean processElement(PsiScopeProcessor processor, ResolveState state, PsiElement scope) {
        for (PlayImplicitVariable playImplicitVariable : RenderArgProcessor.getRenderArgs(scope)) {
            if (ResolveUtil.processElement((PsiScopeProcessor)processor, (PsiNamedElement)playImplicitVariable, (ResolveState)state)) continue;
            return false;
        }
        return true;
    }

    public static Set<PlayImplicitVariable> getRenderArgs(PsiElement scope) {
        PsiMethod psiMethod;
        HashSet<PlayImplicitVariable> set = new HashSet<PlayImplicitVariable>();
        PsiFile psiFile = scope.getContainingFile();
        PsiClass controller = PlayPathUtils.getCorrespondingController(psiFile);
        if (controller != null && (psiMethod = RenderArgProcessor.getRenderArgPutMethod(psiFile)) != null) {
            set.addAll(PlayUtils.getPutMethodInitVariables(psiMethod, (SearchScope)PlayUtils.getPsiClassLocalScope(controller)).values());
        }
        return set;
    }

    @Nullable
    private static PsiMethod getRenderArgPutMethod(PsiFile file) {
        PsiClass correspondingController = PlayPathUtils.getCorrespondingController(file);
        if (correspondingController != null) {
            for (PsiField psiField : correspondingController.getAllFields()) {
                if (!"renderArgs".equals(psiField.getName())) continue;
                PsiClass psiClass = ((PsiClassType)psiField.getType()).resolve();
                if (psiClass != null) {
                    for (PsiMethod psiMethod : psiClass.getMethods()) {
                        if (!"put".equals(psiMethod.getName())) continue;
                        return psiMethod;
                    }
                }
                return null;
            }
        }
        return null;
    }
}

