/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.play.language;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.play.language.PlayFileElementTypes;
import com.intellij.play.language.PlayLanguage;
import com.intellij.play.language.groovy.PlayGroovyFileImpl;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.templateLanguages.ConfigurableTemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;

public class PlayFileViewProvider
extends MultiplePsiFilesPerDocumentFileViewProvider
implements ConfigurableTemplateLanguageFileViewProvider {
    public PlayFileViewProvider(PsiManager manager, VirtualFile virtualFile, boolean physical) {
        super(manager, virtualFile, physical);
    }

    @NotNull
    public Language getBaseLanguage() {
        PlayLanguage playLanguage = PlayLanguage.INSTANCE;
        if (playLanguage == null) {
            PlayFileViewProvider.$$$reportNull$$$0(0);
        }
        return playLanguage;
    }

    @NotNull
    public Set<Language> getLanguages() {
        THashSet tHashSet = new THashSet(Arrays.asList(this.getBaseLanguage(), this.getTemplateDataLanguage(), this.getGroovyLanguage()));
        if (tHashSet == null) {
            PlayFileViewProvider.$$$reportNull$$$0(1);
        }
        return tHashSet;
    }

    @NotNull
    protected PlayFileViewProvider cloneInner(@NotNull VirtualFile copy) {
        if (copy == null) {
            PlayFileViewProvider.$$$reportNull$$$0(2);
        }
        PlayFileViewProvider playFileViewProvider = new PlayFileViewProvider((PsiManager)this.getManager(), copy, false);
        if (playFileViewProvider == null) {
            PlayFileViewProvider.$$$reportNull$$$0(3);
        }
        return playFileViewProvider;
    }

    @NotNull
    public Language getTemplateDataLanguage() {
        Language language = StdLanguages.HTML;
        if (language == null) {
            PlayFileViewProvider.$$$reportNull$$$0(4);
        }
        return language;
    }

    @Nullable
    protected PsiFile createFile(@NotNull Language lang) {
        if (lang == null) {
            PlayFileViewProvider.$$$reportNull$$$0(5);
        }
        if (lang == this.getBaseLanguage()) {
            return ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang)).createFile((FileViewProvider)this);
        }
        if (lang == this.getTemplateDataLanguage()) {
            PsiFileImpl file = (PsiFileImpl)((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang)).createFile((FileViewProvider)this);
            file.setContentElementType((IElementType)PlayFileElementTypes.TEMPLATE_DATA);
            return file;
        }
        if (lang == this.getGroovyLanguage()) {
            return new PlayGroovyFileImpl((FileViewProvider)this);
        }
        return null;
    }

    public Language getGroovyLanguage() {
        return GroovyLanguage.INSTANCE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/play/language/PlayFileViewProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copy";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lang";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseLanguage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguages";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/play/language/PlayFileViewProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneInner";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateDataLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "cloneInner";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

