/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.PairedUnfairLocalInspectionTool;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.javascript.JSFunctionWithSubstitutor;
import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.inspections.unusedsymbols.JSUnusedGlobalSymbolsPass;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class JSUnusedGlobalSymbolsInspection
extends JSInspection
implements PairedUnfairLocalInspectionTool {
    public static final String SHORT_NAME = JSUnusedGlobalSymbolsInspection.calcShortNameFromClass(JSUnusedGlobalSymbolsInspection.class);
    public boolean myReportUnusedDefinitions;
    public boolean myReportUnusedProperties;
    public static final Key<CachedValue<Set<PsiElement>>> CANDIDATE_ELEMENTS_KEY = Key.create((String)"js.unused.global.symbols.candidates");

    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"js.unused.global.symbol.inspection.name", (Object[])new Object[0]);
        if (string == null) {
            JSUnusedGlobalSymbolsInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    protected JSElementVisitor createVisitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSUnusedGlobalSymbolsInspection.$$$reportNull$$$0(1);
        }
        if (session == null) {
            JSUnusedGlobalSymbolsInspection.$$$reportNull$$$0(2);
        }
        PsiFile file2 = holder.getFile();
        final Set candidates = (Set)CachedValuesManager.getCachedValue((PsiElement)file2, CANDIDATE_ELEMENTS_KEY, () -> new CachedValueProvider.Result((Object)new THashSet(), new Object[]{file2}));
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            private void queueCandidate(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                candidates.add(element);
            }

            public void visitJSReferenceExpression(JSReferenceExpression node) {
                if (!JSResolveUtil.isSelfReference((PsiElement)node) || !(node.getParent() instanceof JSNamedElement)) {
                    return;
                }
                JSNamedElement parent = (JSNamedElement)node.getParent();
                if (parent instanceof JSFunctionExpression || parent instanceof JSClassExpression) {
                    return;
                }
                this.queueCandidate((PsiElement)node);
            }

            public void visitES6ExportDefaultAssignment(ES6ExportDefaultAssignment node) {
                this.queueCandidate((PsiElement)node);
            }

            public void visitES6ExportDeclaration(ES6ExportDeclaration exportDeclaration) {
                this.queueCandidate((PsiElement)exportDeclaration);
            }

            public void visitJSFunctionExpression(JSFunctionExpression node) {
                this.queueCandidate((PsiElement)node);
            }

            public void visitJSFunctionDeclaration(JSFunction node) {
                this.queueCandidate((PsiElement)node);
            }

            public void visitJSVariable(JSVariable node) {
                this.queueCandidate((PsiElement)node);
            }

            public void visitJSDefinitionExpression(JSDefinitionExpression node) {
                JSExpression expression = node.getExpression();
                if (expression instanceof JSReferenceExpression) {
                    JSExpression qualifier = ((JSReferenceExpression)expression).getQualifier();
                    boolean doCheck = JSUnusedGlobalSymbolsInspection.this.myReportUnusedDefinitions;
                    if (qualifier instanceof JSThisExpression || qualifier instanceof JSReferenceExpression && "prototype".equals(((JSReferenceExpression)qualifier).getReferenceName())) {
                        doCheck = true;
                    }
                    if (doCheck) {
                        this.queueCandidate((PsiElement)node);
                    }
                }
            }

            public void visitJSProperty(JSProperty node) {
                Collection<JSFunctionWithSubstitutor> functions = JSStubBasedPsiTreeUtil.calculatePossibleFunctions((PsiElement)node, null, true);
                if (JSUnusedGlobalSymbolsInspection.this.myReportUnusedProperties || !functions.isEmpty()) {
                    this.queueCandidate((PsiElement)node);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/inspections/JSUnusedGlobalSymbolsInspection$1", "queueCandidate"));
            }
        };
        if (jSElementVisitor == null) {
            JSUnusedGlobalSymbolsInspection.$$$reportNull$$$0(3);
        }
        return jSElementVisitor;
    }

    @NotNull
    public String getInspectionForBatchShortName() {
        String string = this.getShortName();
        if (string == null) {
            JSUnusedGlobalSymbolsInspection.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void inspectionFinished(@NotNull LocalInspectionToolSession session, @NotNull ProblemsHolder problemsHolder) {
        if (session == null) {
            JSUnusedGlobalSymbolsInspection.$$$reportNull$$$0(5);
        }
        if (problemsHolder == null) {
            JSUnusedGlobalSymbolsInspection.$$$reportNull$$$0(6);
        }
        if (this.myOnTheFly) {
            return;
        }
        ArrayList unusedSymbols = ContainerUtil.newArrayList();
        JSUnusedGlobalSymbolsPass.searchForUnusedSymbols(session.getFile(), unusedSymbols);
        for (PsiElement unusedSymbol : unusedSymbols) {
            JSUnusedGlobalSymbolsPass.JSUnusedSymbolProblemDescriptor descriptor2 = JSUnusedGlobalSymbolsPass.registerProblem(unusedSymbol);
            if (descriptor2 == null) continue;
            TextRange range = descriptor2.myRange;
            if (range != null) {
                range = range.shiftLeft(descriptor2.myIdentifier.getTextRange().getStartOffset());
            }
            problemsHolder.registerProblem(descriptor2.myIdentifier, range, descriptor2.myMessage, descriptor2.myFixes);
        }
    }

    @NotNull
    public static GlobalSearchScope skipLibraryFiles(final @NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (project == null) {
            JSUnusedGlobalSymbolsInspection.$$$reportNull$$$0(7);
        }
        if (scope == null) {
            JSUnusedGlobalSymbolsInspection.$$$reportNull$$$0(8);
        }
        DelegatingGlobalSearchScope delegatingGlobalSearchScope = new DelegatingGlobalSearchScope(scope){

            public boolean contains(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!super.contains(file2)) {
                    return false;
                }
                return !JSLibraryUtil.isProbableLibraryFile(file2, project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/inspections/JSUnusedGlobalSymbolsInspection$2", "contains"));
            }
        };
        if (delegatingGlobalSearchScope == null) {
            JSUnusedGlobalSymbolsInspection.$$$reportNull$$$0(9);
        }
        return delegatingGlobalSearchScope;
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(JSBundle.message((String)"javascript.report.unused.properties", (Object[])new Object[0]), "myReportUnusedProperties");
        optionsPanel.addCheckbox(JSBundle.message((String)"javascript.report.unused.definitions", (Object[])new Object[0]), "myReportUnusedDefinitions");
        return optionsPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSUnusedGlobalSymbolsInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemsHolder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSUnusedGlobalSymbolsInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionForBatchShortName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "skipLibraryFiles";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "inspectionFinished";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "skipLibraryFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

