/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class JSComparisonWithNaNInspection
extends JSInspection {
    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"js.comparison.with.nan.inspection.name", (Object[])new Object[0]);
        if (string == null) {
            JSComparisonWithNaNInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSBinaryExpression(JSBinaryExpression node) {
                JSExpression exprComparedToNaN;
                IElementType sign = node.getOperationSign();
                if ((sign == JSTokenTypes.EQEQEQ || sign == JSTokenTypes.EQEQ || sign == JSTokenTypes.NEQEQ || sign == JSTokenTypes.NE) && (exprComparedToNaN = JSComparisonWithNaNInspection.findExpressionComparedToNaN(node)) != null) {
                    boolean addNot = sign == JSTokenTypes.NE || sign == JSTokenTypes.NEQEQ;
                    holder.registerProblem((PsiElement)node, JSBundle.message((String)(addNot ? "js.comparison.with.nan.inspection.problem2" : "js.comparison.with.nan.inspection.problem"), (Object[])new Object[0]), new LocalQuickFix[]{new JSReplaceWithIsNaNCallQuickFix(addNot)});
                }
            }
        };
        if (jSElementVisitor == null) {
            JSComparisonWithNaNInspection.$$$reportNull$$$0(1);
        }
        return jSElementVisitor;
    }

    private static JSExpression findExpressionComparedToNaN(JSBinaryExpression node) {
        JSExpression lOperand = node.getLOperand();
        JSExpression rOperand = node.getROperand();
        JSExpression exprComparedToNaN = null;
        if (lOperand instanceof JSReferenceExpression && "NaN".equals(lOperand.getText())) {
            exprComparedToNaN = rOperand;
        } else if (rOperand instanceof JSReferenceExpression && "NaN".equals(rOperand.getText())) {
            exprComparedToNaN = lOperand;
        }
        return exprComparedToNaN;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/javascript/inspections/JSComparisonWithNaNInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    static class JSReplaceWithIsNaNCallQuickFix
    implements LocalQuickFix {
        private final boolean myAddNot;

        JSReplaceWithIsNaNCallQuickFix(boolean addNot) {
            this.myAddNot = addNot;
        }

        @NotNull
        public String getFamilyName() {
            String string = JSBundle.message((String)"js.comparison.with.nan.inspection.quickfix", (Object[])new Object[]{this.myAddNot ? "!" : ""});
            if (string == null) {
                JSReplaceWithIsNaNCallQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            if (project == null) {
                JSReplaceWithIsNaNCallQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                JSReplaceWithIsNaNCallQuickFix.$$$reportNull$$$0(2);
            }
            JSBinaryExpression node = (JSBinaryExpression)descriptor2.getPsiElement();
            JSExpression expression = JSComparisonWithNaNInspection.findExpressionComparedToNaN(node);
            PsiFile file2 = node.getContainingFile();
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file2);
            if (document != null) {
                document.replaceString(node.getTextRange().getStartOffset(), node.getTextRange().getEndOffset(), (CharSequence)((this.myAddNot ? "!" : "") + "isNaN(" + expression.getText() + ")"));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/JSComparisonWithNaNInspection$JSReplaceWithIsNaNCallQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/JSComparisonWithNaNInspection$JSReplaceWithIsNaNCallQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

