/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.heroku.cloud.module;

import com.intellij.javaee.heroku.cloud.HerokuAppTemplate;
import com.intellij.javaee.heroku.cloud.HerokuCloudConfiguration;
import com.intellij.javaee.heroku.cloud.HerokuDeploymentConfiguration;
import com.intellij.javaee.heroku.cloud.HerokuServerRuntimeInstance;
import com.intellij.javaee.heroku.cloud.module.HerokuApplicationConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.remoteServer.impl.module.CloudSourceApplicationConfigurable;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class HerokuApplicationConfigurable
extends CloudSourceApplicationConfigurable<HerokuCloudConfiguration, HerokuDeploymentConfiguration, HerokuServerRuntimeInstance, HerokuApplicationConfiguration> {
    private static final HerokuAppTemplate[] APP_TEMPLATES = new HerokuAppTemplate[]{new HerokuAppTemplate("java-sample"), new HerokuAppTemplate("java-spring-sample")};
    private JPanel myMainPanel;
    private ComboBox myTemplateComboBox;
    private JBRadioButton myTemplateRadioButton;
    private JBRadioButton myExistingRadioButton;
    private ComboBox myExistingComboBox;

    public HerokuApplicationConfigurable(Project project, Disposable parentDisposable) {
        super(project, parentDisposable);
        this.$$$setupUI$$$();
        ActionListener updateApplicationListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HerokuApplicationConfigurable.this.updateApplicationUI();
            }
        };
        this.myTemplateRadioButton.addActionListener(updateApplicationListener);
        this.myExistingRadioButton.addActionListener(updateApplicationListener);
        this.myExistingComboBox.addActionListener(updateApplicationListener);
        for (HerokuAppTemplate appTemplate : APP_TEMPLATES) {
            this.myTemplateComboBox.addItem((Object)appTemplate);
        }
        this.myTemplateRadioButton.setSelected(true);
    }

    private void updateApplicationUI() {
        this.myTemplateComboBox.setEnabled(this.myTemplateRadioButton.isSelected());
        boolean isExisting = this.myExistingRadioButton.isSelected();
        this.myExistingComboBox.setEnabled(isExisting);
    }

    protected JComboBox getExistingComboBox() {
        return this.myExistingComboBox;
    }

    public JComponent getMainPanel() {
        return this.myMainPanel;
    }

    public HerokuApplicationConfiguration createConfiguration() {
        return new HerokuApplicationConfiguration(this.myTemplateRadioButton.isSelected(), (HerokuAppTemplate)this.myTemplateComboBox.getSelectedItem(), this.myExistingRadioButton.isSelected(), (String)this.myExistingComboBox.getSelectedItem());
    }

    public void validate() throws ConfigurationException {
        if (this.myExistingRadioButton.isSelected() && this.myExistingComboBox.getSelectedItem() == null) {
            throw new ConfigurationException("Existing application should be chosen");
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ComboBox comboBox;
        JBRadioButton jBRadioButton;
        JBRadioButton jBRadioButton2;
        ComboBox comboBox2;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myTemplateComboBox = comboBox2 = new ComboBox();
        jPanel.add((Component)comboBox2, new GridConstraints(0, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        this.myTemplateRadioButton = jBRadioButton2 = new JBRadioButton();
        jBRadioButton2.setSelected(false);
        jBRadioButton2.setText("Template:");
        jPanel.add((Component)jBRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myExistingRadioButton = jBRadioButton = new JBRadioButton();
        jBRadioButton.setText("Existing:");
        jPanel.add((Component)jBRadioButton, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myExistingComboBox = comboBox = new ComboBox();
        jPanel.add((Component)comboBox, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)jBRadioButton2);
        buttonGroup.add((AbstractButton)jBRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

