/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.heroku.cloud;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.javaee.heroku.agent.cloud.HerokuCloudAgentConfig;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.util.CloudConfigurationBase;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Transient;
import org.jetbrains.annotations.Nullable;

public class HerokuCloudConfiguration
extends CloudConfigurationBase<HerokuCloudConfiguration>
implements HerokuCloudAgentConfig {
    private String myApiKey;

    @Attribute(value="apiKey")
    public String getApiKey() {
        return this.myApiKey;
    }

    public void setApiKey(String apiKey) {
        this.myApiKey = apiKey;
    }

    @Transient
    public void setApiKeySafe(String apiKey) {
        CredentialAttributes credentialAttributes = this.createCredentialAttributes(true);
        HerokuCloudConfiguration.doSetSafeValue((CredentialAttributes)credentialAttributes, (String)this.getCredentialUser(), (String)apiKey, this::setApiKey);
    }

    @Override
    @Transient
    public String getApiKeySafe() {
        CredentialAttributes apiKeyAttributes = this.createCredentialAttributes(true);
        return HerokuCloudConfiguration.doGetSafeValue((CredentialAttributes)apiKeyAttributes, this::getApiKey);
    }

    @Transient
    public void setPasswordSafe(String password) {
        CredentialAttributes passwordAttributes = this.createCredentialAttributes(false);
        HerokuCloudConfiguration.doSetSafeValue((CredentialAttributes)passwordAttributes, (String)this.getCredentialUser(), (String)password, arg_0 -> ((HerokuCloudConfiguration)this).setPassword(arg_0));
    }

    public String getPasswordSafe() {
        CredentialAttributes passwordAttributes = this.createCredentialAttributes(false);
        return HerokuCloudConfiguration.doGetSafeValue((CredentialAttributes)passwordAttributes, () -> ((HerokuCloudConfiguration)this).getPassword());
    }

    public boolean isPasswordSafe() {
        return HerokuCloudConfiguration.hasSafeCredentials((CredentialAttributes)this.createCredentialAttributes(false));
    }

    @Transient
    public boolean isApiKeySafe() {
        return HerokuCloudConfiguration.hasSafeCredentials((CredentialAttributes)this.createCredentialAttributes(true));
    }

    @Nullable
    protected String getServiceName() {
        throw new UnsupportedOperationException();
    }

    @Nullable
    protected CredentialAttributes createCredentialAttributes() {
        throw new UnsupportedOperationException();
    }

    private CredentialAttributes createCredentialAttributes(boolean apiKeyNotPassword) {
        String credentialUser = this.getCredentialUser();
        String serviceName = this.createServiceName(apiKeyNotPassword);
        return HerokuCloudConfiguration.createCredentialAttributes((String)serviceName, (String)credentialUser);
    }

    private String createServiceName(boolean apiKeyNotPassword) {
        String email = this.getEmail();
        String kind = apiKeyNotPassword ? "api key" : "password";
        return StringUtil.isEmpty((String)email) ? null : CredentialAttributesKt.generateServiceName((String)"Heroku", (String)(email + " - " + kind));
    }

    public boolean shouldMigrateToPasswordSafe() {
        return !StringUtil.isEmpty((String)this.myApiKey) || super.shouldMigrateToPasswordSafe();
    }

    public void migrateToPasswordSafe() {
        super.migrateToPasswordSafe();
        String unsafeApiKey = this.myApiKey;
        if (!StringUtil.isEmpty((String)unsafeApiKey)) {
            this.setApiKeySafe(unsafeApiKey);
        }
    }
}

