/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hibernate.model.converters;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.persistence.PersistenceHelper;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.PersistentEntity;
import com.intellij.persistence.model.PersistentRelationshipAttribute;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.persistence.roles.PersistenceClassRoleEnum;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.psi.PsiClass;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ResolvingConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistentEntityByNameConverter
extends ResolvingConverter<PersistentEntity> {
    @NotNull
    public Collection<? extends PersistentEntity> getVariants(ConvertContext context) {
        DomElement root = DomUtil.getFileElement((DomElement)context.getInvocationElement()).getRootElement();
        if (!(root instanceof PersistenceMappings)) {
            List list = Collections.emptyList();
            if (list == null) {
                PersistentEntityByNameConverter.$$$reportNull$$$0(0);
            }
            return list;
        }
        DomElement parent = context.getInvocationElement().getParent();
        PsiClass psiClass = parent instanceof PersistentRelationshipAttribute ? (PsiClass)((PersistentRelationshipAttribute)parent).getTargetEntityClass().getValue() : null;
        HashSet units = new HashSet(PersistenceHelper.getHelper().getSharedModelBrowser().getPersistenceUnits((PersistenceMappings)root));
        NullableFunction mapper = role -> {
            if (role.getType() == PersistenceClassRoleEnum.ENTITY && units.contains(role.getPersistenceUnit())) {
                return (PersistentEntity)role.getPersistentObject();
            }
            return null;
        };
        Collection collection = psiClass != null ? ContainerUtil.mapNotNull((Object[])PersistenceCommonUtil.getPersistenceRoles((PsiClass)psiClass), (Function)mapper) : PersistenceCommonUtil.mapPersistenceRoles(new ArrayList(), (Project)root.getManager().getProject(), null, null, (Function)mapper);
        if (collection == null) {
            PersistentEntityByNameConverter.$$$reportNull$$$0(1);
        }
        return collection;
    }

    public PersistentEntity fromString(@Nullable @NonNls String s, ConvertContext context) {
        HashSet units;
        if (s == null) {
            return null;
        }
        DomElement root = DomUtil.getFileElement((DomElement)context.getInvocationElement()).getRootElement();
        if (!(root instanceof PersistenceMappings)) {
            return null;
        }
        Project project = root.getManager().getProject();
        ArrayList result = (ArrayList)PersistenceCommonUtil.mapPersistenceRoles(new ArrayList(), (Project)project, null, null, (Function)((NullableFunction)arg_0 -> PersistentEntityByNameConverter.lambda$fromString$1(s, units = new HashSet(PersistenceHelper.getHelper().getSharedModelBrowser().getPersistenceUnits((PersistenceMappings)root)), arg_0)));
        return result.isEmpty() ? null : (PersistentEntity)result.get(0);
    }

    public String toString(@Nullable PersistentEntity persistentEntity, ConvertContext context) {
        return persistentEntity == null ? null : (String)persistentEntity.getName().getValue();
    }

    private static /* synthetic */ PersistentEntity lambda$fromString$1(@Nullable @NonNls String s, HashSet units, PersistenceClassRole role) {
        if (role.getType() == PersistenceClassRoleEnum.ENTITY && Comparing.equal((String)s, (String)((String)((PersistentEntity)role.getPersistentObject()).getName().getValue())) && units.contains(role.getPersistenceUnit())) {
            return (PersistentEntity)role.getPersistentObject();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/model/converters/PersistentEntityByNameConverter", "getVariants"));
    }
}

