/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.metadata.util;

import com.oracle.javafx.scenebuilder.kit.metadata.util.InspectorPath;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class InspectorPathComparator
implements Comparator<InspectorPath> {
    private final List<String> sectionNames;
    private final Map<String, List<String>> subSectionMap;

    public InspectorPathComparator(List<String> sectionNames, Map<String, List<String>> subSectionMap) {
        this.sectionNames = sectionNames;
        this.subSectionMap = subSectionMap;
    }

    @Override
    public int compare(InspectorPath p1, InspectorPath p2) {
        int result;
        assert (p1 != null);
        assert (p2 != null);
        if (p1 == p2) {
            result = 0;
        } else {
            int sectionIndex1 = this.sectionNames.indexOf(p1.getSectionTag());
            int sectionIndex2 = this.sectionNames.indexOf(p2.getSectionTag());
            assert (sectionIndex1 != -1) : "sectionTag=" + p1.getSectionTag();
            assert (sectionIndex2 != -1) : "sectionTag=" + p2.getSectionTag();
            if (sectionIndex1 < sectionIndex2) {
                result = -1;
            } else if (sectionIndex1 > sectionIndex2) {
                result = 1;
            } else {
                assert (sectionIndex1 == sectionIndex2);
                assert (p1.getSectionTag().equals(p2.getSectionTag()));
                List<String> subSections = this.subSectionMap.get(p1.getSectionTag());
                assert (subSections != null) : "sectionTag=" + p1.getSectionTag();
                int subSectionIndex1 = subSections.indexOf(p1.getSubSectionTag());
                int subSectionIndex2 = subSections.indexOf(p2.getSubSectionTag());
                assert (subSectionIndex1 != -1) : "subSectionTag=" + p1.getSubSectionTag();
                assert (subSectionIndex2 != -1) : "subSectionTag=" + p2.getSubSectionTag();
                if (subSectionIndex1 < subSectionIndex2) {
                    result = -1;
                } else if (subSectionIndex1 > subSectionIndex2) {
                    result = 1;
                } else {
                    int propertyIndex2;
                    assert (subSectionIndex1 == subSectionIndex2);
                    int propertyIndex1 = p1.getSubSectionIndex();
                    result = propertyIndex1 < (propertyIndex2 = p2.getSubSectionIndex()) ? -1 : (propertyIndex1 > propertyIndex2 ? 1 : 0);
                }
            }
        }
        return result;
    }
}

