/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.css;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.EditorPlatform;
import com.oracle.javafx.scenebuilder.kit.editor.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.editor.panel.css.CssContentMaker;
import com.oracle.javafx.scenebuilder.kit.editor.panel.css.CssUtils;
import com.oracle.javafx.scenebuilder.kit.editor.panel.css.CssValueConverter;
import com.oracle.javafx.scenebuilder.kit.editor.panel.css.CssValuePresenterFactory;
import com.oracle.javafx.scenebuilder.kit.editor.panel.css.NodeCssState;
import com.oracle.javafx.scenebuilder.kit.editor.panel.css.SelectionPath;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.AbstractFxmlPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.Metadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import com.oracle.javafx.scenebuilder.kit.util.CssInternal;
import com.oracle.javafx.scenebuilder.kit.util.Deprecation;
import com.sun.javafx.css.ParsedValueImpl;
import com.sun.javafx.css.Rule;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javafx.animation.FadeTransition;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableSet;
import javafx.css.ParsedValue;
import javafx.css.PseudoClass;
import javafx.css.StyleOrigin;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Separator;
import javafx.scene.control.Skin;
import javafx.scene.control.Skinnable;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.scene.web.WebView;
import javafx.util.Callback;
import javafx.util.Duration;

public class CssPanelController
extends AbstractFxmlPanelController {
    @FXML
    private StackPane cssPanelHost;
    @FXML
    private StackPane cssSearchPanelHost;
    @FXML
    private TableColumn<NodeCssState.CssProperty, NodeCssState.CssProperty> beanApiColumn;
    @FXML
    private TableColumn<NodeCssState.CssProperty, NodeCssState.CssProperty> builtinColumn;
    @FXML
    private TableColumn<NodeCssState.CssProperty, NodeCssState.CssProperty> fxThemeColumn;
    @FXML
    private TableColumn<NodeCssState.CssProperty, NodeCssState.CssProperty> inlineColumn;
    @FXML
    private TableColumn<NodeCssState.CssProperty, NodeCssState.CssProperty> propertiesColumn;
    @FXML
    private TableColumn<NodeCssState.CssProperty, NodeCssState.CssProperty> defaultColumn;
    @FXML
    private ToggleButton pick;
    @FXML
    private ToggleButton edit;
    @FXML
    SelectionPath selectionPath;
    @FXML
    private VBox root;
    @FXML
    private HBox header;
    @FXML
    WebView textPane;
    @FXML
    private VBox rulesBox;
    @FXML
    private ScrollPane rulesPane;
    @FXML
    private TableColumn<NodeCssState.CssProperty, NodeCssState.CssProperty> stylesheetsColumn;
    @FXML
    private TableView<NodeCssState.CssProperty> table;
    @FXML
    private StackPane messagePane;
    @FXML
    private Label messageLabel;
    private TreeView<Node> rulesTree;
    private boolean advanced = false;
    private boolean styledOnly = false;
    private boolean tableColumnsOrderingReversed = false;
    private boolean dragOnGoing = false;
    private ObservableList<NodeCssState.CssProperty> model;
    private View currentView = View.TABLE;
    private String searchPattern;
    private static Image lookups = null;
    private static final String NO_MATCHING_RULES = I18N.getString("csspanel.no.matching.rule");
    private Object selectedObject;
    private Selection selection;
    private final EditorController editorController;
    private final Delegate applicationDelegate;
    private final ObjectProperty<NodeCssState> cssStateProperty = new SimpleObjectProperty();

    @Override
    protected void fxomDocumentDidChange(FXOMDocument oldDocument) {
        if (this.isCssPanelLoaded() && this.hasFxomDocument()) {
            this.updateSelectedObject();
            this.refresh();
        }
    }

    @Override
    protected void sceneGraphRevisionDidChange() {
        if (this.isCssPanelLoaded() && this.hasFxomDocument()) {
            this.refresh();
        }
    }

    @Override
    protected void cssRevisionDidChange() {
        if (this.isCssPanelLoaded() && this.hasFxomDocument()) {
            this.refresh();
        }
    }

    @Override
    protected void jobManagerRevisionDidChange() {
    }

    @Override
    protected void editorSelectionDidChange() {
        if (this.isCssPanelLoaded() && this.hasFxomDocument() && !this.dragOnGoing) {
            this.updateSelectedObject();
            this.refresh();
        }
    }

    @Override
    protected void controllerDidLoadFxml() {
        this.root.getChildren().remove((Object)this.rulesPane);
        this.root.getChildren().remove((Object)this.textPane);
        this.root.getChildren().remove(this.table);
        this.pick.setOnAction(t -> this.editorController.setPickModeEnabled(true));
        this.edit.setOnAction(t -> this.editorController.setPickModeEnabled(false));
        this.editorController.pickModeEnabledProperty().addListener((ov, oldVal, newVal) -> this.setPickMode((boolean)newVal));
        this.setPickMode(this.editorController.isPickModeEnabled());
        this.table.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.disableColumnReordering();
        ValueFactory valueFactory = new ValueFactory();
        this.propertiesColumn.setCellValueFactory((Callback)valueFactory);
        this.propertiesColumn.setCellFactory((Callback)new PropertiesCellFactory());
        this.builtinColumn.setCellValueFactory((Callback)valueFactory);
        this.builtinColumn.setCellFactory((Callback)new BuiltinCellFactory());
        this.fxThemeColumn.setCellValueFactory((Callback)valueFactory);
        this.fxThemeColumn.setCellFactory((Callback)new FxThemeCellFactory());
        this.beanApiColumn.setCellValueFactory((Callback)valueFactory);
        this.beanApiColumn.setCellFactory((Callback)new ModelCellFactory());
        this.stylesheetsColumn.setCellValueFactory((Callback)valueFactory);
        this.stylesheetsColumn.setCellFactory((Callback)new AuthorCellFactory());
        this.inlineColumn.setCellValueFactory((Callback)valueFactory);
        this.inlineColumn.setCellFactory((Callback)new InlineCellFactory());
        this.defaultColumn.setCellValueFactory((Callback)valueFactory);
        this.defaultColumn.setCellFactory((Callback)new DefaultCellFactory());
        this.editorController.themeProperty().addListener((ov, t, t1) -> this.refresh());
        this.cssStateProperty.addListener((arg0, oldValue, newValue) -> this.fillPropertiesTable());
        ChangeListener selectionListener = (arg0, oldvalue, newValue) -> {
            if (newValue != null && newValue.getItem() != null) {
                Node selectedSubNode = CssUtils.getNode(newValue.getItem());
                this.selectedObject = selectedSubNode;
                this.refresh();
                this.editorController.setPickModeEnabled(true);
                this.selection = this.editorController.getSelection();
                this.selection.select(CssPanelController.getFXOMInstance(this.selection), selectedSubNode);
            }
        };
        this.selectionPath.selected().addListener(selectionListener);
        this.getEditorController().getDragController().dragSourceProperty().addListener((ov, oldVal, newVal) -> {
            if (newVal != null) {
                this.dragOnGoing = true;
            } else {
                this.dragOnGoing = false;
                this.updateSelectedObject();
                this.refresh();
            }
        });
        this.changeView(View.TABLE);
        this.editorSelectionDidChange();
    }

    public CssPanelController(EditorController c, Delegate delegate) {
        super(CssPanelController.class.getResource("CssPanel.fxml"), I18N.getBundle(), c);
        this.editorController = c;
        this.applicationDelegate = delegate;
    }

    public String getSearchPattern() {
        return this.searchPattern;
    }

    public void setSearchPattern(String searchPattern) {
        this.searchPattern = searchPattern;
        this.searchPatternDidChange();
    }

    public void addSelectionListener(ChangeListener<SelectionPath.Item> selectionListener) {
        this.selectionPath.selected().addListener(selectionListener);
    }

    public void setSelectionPath(SelectionPath.Path path) {
        this.selectionPath.setSelectionPath(path);
    }

    public void resetSelectionPath() {
        this.selectionPath.setSelectionPath(new SelectionPath.Path(new ArrayList<SelectionPath.Item>()));
    }

    public void viewMessage(String mess) {
        this.root.getChildren().removeAll((Object[])new Node[]{this.messagePane, this.header, this.table, this.rulesPane, this.textPane});
        this.messageLabel.setText(mess);
        this.root.getChildren().add((Object)this.messagePane);
    }

    public final Node getRulesPane() {
        return this.rulesPane;
    }

    public final Node getTextPane() {
        return this.textPane;
    }

    public void setContent(ObservableList<NodeCssState.CssProperty> model, NodeCssState state) {
        this.changeView(this.currentView);
        this.initializeRulesTextPanes(state);
        this.model = FXCollections.observableArrayList(model);
    }

    public void clearContent() {
        this.table.getItems().clear();
        this.resetSelectionPath();
    }

    public void filter(String pattern) {
        ObservableList filtered;
        if (this.model == null) {
            return;
        }
        if (pattern == null || pattern.trim().length() == 0) {
            filtered = this.model;
        } else {
            filtered = FXCollections.observableArrayList();
            for (NodeCssState.CssProperty p : this.model) {
                if (!((String)p.propertyName().get()).contains(pattern.trim())) continue;
                filtered.add((Object)p);
            }
        }
        this.updateTable((ObservableList<NodeCssState.CssProperty>)filtered);
    }

    public static void attachStyleProperty(TreeItem<Node> parent, CssContentMaker.CssPropertyState cssProp, CssContentMaker.CssPropertyState.CssStyle style, boolean applied, boolean isLookup) {
        if (isLookup) {
            String cssValue = CssValueConverter.toCssString(style.getCssProperty(), style.getCssRule(), style.getParsedValue());
            TreeItem item = new TreeItem((Object)CssPanelController.getContent(style.getCssProperty(), cssValue, style.getParsedValue(), applied));
            parent.getChildren().add((Object)item);
        } else {
            CssPanelController.attachStylePropertyNoLookup(parent, cssProp, style, applied);
        }
    }

    public void changeView(View view) {
        switch (view) {
            case TABLE: {
                this.root.getChildren().removeAll((Object[])new Node[]{this.messagePane, this.header, this.table, this.rulesPane, this.textPane});
                this.root.getChildren().addAll((Object[])new Node[]{this.header, this.table});
                break;
            }
            case RULES: {
                this.root.getChildren().removeAll((Object[])new Node[]{this.messagePane, this.header, this.rulesPane, this.table, this.textPane});
                this.root.getChildren().addAll((Object[])new Node[]{this.header, this.rulesPane});
                break;
            }
            case TEXT: {
                this.root.getChildren().removeAll((Object[])new Node[]{this.messagePane, this.header, this.textPane, this.table, this.rulesPane});
                this.root.getChildren().addAll((Object[])new Node[]{this.header, this.textPane});
            }
        }
        this.currentView = view;
    }

    public void copyStyleablePath() {
        ClipboardContent content = new ClipboardContent();
        content.putString(this.selectionPath.toString());
        Clipboard.getSystemClipboard().setContent((Map)content);
    }

    public void splitDefaultsAction() {
        this.advanced = !this.advanced;
        this.unmerge();
    }

    public void showStyledOnly() {
        boolean bl = this.styledOnly = !this.styledOnly;
        if (this.model == null) {
            return;
        }
        this.showStyled(this.model);
    }

    public void toggleTableColumnsOrdering() {
        ObservableList columns = this.table.getColumns();
        FXCollections.reverse((ObservableList)columns);
        TableColumn propertyColumn = (TableColumn)columns.get(columns.size() - 1);
        columns.remove((Object)propertyColumn);
        columns.add(0, (Object)propertyColumn);
        this.tableColumnsOrderingReversed = !this.tableColumnsOrderingReversed;
    }

    public boolean isTableColumnsOrderingReversed() {
        return this.tableColumnsOrderingReversed;
    }

    public void setTableColumnsOrderingReversed(boolean value) {
        if (this.table != null && this.tableColumnsOrderingReversed != value) {
            this.toggleTableColumnsOrdering();
        }
    }

    public void initialize() {
    }

    private void refresh() {
        this.setCSSContent();
    }

    private void updateSelectedObject() {
        this.selection = this.editorController.getSelection();
        if (!this.isMultipleSelection()) {
            if (this.isPickMode()) {
                Node pickObject = this.selection.getCheckedHitNode();
                FXOMInstance fxomInstance = CssPanelController.getFXOMInstance(this.selection);
                this.selectedObject = fxomInstance != null && fxomInstance.getSceneGraphObject() == pickObject ? fxomInstance : pickObject;
            } else {
                this.selectedObject = CssPanelController.getFXOMInstance(this.selection);
            }
        }
    }

    private static String getFirstStandardClassName(Class<?> type) {
        for (Class<?> clazz = type; clazz != null; clazz = clazz.getSuperclass()) {
            if (!clazz.getName().startsWith("javafx")) continue;
            return clazz.getSimpleName();
        }
        return type.getName();
    }

    private void collectCss() {
        if (this.selectedObject != null) {
            NodeCssState state = CssContentMaker.getCssState(this.selectedObject);
            if (state == null) {
                return;
            }
            this.cssStateProperty.setValue((Object)state);
        }
    }

    private void setCSSContent() {
        if (this.selectedObject instanceof Skinnable && ((Skinnable)this.selectedObject).getSkin() == null) {
            return;
        }
        this.clearContent();
        if (this.isMultipleSelection()) {
            this.viewMessage(I18N.getString("csspanel.multiselection"));
            return;
        }
        if (this.selectedObject != null) {
            this.fillSelectionContent();
            this.collectCss();
        }
    }

    private boolean isMultipleSelection() {
        if (this.selection.getGroup() instanceof ObjectSelectionGroup) {
            return ((ObjectSelectionGroup)this.selection.getGroup()).getItems().size() > 1;
        }
        return false;
    }

    private boolean isCssPanelLoaded() {
        return this.root != null;
    }

    private boolean hasFxomDocument() {
        return this.getEditorController().getFxomDocument() != null;
    }

    private boolean isPickMode() {
        return this.editorController.isPickModeEnabled();
    }

    private void setPickMode(boolean pickMode) {
        this.pick.setSelected(pickMode);
        this.edit.setSelected(!pickMode);
    }

    private void fillSelectionContent() {
        assert (this.selectedObject != null);
        Node selectedRootNode = CssUtils.getSelectedNode(CssPanelController.getFXOMInstance(this.selection));
        if (selectedRootNode == null) {
            return;
        }
        SelectionPath.Item rootItem = new SelectionPath.Item(selectedRootNode, CssPanelController.createItemName(selectedRootNode), CssPanelController.createOptional(selectedRootNode));
        if (selectedRootNode instanceof Parent) {
            this.addSubStructure(selectedRootNode, rootItem, (Node)((Parent)selectedRootNode));
        }
        Node selectedNode = CssUtils.getSelectedNode(this.selectedObject);
        List<SelectionPath.Item> items = SelectionPath.lookupPath(rootItem, selectedNode);
        this.setSelectionPath(new SelectionPath.Path(items));
    }

    private void addSubStructure(Node componentRootNode, SelectionPath.Item parentItem, Node node) {
        Node componentRootNodeEnclosingNode;
        boolean isOtherComponentNode;
        FXOMDocument fxomDoc = this.getEditorController().getFxomDocument();
        assert (fxomDoc != null);
        Node enclosingNode = this.getEnclosingNode(fxomDoc, node);
        boolean bl = isOtherComponentNode = enclosingNode != (componentRootNodeEnclosingNode = this.getEnclosingNode(fxomDoc, componentRootNode));
        if (!(componentRootNode == node || node.getStyleClass().isEmpty() || isOtherComponentNode || node instanceof Skin)) {
            SelectionPath.Item ni = new SelectionPath.Item(node, CssPanelController.createItemName(node), CssPanelController.createOptional(node));
            parentItem.getChildren().add(ni);
            parentItem = ni;
        }
        if (node instanceof Parent && !isOtherComponentNode) {
            Parent parentNode = (Parent)node;
            for (Node child : parentNode.getChildrenUnmodifiable()) {
                this.addSubStructure(componentRootNode, parentItem, child);
            }
        }
    }

    private Node getEnclosingNode(FXOMDocument fxomDoc, Node n) {
        Node node = n;
        FXOMObject enclosingFXOMObj = fxomDoc.searchWithSceneGraphObject(node);
        while (enclosingFXOMObj == null) {
            if ((node = node.getParent()) == null) {
                return null;
            }
            enclosingFXOMObj = fxomDoc.searchWithSceneGraphObject(node);
        }
        Object enclosingObj = enclosingFXOMObj.getSceneGraphObject();
        assert (enclosingObj instanceof Node);
        return (Node)enclosingObj;
    }

    private void fillPropertiesTable() {
        NodeCssState state = (NodeCssState)this.cssStateProperty.getValue();
        if (state == null) {
            return;
        }
        this.fillContent(state);
        this.filter(this.searchPattern);
    }

    private void fillContent(NodeCssState state) {
        ObservableList cssModel = FXCollections.observableArrayList();
        Collection<NodeCssState.CssProperty> styleables = state.getAllStyleables();
        for (NodeCssState.CssProperty sp : styleables) {
            cssModel.add((Object)sp);
            for (NodeCssState.CssProperty sub : sp.getSubProperties()) {
                cssModel.add((Object)sub);
            }
        }
        this.setContent((ObservableList<NodeCssState.CssProperty>)cssModel, state);
    }

    private void attachNotAppliedStyles(TreeItem<Node> ti, CssContentMaker.PropertyState css) {
        for (CssContentMaker.CssPropertyState.CssStyle style : css.getNotAppliedStyles()) {
            CssPanelController.attachStyle(css, style, ti, false);
        }
    }

    private void attachSubProperties(TreeItem<Node> parent, CssContentMaker.PropertyState ss) {
        for (CssContentMaker.PropertyState sub : ss.getSubProperties()) {
            this.attachProperty(parent, sub);
        }
        this.attachNotAppliedStyles(parent, ss);
    }

    private void attachProperty(TreeItem<Node> parent, CssContentMaker.PropertyState ss) {
        boolean hasSubs;
        boolean bl = hasSubs = !ss.getSubProperties().isEmpty();
        if (hasSubs) {
            if (ss instanceof CssContentMaker.CssPropertyState) {
                CssContentMaker.CssPropertyState cssProp = (CssContentMaker.CssPropertyState)ss;
                if (cssProp.getStyle() != null) {
                    Node content = CssPanelController.getContent(ss.getCssProperty(), ss.getCssValue(), ss.getFxValue(), true);
                    TreeItem<Node> ti = CssPanelController.newTreeItem(content, ss);
                    parent.getChildren().add(ti);
                    CssPanelController.attachStyles(cssProp, ti);
                    this.attachNotAppliedStyles(parent, ss);
                } else {
                    this.attachSubProperties(parent, ss);
                }
            } else {
                this.attachSubProperties(parent, ss);
            }
        } else {
            Node content = CssPanelController.getContent(ss.getCssProperty(), ss.getCssValue(), ss.getFxValue(), true);
            TreeItem<Node> ti = CssPanelController.newTreeItem(content, ss);
            parent.getChildren().add(ti);
            if (ss instanceof CssContentMaker.CssPropertyState) {
                CssContentMaker.CssPropertyState css = (CssContentMaker.CssPropertyState)ss;
                CssPanelController.attachStyles(css, ti);
            } else if (ss instanceof CssContentMaker.BeanPropertyState) {
                CssContentMaker.BeanPropertyState beanProp = (CssContentMaker.BeanPropertyState)ss;
                String source = beanProp.getPropertyMeta().getName().toString();
                StringBuilder contentBuilder = new StringBuilder();
                contentBuilder.append(source);
                ti.getChildren().add(CssPanelController.newTreeItem((Node)new Label(contentBuilder.toString()), ss));
            }
            this.attachNotAppliedStyles(ti, ss);
        }
    }

    private void searchPatternDidChange() {
        this.filter(this.searchPattern);
    }

    private void updateTable(ObservableList<NodeCssState.CssProperty> currentModel) {
        this.showStyled(currentModel);
        this.unmerge();
    }

    private void disableColumnReordering() {
        for (TableColumn column : this.table.getColumns()) {
            Deprecation.setTableColumnReordable(column, false);
        }
    }

    private void initializeRulesTextPanes(NodeCssState state) {
        this.rulesBox.getChildren().clear();
        List<NodeCssState.MatchingRule> rulesList = state.getMatchingRules();
        HtmlStyler htmlStyler = new HtmlStyler();
        this.rulesTree = new TreeView();
        CopyHandler.attachContextMenu((TreeView<Node>)this.rulesTree);
        this.rulesTree.setShowRoot(false);
        TreeItem ruleRoot = new TreeItem((Object)new Text(""));
        this.rulesTree.setRoot(ruleRoot);
        for (NodeCssState.MatchingRule rule : rulesList) {
            List<NodeCssState.MatchingDeclaration> lst = rule.getDeclarations();
            String selector = rule.getSelector();
            String txt = selector + " { ";
            String source = CssPanelController.nonNull(CssPanelController.getSource(rule.getRule()));
            Text text = (Text)CopyHandler.makeCopyableNode((Node)new Text(txt + source), txt);
            TreeItem start = new TreeItem((Object)text);
            ruleRoot.getChildren().add((Object)start);
            htmlStyler.cssRuleStart(selector, source);
            for (NodeCssState.MatchingDeclaration p : lst) {
                CssContentMaker.CssPropertyState prop = p.getProp();
                CssPanelController.attachStyleProperty((TreeItem<Node>)ruleRoot, prop, p.getStyle(), p.isApplied(), p.isLookup());
                CssContentMaker.CssPropertyState.CssStyle style = p.getStyle();
                String cssValue = CssValueConverter.toCssString(style.getCssProperty(), style.getCssRule(), style.getParsedValue());
                htmlStyler.addProperty(p.getStyle().getCssProperty(), cssValue, p.isApplied());
            }
            TreeItem end = new TreeItem((Object)CopyHandler.createCopyableText("}"));
            ruleRoot.getChildren().add((Object)end);
            CssPanelController.setTreeHeight(this.rulesTree);
            htmlStyler.cssRuleEnd();
        }
        if (ruleRoot.getChildren().isEmpty()) {
            this.rulesBox.getChildren().add((Object)new Label(NO_MATCHING_RULES));
        } else {
            this.rulesBox.getChildren().add(this.rulesTree);
        }
        if (htmlStyler.isEmpty()) {
            htmlStyler.addMessage(NO_MATCHING_RULES);
        }
        this.textPane.getEngine().loadContent(htmlStyler.getHtmlString());
    }

    void close(ChangeListener<SelectionPath.Item> selectionListener) {
        this.selectionPath.selected().removeListener(selectionListener);
    }

    private void unmerge() {
        this.defaultColumn.setVisible(!this.advanced);
        this.fxThemeColumn.setVisible(this.advanced);
        this.builtinColumn.setVisible(this.advanced);
    }

    private void showStyled(ObservableList<NodeCssState.CssProperty> currentModel) {
        if (this.styledOnly) {
            currentModel = CssPanelController.extractStyled(currentModel);
        }
        this.table.getItems().setAll(currentModel);
    }

    private static ObservableList<NodeCssState.CssProperty> extractStyled(ObservableList<NodeCssState.CssProperty> currentModel) {
        ObservableList ret = FXCollections.observableArrayList();
        for (NodeCssState.CssProperty prop : currentModel) {
            if (!prop.isAuthorSource() && !prop.isInlineSource() && !prop.isModelSource()) continue;
            ret.add((Object)prop);
        }
        return ret;
    }

    private static String nodeIdentifier(Node n) {
        if (n.getId() != null && !n.getId().equals("")) {
            return n.getId();
        }
        return n.getClass().getSimpleName();
    }

    private void open(NodeCssState.CssProperty item, CssContentMaker.PropertyState state, CssContentMaker.CssPropertyState.CssStyle style, StyleOrigin origin) {
        this.navigate(item, state, style, origin, true);
    }

    private void navigate(NodeCssState.CssProperty item, CssContentMaker.PropertyState state, CssContentMaker.CssPropertyState.CssStyle style, StyleOrigin origin) {
        this.navigate(item, state, style, origin, false);
    }

    private void navigate(NodeCssState.CssProperty item, CssContentMaker.PropertyState state, CssContentMaker.CssPropertyState.CssStyle style, StyleOrigin origin, boolean open) {
        block10: {
            if (origin == StyleOrigin.USER) {
                PropertyName propName = ((CssContentMaker.BeanPropertyState)state).getPropertyMeta().getName();
                if (this.applicationDelegate != null) {
                    this.applicationDelegate.revealInspectorEditor(this.getValuePropertyMeta(propName));
                }
            }
            if (style != null) {
                if (style.getOrigin() == StyleOrigin.AUTHOR) {
                    URL url = style.getUrl();
                    String path = url.toExternalForm();
                    if (path.toLowerCase(Locale.ROOT).startsWith("file:/")) {
                        try {
                            if (open) {
                                EditorPlatform.open(path);
                                break block10;
                            }
                            File f = new File(url.toURI());
                            EditorPlatform.revealInFileBrowser(f);
                        }
                        catch (IOException | URISyntaxException ex) {
                            System.out.println(ex.getMessage() + ": " + ex);
                        }
                    }
                } else if (style.getOrigin() == StyleOrigin.INLINE && this.applicationDelegate != null) {
                    this.applicationDelegate.revealInspectorEditor(this.getValuePropertyMeta(new PropertyName("style")));
                }
            }
        }
    }

    private static String getNavigationInfo(NodeCssState.CssProperty item, CssContentMaker.CssPropertyState.CssStyle cssStyle, StyleOrigin origin) {
        if (origin == StyleOrigin.USER_AGENT) {
            return CssInternal.getThemeDisplayName(cssStyle.getStyle());
        }
        if (origin == StyleOrigin.USER) {
            CssContentMaker.BeanPropertyState state = (CssContentMaker.BeanPropertyState)item.modelState().get();
            return item.getTarget().getClass().getSimpleName() + "." + state.getPropertyMeta().getName().getName();
        }
        if (origin == StyleOrigin.AUTHOR && cssStyle != null) {
            URL url = cssStyle.getUrl();
            String name = null;
            if (url != null && (name = url.toExternalForm()).toLowerCase(Locale.ROOT).startsWith("file:/")) {
                try {
                    File f = new File(url.toURI());
                    name = f.getName();
                }
                catch (URISyntaxException ex) {
                    System.out.println(ex.getMessage() + ": " + ex);
                }
            }
            return name;
        }
        if (origin == StyleOrigin.INLINE) {
            Node n = item.getSourceNodeForInline();
            if (n != null) {
                return CssPanelController.nodeIdentifier(n);
            }
            return null;
        }
        return null;
    }

    private static FXOMInstance getFXOMInstance(Selection selection) {
        FXOMInstance fxomInstance = null;
        if (selection == null) {
            return null;
        }
        if (selection.getGroup() instanceof ObjectSelectionGroup) {
            ObjectSelectionGroup osg = (ObjectSelectionGroup)selection.getGroup();
            for (FXOMObject item : osg.getItems()) {
                if (!(item instanceof FXOMInstance)) continue;
                fxomInstance = (FXOMInstance)item;
            }
        }
        return fxomInstance;
    }

    private ValuePropertyMetadata getValuePropertyMeta(PropertyName propName) {
        ValuePropertyMetadata valuePropMeta = null;
        if (this.selectedObject instanceof FXOMInstance) {
            valuePropMeta = Metadata.getMetadata().queryValueProperty((FXOMInstance)this.selectedObject, propName);
        }
        return valuePropMeta;
    }

    private static String getPseudoStates(Node node) {
        StringBuilder pseudoClasses = new StringBuilder();
        ObservableSet pseudoClassSet = node.getPseudoClassStates();
        for (PseudoClass pc : pseudoClassSet) {
            pseudoClasses.append(":").append(pc.getPseudoClassName());
        }
        return pseudoClasses.toString();
    }

    private static String localSelector(Node node) {
        String ret = "";
        String pseudoClasses = CssPanelController.getPseudoStates(node);
        if (!node.getStyleClass().isEmpty()) {
            ret = "." + (String)node.getStyleClass().get(node.getStyleClass().size() - 1) + pseudoClasses;
        } else if (node.getId() != null && !node.getId().equals("")) {
            ret = "#" + node.getId() + pseudoClasses;
        }
        return ret;
    }

    private static String createItemName(Node n) {
        return CssPanelController.localSelector(n);
    }

    private static String createOptional(Node n) {
        return "(" + CssPanelController.getFirstStandardClassName(n.getClass()) + ")";
    }

    private static Node getContent(String property, String cssValue, Object value, boolean applied) {
        HBox hbox = new HBox();
        Node l = CssPanelController.createPropertyLabel(property + ": ", applied);
        hbox.getChildren().add((Object)l);
        Node n = CssPanelController.getCustomContent(value);
        if (n != null) {
            hbox.getChildren().add((Object)n);
        } else {
            Node cssValueNode = CssPanelController.createLabel(cssValue + ";", applied);
            hbox.getChildren().add((Object)cssValueNode);
        }
        return CopyHandler.makeCopyableNode((Node)hbox, property + ": " + cssValue + ";");
    }

    private static Node getCustomContent(Object value) {
        Node ret = null;
        if (value instanceof ParsedValue) {
            ParsedValue pv = (ParsedValue)value;
            value = CssValueConverter.convert(pv);
        }
        if (value != null) {
            HBox hbox;
            if (value.getClass().isArray()) {
                hbox = new HBox(5.0);
                int size = Array.getLength(value);
                for (int i = 0; i < size; ++i) {
                    Node n = CssPanelController.getCustomContent(Array.get(value, i));
                    if (n == null) continue;
                    hbox.getChildren().add((Object)n);
                    if (i >= size - 1) continue;
                    hbox.getChildren().add((Object)new Label(", "));
                }
                if (!hbox.getChildren().isEmpty()) {
                    ret = hbox;
                }
            } else if (value instanceof Collection) {
                hbox = new HBox(5.0);
                Collection collection = (Collection)value;
                Iterator it = collection.iterator();
                while (it.hasNext()) {
                    Object obj = it.next();
                    Node n = CssPanelController.getCustomContent(obj);
                    if (n == null) continue;
                    hbox.getChildren().add((Object)n);
                    if (!it.hasNext()) continue;
                    hbox.getChildren().add((Object)new Label(", "));
                }
                if (!hbox.getChildren().isEmpty()) {
                    ret = hbox;
                }
            } else {
                Node customPresenter;
                CssValuePresenterFactory.CssValuePresenter<Object> presenter = CssValuePresenterFactory.getInstance().newValuePresenter(value);
                ret = customPresenter = presenter.getCustomPresenter();
            }
        }
        return ret;
    }

    private static Node createLabel(String text, String styleclass, boolean isApplied) {
        Label node = new Label(text);
        if (styleclass != null) {
            node.getStyleClass().add((Object)styleclass);
        }
        if (!isApplied) {
            node = CssPanelController.createLine((Node)node);
        }
        return node;
    }

    private static Node createLabel(String text, boolean isApplied) {
        return CssPanelController.createLabel(text, null, isApplied);
    }

    private static Node createPropertyLabel(String text, boolean isApplied) {
        return CssPanelController.createLabel(text, "css-panel-property", isApplied);
    }

    private static Node createLine(Node node) {
        StackPane sp = new StackPane();
        sp.getChildren().add((Object)node);
        Separator s = new Separator(Orientation.HORIZONTAL);
        s.setValignment(VPos.CENTER);
        s.getStyleClass().add((Object)"notAppliedStyleLine");
        sp.getChildren().add((Object)s);
        return sp;
    }

    private static TreeItem<Node> attachSource(CssContentMaker.PropertyState css, CssContentMaker.CssPropertyState.CssStyle cssStyle, TreeItem<Node> parent, boolean applied) {
        String source = CssPanelController.getSource(cssStyle);
        TreeItem<Node> srcItem = null;
        if (source != null) {
            HBox hbox = new HBox(5.0);
            if (cssStyle.getOrigin() != StyleOrigin.INLINE) {
                Label selector = new Label(cssStyle.getSelector());
                selector.setMinWidth(30.0);
                hbox.getChildren().add((Object)selector);
                hbox.getChildren().add((Object)new Label("{"));
            }
            hbox.getChildren().add((Object)CssPanelController.createLabel(cssStyle.getCssProperty() + ": ", applied));
            Node n = CssPanelController.getCustomContent(cssStyle.getParsedValue());
            if (n != null) {
                hbox.getChildren().add((Object)n);
            }
            Node label2 = CssPanelController.createLabel(CssValueConverter.toCssString(cssStyle.getCssProperty(), cssStyle.getCssRule(), cssStyle.getParsedValue()) + ";", applied);
            hbox.getChildren().add((Object)label2);
            if (cssStyle.getOrigin() != StyleOrigin.INLINE) {
                hbox.getChildren().add((Object)new Label("}"));
            }
            Label label = new Label(source);
            hbox.getChildren().add((Object)label);
            srcItem = CssPanelController.newTreeItem((Node)hbox, css);
            parent.getChildren().add(srcItem);
        }
        return srcItem;
    }

    private static void attachStyle(CssContentMaker.PropertyState css, CssContentMaker.CssPropertyState.CssStyle style, TreeItem<Node> parent, boolean applied) {
        CssPanelController.attachStyle(css, style, parent, applied, null);
    }

    private static void attachStyle(CssContentMaker.PropertyState css, CssContentMaker.CssPropertyState.CssStyle style, TreeItem<Node> parent, boolean applied, ArrayList<String> cssPropertyList) {
        TreeItem<Node> sourceItem = CssPanelController.attachSource(css, style, parent, applied);
        if (cssPropertyList != null) {
            cssPropertyList.add(style.getCssProperty());
        }
        if (sourceItem != null) {
            for (CssContentMaker.CssPropertyState.CssStyle lookup : style.getLookupChain()) {
                if (cssPropertyList != null && cssPropertyList.contains(lookup.getCssProperty())) continue;
                CssPanelController.attachStyle(css, lookup, sourceItem, applied, cssPropertyList);
            }
        }
    }

    public static void attachLookupStyles(Object component, CssContentMaker.CssPropertyState css, CssContentMaker.CssPropertyState.CssStyle lookupRoot, TreeItem<Node> parent) {
        ArrayList<String> cssPropertyList = new ArrayList<String>();
        CssPanelController.attachStyle(css, lookupRoot, parent, true, cssPropertyList);
    }

    private static void attachStyles(CssContentMaker.CssPropertyState css, TreeItem<Node> parent) {
        if (css.getStyle() != null) {
            CssPanelController.attachStyle(css, css.getStyle(), parent, true);
        }
    }

    public void copyRules() {
        CopyHandler.copy((TreeView<Node>)this.rulesTree);
    }

    private static void setTreeHeight(TreeView<?> tv) {
        int minHeight = 70;
        int topLevelItems = tv.getRoot().getChildren().size();
        int computed = topLevelItems == 0 ? 15 : 25 * topLevelItems;
        tv.setPrefHeight((double)Math.max(minHeight, computed));
    }

    private static String nonNull(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    private static TreeItem<Node> newTreeItem(Node content, CssContentMaker.PropertyState ss) {
        TreeItem ti = new TreeItem((Object)content);
        return ti;
    }

    private static String getSource(CssContentMaker.CssPropertyState.CssStyle style) {
        URL url = style.getUrl();
        String source = null;
        if (url != null) {
            source = CssPanelController.getSource(url, style.getOrigin());
        }
        return source;
    }

    private static String getSource(Rule rule) {
        URL url = null;
        StyleOrigin origin = null;
        if (rule != null) {
            try {
                url = new URL(rule.getStylesheet().getUrl());
            }
            catch (MalformedURLException ex) {
                System.out.println("Invalid URL: " + ex);
            }
            origin = rule.getOrigin();
        }
        return CssPanelController.getSource(url, origin);
    }

    private static String getSource(URL url, StyleOrigin origin) {
        String source = null;
        if (url != null) {
            if (origin == StyleOrigin.USER_AGENT) {
                source = I18N.getString("csspanel.fxtheme.origin");
            } else if (origin == StyleOrigin.USER) {
                source = I18N.getString("csspanel.api.origin") + " " + I18N.getString("csspanel.node.property");
            } else if (origin == StyleOrigin.AUTHOR) {
                source = url.toExternalForm();
            }
        }
        return source;
    }

    private static String getSourceInfo(NodeCssState.CssProperty item, CssContentMaker.CssPropertyState.CssStyle style, StyleOrigin origin) {
        if (origin == StyleOrigin.USER_AGENT) {
            if (style != null) {
                return style.getSelector();
            }
            return null;
        }
        if (origin == StyleOrigin.USER) {
            CssContentMaker.BeanPropertyState state = (CssContentMaker.BeanPropertyState)item.modelState().get();
            return state.getPropertyMeta().getName().getName();
        }
        if (origin == StyleOrigin.AUTHOR) {
            if (style != null) {
                return style.getSelector();
            }
            return null;
        }
        if (origin == StyleOrigin.INLINE) {
            boolean inherited = item.isInlineInherited();
            return "style" + (inherited ? " (" + I18N.getString("csspanel.inherited") + ")" : "");
        }
        return null;
    }

    private static Node createValueUI(NodeCssState.CssProperty item, CssContentMaker.CssPropertyState.CssStyle style) {
        ParsedValue value = null;
        if (style != null && !style.getLookupChain().isEmpty()) {
            value = style.getLookupChain().size() == 1 ? style.getLookupChain().get(0).getParsedValue() : style.getParsedValue();
        } else if (style != null) {
            value = style.getParsedValue();
        }
        return CssPanelController.createValueUI(item, null, value, style);
    }

    private static Node createValueUI(NodeCssState.CssProperty item, CssContentMaker.PropertyState ps, Object value, CssContentMaker.CssPropertyState.CssStyle style) {
        ParsedValue pv;
        Object v;
        ParsedValue[] parsedValues = null;
        if (style != null && (v = (pv = style.getParsedValue()).getValue()) instanceof ParsedValue[]) {
            parsedValues = (ParsedValue[])v;
        }
        return CssPanelController.createValueUI(item, ps, value, style, parsedValues);
    }

    private static Node createValueUI(NodeCssState.CssProperty item, CssContentMaker.PropertyState ps, Object value, CssContentMaker.CssPropertyState.CssStyle style, ParsedValue<?, ?>[] parsedValues) {
        Node ret = null;
        if (value instanceof ParsedValue) {
            ParsedValue pv = (ParsedValue)value;
            value = CssValueConverter.convert(pv);
        }
        if (value != null) {
            HBox hbox;
            if (value.getClass().isArray()) {
                Object v;
                Node n;
                hbox = new HBox(5.0);
                int size = Array.getLength(value);
                int lookupIndex = 0;
                for (int i = 0; i < size && (n = CssPanelController.getLeaf(v = Array.get(value, i))) != null; ++i) {
                    boolean lookup = false;
                    if (parsedValues != null) {
                        ParsedValue<?, ?> pv = parsedValues[i];
                        lookup = ((ParsedValueImpl)pv).isContainsLookups();
                    }
                    if (lookup) {
                        assert (style != null);
                        CssContentMaker.CssPropertyState.CssStyle lookupRoot = null;
                        if (style.getLookupChain().size() - 1 >= lookupIndex) {
                            lookupRoot = style.getLookupChain().get(lookupIndex);
                        }
                        ++lookupIndex;
                        Node lookupUI = CssPanelController.createLookupUI(item, ps, style, lookupRoot, n);
                        hbox.getChildren().add((Object)lookupUI);
                    } else {
                        hbox.getChildren().add((Object)n);
                    }
                    if (i >= size - 1) continue;
                    hbox.getChildren().add((Object)new Label(","));
                }
                if (!hbox.getChildren().isEmpty()) {
                    ret = hbox;
                }
            } else if (value instanceof Collection) {
                Object v;
                Node n;
                hbox = new HBox(5.0);
                int lookupIndex = 0;
                Collection collection = (Collection)value;
                Iterator it = collection.iterator();
                int index = 0;
                while (it.hasNext() && (n = CssPanelController.getLeaf(v = it.next())) != null) {
                    boolean lookup = false;
                    if (parsedValues != null) {
                        ParsedValue<?, ?> pv = parsedValues[index];
                        lookup = ((ParsedValueImpl)pv).isContainsLookups();
                    }
                    if (lookup) {
                        CssContentMaker.CssPropertyState.CssStyle lookupRoot = null;
                        assert (style != null);
                        if (style.getLookupChain().size() - 1 >= lookupIndex) {
                            lookupRoot = style.getLookupChain().get(lookupIndex);
                        }
                        Node lookupUI = CssPanelController.createLookupUI(item, ps, style, lookupRoot, n);
                        hbox.getChildren().add((Object)lookupUI);
                        ++lookupIndex;
                    } else {
                        hbox.getChildren().add((Object)n);
                    }
                    if (it.hasNext()) {
                        hbox.getChildren().add((Object)new Label(","));
                    }
                    ++index;
                }
                if (!hbox.getChildren().isEmpty()) {
                    ret = hbox;
                }
            } else {
                Node n = CssPanelController.getLeaf(value);
                if (n == null && style != null) {
                    n = CssPanelController.getLabel(style);
                }
                ret = style != null && !style.getLookupChain().isEmpty() ? CssPanelController.createLookupUI(item, ps, style, style, n) : n;
            }
        }
        return ret;
    }

    private static Label getLabel(CssContentMaker.CssPropertyState.CssStyle style) {
        String l = CssValueConverter.toCssString(style.getCssProperty(), style.getCssRule(), style.getParsedValue());
        return new Label(l);
    }

    private static synchronized Image getLookupImage() {
        if (lookups == null) {
            lookups = new Image(CssPanelController.class.getResource("images/css-lookup-icon.png").toExternalForm());
        }
        return lookups;
    }

    private static Node createLookupUI(NodeCssState.CssProperty item, CssContentMaker.PropertyState ps, CssContentMaker.CssPropertyState.CssStyle style, CssContentMaker.CssPropertyState.CssStyle lookupRoot, Node n) {
        HBox hbox = new HBox();
        hbox.setMaxWidth(Double.NEGATIVE_INFINITY);
        ImageView imgView = new ImageView();
        imgView.setImage(CssPanelController.getLookupImage());
        hbox.getChildren().addAll((Object[])new Node[]{n, imgView});
        MenuButton lookupMb = new MenuButton();
        lookupMb.setGraphic((Node)hbox);
        lookupMb.getStyleClass().add((Object)"lookup-button");
        CustomMenuItem popupContentMi = new CustomMenuItem();
        popupContentMi.setHideOnClick(false);
        lookupMb.getItems().add((Object)popupContentMi);
        StackPane popupContent = new StackPane();
        popupContentMi.setContent((Node)popupContent);
        TreeView lookupTv = new TreeView();
        lookupTv.setPrefSize(400.0, 100.0);
        Object val = null;
        if (ps instanceof CssContentMaker.CssPropertyState) {
            val = ((CssContentMaker.CssPropertyState)ps).getFxValue();
        } else if (style != null) {
            val = style.getParsedValue();
        }
        assert (val != null);
        TreeItem root = new TreeItem();
        lookupTv.setRoot(root);
        lookupTv.setShowRoot(false);
        if (ps != null) {
            assert (ps instanceof CssContentMaker.CssPropertyState);
            CssPanelController.attachLookupStyles(item.getTarget(), (CssContentMaker.CssPropertyState)ps, lookupRoot, (TreeItem<Node>)root);
        } else {
            CssPanelController.attachLookupStyles(item.getTarget(), null, lookupRoot, (TreeItem<Node>)root);
        }
        popupContent.getChildren().add((Object)lookupTv);
        return lookupMb;
    }

    private static Node getLeaf(Object value) {
        CssValuePresenterFactory.CssValuePresenter<Object> presenter = CssValuePresenterFactory.getInstance().newValuePresenter(value);
        Node customPresenter = presenter.getCustomPresenter();
        return customPresenter;
    }

    private static void attachStylePropertyNoLookup(TreeItem<Node> parent, CssContentMaker.CssPropertyState ps, CssContentMaker.CssPropertyState.CssStyle style, boolean applied) {
        CssContentMaker.CssPropertyState.CssStyle cssStyle = applied ? ps.getStyle() : style;
        Object value = applied ? ps.getFxValue() : style.getParsedValue();
        String cssValue = CssValueConverter.toCssString(cssStyle.getCssProperty(), cssStyle.getCssRule(), cssStyle.getParsedValue());
        TreeItem item = new TreeItem((Object)CssPanelController.getContent(ps.getCssProperty(), cssValue, value, applied));
        parent.getChildren().add((Object)item);
    }

    private static class CopyHandler {
        private static final String CSS_TEXT = "CSS_TEXT";

        private CopyHandler() {
        }

        private static String getContent(TreeView<Node> tv) {
            StringBuilder builder = new StringBuilder();
            for (TreeItem item : tv.getSelectionModel().getSelectedItems()) {
                Node n = (Node)item.getValue();
                String str = (String)n.getProperties().get((Object)CSS_TEXT);
                if (str == null) continue;
                builder.append(str);
            }
            return builder.toString();
        }

        private static void copy(TreeView<Node> tv) {
            String cssContent = CopyHandler.getContent(tv);
            ClipboardContent content = new ClipboardContent();
            content.putString(cssContent);
            Clipboard.getSystemClipboard().setContent((Map)content);
        }

        private static void attachContextMenu(TreeView<Node> tv) {
            ContextMenu ctxMenu = new ContextMenu();
            MenuItem cssContentAction = new MenuItem(I18N.getString("csspanel.copy"));
            ctxMenu.setOnShowing(arg0 -> {});
            tv.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
            cssContentAction.setOnAction(arg0 -> CopyHandler.copy(tv));
            ctxMenu.getItems().add((Object)cssContentAction);
            tv.setContextMenu(ctxMenu);
        }

        private static <T extends Node> T makeCopyableNode(T node, String str) {
            node.getProperties().put((Object)CSS_TEXT, (Object)(str + "\n"));
            return node;
        }

        private static Text createCopyableText(String str) {
            Text text = new Text(str);
            text.getProperties().put((Object)CSS_TEXT, (Object)(str + "\n"));
            return text;
        }
    }

    private static class HtmlStyler {
        private static final String INIT_STRING = "<html><body>";
        private static final String END_STRING = "</body></html>";
        private final StringBuilder builder = new StringBuilder();
        private String html;

        HtmlStyler() {
            this.builder.append(INIT_STRING);
        }

        public void check() {
            if (this.html != null) {
                throw new IllegalArgumentException("Locked, html already generated");
            }
        }

        public void cssRuleStart(String selector, String source) {
            this.check();
            this.builder.append("<p>");
            this.builder.append("<b>").append(selector).append("</b>");
            this.builder.append("&nbsp;<b>{</b>&nbsp;").append("/*&nbsp;").append(source).append("&nbsp;*/");
        }

        public void cssRuleEnd() {
            this.check();
            this.builder.append("<br>");
            this.builder.append("<b>}</b>");
            this.builder.append("</p>");
        }

        public void addProperty(String name, String content, boolean applied) {
            this.check();
            String sepName = name + ":&nbsp;";
            String propName = "<b>" + (applied ? sepName : "<strike>" + sepName + "</strike>") + "</b>";
            this.builder.append("<br>");
            content = applied ? content : "<strike>" + content + "</strike>";
            this.builder.append("<span style=\"margin-left:10px;\">").append(propName).append(content).append(";").append("</span>");
        }

        public void addMessage(String mess) {
            this.check();
            this.builder.append(mess);
        }

        public String getHtmlString() {
            if (this.html == null) {
                this.builder.append(END_STRING);
                this.html = this.builder.toString();
            }
            return this.html;
        }

        public boolean isEmpty() {
            return this.builder.toString().equals(INIT_STRING);
        }
    }

    private class DefaultValueTableCell
    extends CssValueTableCell {
        private DefaultValueTableCell() {
        }

        @Override
        protected CssContentMaker.PropertyState getPropertyState(NodeCssState.CssProperty item) {
            CssContentMaker.PropertyState ret = (CssContentMaker.PropertyState)item.fxThemeState().get();
            if (ret == null) {
                boolean foundNotApplied = false;
                CssContentMaker.CssPropertyState winner = item.getWinner();
                if (winner != null) {
                    for (CssContentMaker.CssPropertyState.CssStyle np : winner.getNotAppliedStyles()) {
                        if (np.getOrigin() != StyleOrigin.USER_AGENT) continue;
                        foundNotApplied = true;
                        break;
                    }
                }
                if (!foundNotApplied) {
                    ret = (CssContentMaker.PropertyState)item.builtinState().get();
                }
            }
            return ret;
        }

        @Override
        protected CssContentMaker.CssPropertyState.CssStyle getStyle(NodeCssState.CssProperty item) {
            CssContentMaker.CssPropertyState.CssStyle style = null;
            CssContentMaker.CssPropertyState fxTheme = (CssContentMaker.CssPropertyState)item.fxThemeState().get();
            if (fxTheme == null) {
                CssContentMaker.CssPropertyState winner = item.getWinner();
                if (winner != null) {
                    for (CssContentMaker.CssPropertyState.CssStyle np : winner.getNotAppliedStyles()) {
                        if (np.getOrigin() != StyleOrigin.USER_AGENT) continue;
                        style = np;
                        break;
                    }
                }
            } else {
                style = fxTheme.getStyle();
            }
            return style;
        }

        @Override
        protected boolean isWinner(NodeCssState.CssProperty item) {
            return item.isFxThemeSource() || item.isBuiltinSource();
        }

        @Override
        protected StyleOrigin getOrigin(NodeCssState.CssProperty item) {
            CssContentMaker.PropertyState state = this.getPropertyState(item);
            if (state instanceof CssContentMaker.CssPropertyState || state == null) {
                return StyleOrigin.USER_AGENT;
            }
            return null;
        }

        @Override
        protected String getNavigation(NodeCssState.CssProperty item, CssContentMaker.CssPropertyState.CssStyle style) {
            CssContentMaker.PropertyState ps = this.getPropertyState(item);
            if (ps == null || ps instanceof CssContentMaker.CssPropertyState) {
                return I18N.getString("csspanel.fxtheme.defaults.navigation") + " (" + CssInternal.getThemeDisplayName(style.getStyle()) + ")";
            }
            return I18N.getString("csspanel.api.defaults.navigation");
        }
    }

    private class InlineValueTableCell
    extends CssValueTableCell {
        private InlineValueTableCell() {
        }

        @Override
        protected CssContentMaker.PropertyState getPropertyState(NodeCssState.CssProperty item) {
            return (CssContentMaker.PropertyState)item.inlineState().get();
        }

        @Override
        protected boolean isWinner(NodeCssState.CssProperty item) {
            return item.isInlineSource();
        }

        @Override
        protected StyleOrigin getOrigin(NodeCssState.CssProperty item) {
            return StyleOrigin.INLINE;
        }

        @Override
        protected CssContentMaker.CssPropertyState.CssStyle getStyle(NodeCssState.CssProperty item) {
            CssContentMaker.CssPropertyState ps = (CssContentMaker.CssPropertyState)item.inlineState().get();
            return ps == null ? null : ps.getStyle();
        }
    }

    private class AuthorValueTableCell
    extends CssValueTableCell {
        private AuthorValueTableCell() {
        }

        @Override
        protected CssContentMaker.PropertyState getPropertyState(NodeCssState.CssProperty item) {
            return (CssContentMaker.PropertyState)item.authorState().get();
        }

        @Override
        protected boolean isWinner(NodeCssState.CssProperty item) {
            return item.isAuthorSource();
        }

        @Override
        protected StyleOrigin getOrigin(NodeCssState.CssProperty item) {
            return StyleOrigin.AUTHOR;
        }

        @Override
        protected CssContentMaker.CssPropertyState.CssStyle getStyle(NodeCssState.CssProperty item) {
            CssContentMaker.CssPropertyState ps = (CssContentMaker.CssPropertyState)item.authorState().get();
            return ps == null ? null : ps.getStyle();
        }
    }

    private class ModelValueTableCell
    extends CssValueTableCell {
        private ModelValueTableCell() {
        }

        @Override
        protected CssContentMaker.PropertyState getPropertyState(NodeCssState.CssProperty item) {
            return (CssContentMaker.PropertyState)item.modelState().get();
        }

        @Override
        protected boolean isWinner(NodeCssState.CssProperty item) {
            return item.isModelSource();
        }

        @Override
        protected StyleOrigin getOrigin(NodeCssState.CssProperty item) {
            return StyleOrigin.USER;
        }

        @Override
        protected CssContentMaker.CssPropertyState.CssStyle getStyle(NodeCssState.CssProperty item) {
            return null;
        }
    }

    private class FxThemeValueTableCell
    extends CssValueTableCell {
        private FxThemeValueTableCell() {
        }

        @Override
        protected CssContentMaker.PropertyState getPropertyState(NodeCssState.CssProperty item) {
            return (CssContentMaker.PropertyState)item.fxThemeState().get();
        }

        @Override
        protected boolean isWinner(NodeCssState.CssProperty item) {
            return item.isFxThemeSource();
        }

        @Override
        protected StyleOrigin getOrigin(NodeCssState.CssProperty item) {
            return StyleOrigin.USER_AGENT;
        }

        @Override
        protected CssContentMaker.CssPropertyState.CssStyle getStyle(NodeCssState.CssProperty item) {
            CssContentMaker.CssPropertyState ps = (CssContentMaker.CssPropertyState)item.fxThemeState().get();
            return ps == null ? null : ps.getStyle();
        }
    }

    private class BuiltinValueTableCell
    extends CssValueTableCell {
        private BuiltinValueTableCell() {
        }

        @Override
        protected CssContentMaker.PropertyState getPropertyState(NodeCssState.CssProperty item) {
            return (CssContentMaker.PropertyState)item.builtinState().get();
        }

        @Override
        protected boolean isWinner(NodeCssState.CssProperty item) {
            return item.isBuiltinSource();
        }

        @Override
        protected StyleOrigin getOrigin(NodeCssState.CssProperty item) {
            return null;
        }

        @Override
        protected CssContentMaker.CssPropertyState.CssStyle getStyle(NodeCssState.CssProperty item) {
            return null;
        }
    }

    private abstract class CssValueTableCell
    extends TableCell<NodeCssState.CssProperty, NodeCssState.CssProperty> {
        private final List<Value> values = new ArrayList<Value>();
        private VBox valueBox;
        private MenuButton navigationMenuButton;
        private FadeTransition fadeTransition;
        private final MenuItem revealInInspectorMenuItem = new MenuItem(I18N.getString("csspanel.reveal.inspector"));
        private final MenuItem revealInFileBrowserMenuItem = new MenuItem();
        private MenuItem openStylesheetMenuItem = new MenuItem();

        private CssValueTableCell() {
        }

        public void updateItem(NodeCssState.CssProperty item, boolean empty) {
            super.updateItem((Object)item, empty);
            this.values.clear();
            this.setGraphic(null);
            if (!empty) {
                if (this.getStyle(item) != null && !this.getStyle(item).isUsed()) {
                    return;
                }
                this.valueBox = new VBox(2.0);
                this.valueBox.setAlignment(Pos.CENTER);
                CssContentMaker.PropertyState cssState = this.getPropertyState(item);
                if (cssState != null) {
                    Node n = CssPanelController.createValueUI(item, cssState, cssState.getFxValue(), this.getStyle(item));
                    if (n == null) {
                        Label label = new Label(cssState.getCssValue());
                        n = label;
                    }
                    Value currentValue = new Value(n);
                    if (this.isWinner(item)) {
                        currentValue.getStyleClass().add((Object)"winner-background");
                    }
                    this.values.add(currentValue);
                    this.handleSource(currentValue, item, this.getStyle(item));
                }
                this.handleNotApplied(item);
                this.displayValues();
            }
        }

        private void displayValues() {
            for (Value v : this.values) {
                VBox.setVgrow((Node)v, (Priority)Priority.ALWAYS);
                this.valueBox.getChildren().add((Object)v);
            }
            this.setGraphic((Node)this.valueBox);
            this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        }

        protected abstract CssContentMaker.PropertyState getPropertyState(NodeCssState.CssProperty var1);

        protected abstract CssContentMaker.CssPropertyState.CssStyle getStyle(NodeCssState.CssProperty var1);

        protected abstract boolean isWinner(NodeCssState.CssProperty var1);

        protected abstract StyleOrigin getOrigin(NodeCssState.CssProperty var1);

        protected String getNavigation(NodeCssState.CssProperty item, CssContentMaker.CssPropertyState.CssStyle style) {
            return CssPanelController.getNavigationInfo(item, style, this.getOrigin(item));
        }

        private void handleNotApplied(NodeCssState.CssProperty item) {
            CssContentMaker.CssPropertyState ps = item.getWinner();
            if (ps != null) {
                for (CssContentMaker.CssPropertyState.CssStyle style : ps.getNotAppliedStyles()) {
                    if (style.getOrigin() != this.getOrigin(item) || CssContentMaker.containsPseudoState(style.getSelector())) continue;
                    Node n = CssPanelController.createValueUI(item, style);
                    if (n == null) {
                        n = CssPanelController.getLabel(style);
                    }
                    Value currentValue = new Value(n);
                    this.values.add(currentValue);
                    this.handleSource(currentValue, item, style);
                }
            }
            if (this.getOrigin(item) == StyleOrigin.USER_AGENT) {
                List<CssContentMaker.CssPropertyState.CssStyle> styles = item.getFxThemeHiddenByModel();
                for (CssContentMaker.CssPropertyState.CssStyle style : styles) {
                    Node n = CssPanelController.createValueUI(item, style);
                    if (n == null) {
                        String l = CssValueConverter.toCssString(style.getCssProperty(), style.getCssRule(), style.getParsedValue());
                        Label label = new Label(l);
                        n = label;
                    }
                    Value currentValue = new Value(n);
                    this.values.add(currentValue);
                    this.handleSource(currentValue, item, style);
                }
            }
        }

        private void handleSource(Value currentValue, NodeCssState.CssProperty item, CssContentMaker.CssPropertyState.CssStyle style) {
            String nav;
            if (style != null && !style.isUsed()) {
                return;
            }
            StyleOrigin origin = this.getOrigin(item);
            String source = CssPanelController.getSourceInfo(item, style, origin);
            if (source != null) {
                Label sourceLabel = new Label(source);
                sourceLabel.getStyleClass().add((Object)"note-label");
                currentValue.setSource(sourceLabel);
            }
            if ((nav = this.getNavigation(item, style)) != null) {
                Label navigationLabel = new Label(nav);
                navigationLabel.getStyleClass().add((Object)"note-label");
                if (origin != null && origin != StyleOrigin.USER_AGENT) {
                    this.createNavigationMenuButton();
                    this.openStylesheetMenuItem = new MenuItem(MessageFormat.format(I18N.getString("csspanel.open.stylesheet"), nav));
                    if (origin == StyleOrigin.USER || origin == StyleOrigin.INLINE) {
                        this.navigationMenuButton.getItems().add((Object)this.revealInInspectorMenuItem);
                        this.revealInInspectorMenuItem.setOnAction(event -> CssPanelController.this.navigate(item, this.getPropertyState(item), style, origin));
                        if (CssPanelController.this.applicationDelegate == null) {
                            this.revealInInspectorMenuItem.setDisable(true);
                        }
                    } else if (origin == StyleOrigin.AUTHOR) {
                        this.navigationMenuButton.getItems().add((Object)this.openStylesheetMenuItem);
                        this.navigationMenuButton.getItems().add((Object)this.revealInFileBrowserMenuItem);
                        this.revealInFileBrowserMenuItem.setText(EditorPlatform.IS_MAC ? MessageFormat.format(I18N.getString("csspanel.reveal.finder"), nav) : MessageFormat.format(I18N.getString("csspanel.reveal.explorer"), nav));
                        this.revealInFileBrowserMenuItem.setOnAction(event -> CssPanelController.this.navigate(item, this.getPropertyState(item), style, origin));
                        this.openStylesheetMenuItem.setOnAction(event -> CssPanelController.this.open(item, this.getPropertyState(item), style, origin));
                    }
                }
                currentValue.setNavigation(navigationLabel, this.navigationMenuButton);
            }
            currentValue.showSource(true);
        }

        private void createNavigationMenuButton() {
            this.navigationMenuButton = new MenuButton();
            Region region = new Region();
            this.navigationMenuButton.setGraphic((Node)region);
            region.getStyleClass().add((Object)"cog-shape");
            this.navigationMenuButton.setOpacity(0.0);
            this.navigationMenuButton.getStyleClass().addAll((Object[])new String[]{"css-panel-cog-menubutton"});
            this.fadeTransition = new FadeTransition(Duration.millis((double)500.0), (Node)this.navigationMenuButton);
        }

        private class Value
        extends AnchorPane {
            private final VBox vbox = new VBox(2.0);
            private Label sourceLabel;
            private MenuButton navigationMenuButton;

            private Value(Node value) {
                CssValueTableCell.this.setAlignment(Pos.CENTER_LEFT);
                this.vbox.getChildren().add((Object)value);
                this.getChildren().add((Object)this.vbox);
                AnchorPane.setTopAnchor((Node)this.vbox, (Double)4.0);
                AnchorPane.setLeftAnchor((Node)this.vbox, (Double)4.0);
                AnchorPane.setRightAnchor((Node)this.vbox, (Double)4.0);
                AnchorPane.setBottomAnchor((Node)this.vbox, (Double)4.0);
                this.setOnMouseEntered(arg0 -> {
                    if (this.navigationMenuButton != null && !this.navigationMenuButton.isShowing()) {
                        this.fadeMenuButtonTo(1.0);
                    }
                });
                this.setOnMouseExited(arg0 -> {
                    if (this.navigationMenuButton != null && !this.navigationMenuButton.isShowing()) {
                        this.fadeMenuButtonTo(0.0);
                    }
                });
            }

            private void setSource(Label sourceLabel) {
                this.sourceLabel = sourceLabel;
                this.vbox.getChildren().add((Object)sourceLabel);
            }

            private void setNavigation(Label navigationLabel, MenuButton navigationMenuButton) {
                this.navigationMenuButton = navigationMenuButton;
                this.vbox.getChildren().add((Object)navigationLabel);
                if (navigationMenuButton != null) {
                    this.getChildren().add((Object)navigationMenuButton);
                    AnchorPane.setTopAnchor((Node)navigationMenuButton, (Double)4.0);
                    AnchorPane.setRightAnchor((Node)navigationMenuButton, (Double)4.0);
                }
            }

            private void showSource(boolean show) {
                if (this.sourceLabel != null) {
                    this.sourceLabel.setVisible(show);
                }
                if (this.navigationMenuButton != null) {
                    this.navigationMenuButton.setVisible(show);
                }
            }

            private void fadeMenuButtonTo(double toValue) {
                CssValueTableCell.this.fadeTransition.stop();
                CssValueTableCell.this.fadeTransition.setFromValue(this.navigationMenuButton.getOpacity());
                CssValueTableCell.this.fadeTransition.setToValue(toValue);
                CssValueTableCell.this.fadeTransition.play();
            }
        }
    }

    private static class LinkActionListener
    implements EventHandler<ActionEvent> {
        final NodeCssState.CssProperty item;

        public LinkActionListener(NodeCssState.CssProperty item) {
            this.item = item;
        }

        public void handle(ActionEvent event) {
            try {
                EditorPlatform.open("https://docs.oracle.com/javase/8/javafx/api/javafx/scene/doc-files/cssref.html#" + this.item.getTarget().getClass().getSimpleName().toLowerCase(Locale.ROOT));
            }
            catch (IOException ex) {
                System.out.println(ex.getMessage());
            }
        }
    }

    private static class CssPropertyTableCell
    extends TableCell<NodeCssState.CssProperty, NodeCssState.CssProperty> {
        CssPropertyTableCell() {
            this.getStyleClass().add((Object)"property-background");
        }

        public void updateItem(NodeCssState.CssProperty item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setGraphic(null);
            } else {
                Hyperlink hl = new Hyperlink();
                hl.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
                hl.setOnAction((EventHandler)new LinkActionListener(item));
                hl.setAlignment(Pos.CENTER_LEFT);
                if (item.getMainProperty() != null) {
                    hl.setText("     " + (String)item.propertyName().get());
                } else {
                    hl.setText((String)item.propertyName().get());
                }
                this.setGraphic((Node)hl);
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            }
        }
    }

    private class DefaultCellFactory
    implements Callback<TableColumn<NodeCssState.CssProperty, NodeCssState.CssProperty>, TableCell<NodeCssState.CssProperty, NodeCssState.CssProperty>> {
        private DefaultCellFactory() {
        }

        public TableCell<NodeCssState.CssProperty, NodeCssState.CssProperty> call(TableColumn<NodeCssState.CssProperty, NodeCssState.CssProperty> param) {
            return new DefaultValueTableCell();
        }
    }

    private class InlineCellFactory
    implements Callback<TableColumn<NodeCssState.CssProperty, NodeCssState.CssProperty>, TableCell<NodeCssState.CssProperty, NodeCssState.CssProperty>> {
        private InlineCellFactory() {
        }

        public TableCell<NodeCssState.CssProperty, NodeCssState.CssProperty> call(TableColumn<NodeCssState.CssProperty, NodeCssState.CssProperty> param) {
            return new InlineValueTableCell();
        }
    }

    private class AuthorCellFactory
    implements Callback<TableColumn<NodeCssState.CssProperty, NodeCssState.CssProperty>, TableCell<NodeCssState.CssProperty, NodeCssState.CssProperty>> {
        private AuthorCellFactory() {
        }

        public TableCell<NodeCssState.CssProperty, NodeCssState.CssProperty> call(TableColumn<NodeCssState.CssProperty, NodeCssState.CssProperty> param) {
            return new AuthorValueTableCell();
        }
    }

    private class ModelCellFactory
    implements Callback<TableColumn<NodeCssState.CssProperty, NodeCssState.CssProperty>, TableCell<NodeCssState.CssProperty, NodeCssState.CssProperty>> {
        private ModelCellFactory() {
        }

        public TableCell<NodeCssState.CssProperty, NodeCssState.CssProperty> call(TableColumn<NodeCssState.CssProperty, NodeCssState.CssProperty> param) {
            return new ModelValueTableCell();
        }
    }

    private class FxThemeCellFactory
    implements Callback<TableColumn<NodeCssState.CssProperty, NodeCssState.CssProperty>, TableCell<NodeCssState.CssProperty, NodeCssState.CssProperty>> {
        private FxThemeCellFactory() {
        }

        public TableCell<NodeCssState.CssProperty, NodeCssState.CssProperty> call(TableColumn<NodeCssState.CssProperty, NodeCssState.CssProperty> param) {
            return new FxThemeValueTableCell();
        }
    }

    private class BuiltinCellFactory
    implements Callback<TableColumn<NodeCssState.CssProperty, NodeCssState.CssProperty>, TableCell<NodeCssState.CssProperty, NodeCssState.CssProperty>> {
        private BuiltinCellFactory() {
        }

        public TableCell<NodeCssState.CssProperty, NodeCssState.CssProperty> call(TableColumn<NodeCssState.CssProperty, NodeCssState.CssProperty> param) {
            return new BuiltinValueTableCell();
        }
    }

    private static class PropertiesCellFactory
    implements Callback<TableColumn<NodeCssState.CssProperty, NodeCssState.CssProperty>, TableCell<NodeCssState.CssProperty, NodeCssState.CssProperty>> {
        private PropertiesCellFactory() {
        }

        public TableCell<NodeCssState.CssProperty, NodeCssState.CssProperty> call(TableColumn<NodeCssState.CssProperty, NodeCssState.CssProperty> param) {
            return new CssPropertyTableCell();
        }
    }

    private static class ValueFactory
    implements Callback<TableColumn.CellDataFeatures<NodeCssState.CssProperty, NodeCssState.CssProperty>, ObservableValue<NodeCssState.CssProperty>> {
        private ValueFactory() {
        }

        public ObservableValue<NodeCssState.CssProperty> call(TableColumn.CellDataFeatures<NodeCssState.CssProperty, NodeCssState.CssProperty> param) {
            SimpleObjectProperty val = new SimpleObjectProperty();
            val.setValue(param.getValue());
            return val;
        }
    }

    public static abstract class Delegate {
        public abstract void revealInspectorEditor(ValuePropertyMetadata var1);
    }

    public static enum View {
        TABLE,
        RULES,
        TEXT;

    }
}

