/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.handles;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.ContentPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.handles.AbstractCurveHandles;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.AbstractGesture;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.mouse.EditCurveGesture;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import javafx.collections.ObservableList;
import javafx.geometry.Point2D;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Line;

public class LineHandles
extends AbstractCurveHandles<Line> {
    private final Circle startHandle = new Circle(5.0);
    private final Circle endHandle = new Circle(5.0);

    public LineHandles(ContentPanelController contentPanelController, FXOMInstance fxomInstance) {
        super(contentPanelController, fxomInstance, Line.class);
        this.setupHandleState(this.startHandle);
        this.setupHandleState(this.endHandle);
        this.setupHandles((Node)this.startHandle);
        this.setupHandles((Node)this.endHandle);
        ObservableList rootNodeChildren = this.getRootNode().getChildren();
        rootNodeChildren.add(this.startHandle);
        rootNodeChildren.add(this.endHandle);
    }

    public FXOMInstance getFxomInstance() {
        return (FXOMInstance)this.getFxomObject();
    }

    @Override
    protected void layoutDecoration() {
        Line l = (Line)this.getSceneGraphObject();
        boolean snapToPixel = true;
        Point2D s = this.sceneGraphObjectToDecoration(l.getStartX(), l.getStartY(), true);
        Point2D e = this.sceneGraphObjectToDecoration(l.getEndX(), l.getEndY(), true);
        this.startHandle.setCenterX(s.getX());
        this.startHandle.setCenterY(s.getY());
        this.endHandle.setCenterX(e.getX());
        this.endHandle.setCenterY(e.getY());
    }

    @Override
    protected void startListeningToSceneGraphObject() {
        super.startListeningToSceneGraphObject();
        Line l = (Line)this.getSceneGraphObject();
        l.startXProperty().addListener(this.coordinateListener);
        l.startYProperty().addListener(this.coordinateListener);
        l.endXProperty().addListener(this.coordinateListener);
        l.endYProperty().addListener(this.coordinateListener);
    }

    @Override
    protected void stopListeningToSceneGraphObject() {
        super.stopListeningToSceneGraphObject();
        Line l = (Line)this.getSceneGraphObject();
        l.startXProperty().removeListener(this.coordinateListener);
        l.startYProperty().removeListener(this.coordinateListener);
        l.endXProperty().removeListener(this.coordinateListener);
        l.endYProperty().removeListener(this.coordinateListener);
    }

    @Override
    public AbstractGesture findGesture(Node node) {
        EditCurveGesture result = node == this.startHandle ? new EditCurveGesture(this.getContentPanelController(), EditCurveGesture.Tunable.START) : (node == this.endHandle ? new EditCurveGesture(this.getContentPanelController(), EditCurveGesture.Tunable.END) : null);
        return result;
    }

    @Override
    public void enabledDidChange() {
        this.setupHandleState(this.startHandle);
        this.setupHandleState(this.endHandle);
    }

    private void setupHandleState(Circle handleCircle) {
        String styleClass = this.isEnabled() ? "selection-handles" : "selection-handles-dim";
        Cursor cursor = this.isEnabled() ? Cursor.CROSSHAIR : Cursor.DEFAULT;
        handleCircle.getStyleClass().add((Object)styleClass);
        handleCircle.setCursor(cursor);
    }

    private void setupHandles(Node node) {
        LineHandles.attachHandles(node, this);
    }
}

