/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.sourcemap.visualizer;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.icons.AllIcons;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.javascript.debugger.sourcemap.visualizer.SourceMapInspector;
import com.intellij.javascript.debugger.sourcemap.visualizer.actions.BaseSourceMapAction;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorState;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.SourceMap;
import org.jetbrains.io.LocalFileFinder;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0015H\u0016J\b\u0010\u0019\u001a\u00020\u0015H\u0016J\n\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u000bH\u0016J\n\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0011H\u0016J\b\u0010 \u001a\u00020\u000bH\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\n\u0010%\u001a\u0004\u0018\u00010&H\u0016J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020(H\u0016J\u0010\u0010*\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010+\u001a\u00020\u0015H\u0016J\u0010\u0010,\u001a\u00020\u00152\u0006\u0010-\u001a\u00020\"H\u0016J \u0010.\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010/\u001a\u00020\u0006H\u0002R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/intellij/javascript/debugger/sourcemap/visualizer/SourcemapFileViewer;", "Lcom/intellij/openapi/util/UserDataHolderBase;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)V", "generatedTextEditor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "mainPanel", "Ljavax/swing/JPanel;", "map", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "addEditorNotification", "Lcom/intellij/ui/EditorNotificationPanel;", "message", "", "icon", "Ljavax/swing/Icon;", "addPropertyChangeListener", "", "listener", "Ljava/beans/PropertyChangeListener;", "deselectNotify", "dispose", "getBackgroundHighlighter", "Lcom/intellij/codeHighlighting/BackgroundEditorHighlighter;", "getComponent", "getCurrentLocation", "Lcom/intellij/openapi/fileEditor/FileEditorLocation;", "getName", "getPreferredFocusedComponent", "getState", "Lcom/intellij/openapi/fileEditor/FileEditorState;", "level", "Lcom/intellij/openapi/fileEditor/FileEditorStateLevel;", "getStructureViewBuilder", "Lcom/intellij/ide/structureView/StructureViewBuilder;", "isModified", "", "isValid", "removePropertyChangeListener", "selectNotify", "setState", "state", "visualize", "generatedFile", "intellij.javascript.debugger"})
public final class SourcemapFileViewer
extends UserDataHolderBase
implements FileEditor {
    private final SourceMap map;
    private final JPanel mainPanel;
    private TextEditor generatedTextEditor;

    private final EditorNotificationPanel addEditorNotification(Project project, String message, Icon icon) {
        EditorNotificationPanel notificationPanel = new EditorNotificationPanel().text(message).icon(icon);
        FileEditorManager.getInstance((Project)project).addTopComponent((FileEditor)this, (JComponent)notificationPanel);
        EditorNotificationPanel editorNotificationPanel = notificationPanel;
        Intrinsics.checkExpressionValueIsNotNull((Object)editorNotificationPanel, (String)"notificationPanel");
        return editorNotificationPanel;
    }

    private final void visualize(SourceMap map, Project project, VirtualFile generatedFile) {
        SourceMapInspector mapInspector = new SourceMapInspector(map, generatedFile, project, (Disposable)this, null);
        this.mainPanel.add((Component)mapInspector.createMainComponent(null), "Center");
        this.generatedTextEditor = mapInspector.getGeneratedTextEditor$intellij_javascript_debugger();
    }

    @NotNull
    public JPanel getComponent() {
        return this.mainPanel;
    }

    @NotNull
    public JPanel getPreferredFocusedComponent() {
        return this.mainPanel;
    }

    @NotNull
    public String getName() {
        return "Visualizer";
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        FileEditorState fileEditorState;
        Intrinsics.checkParameterIsNotNull((Object)level, (String)"level");
        if (this.generatedTextEditor == null) {
            fileEditorState = (FileEditorState)new TextEditorState();
        } else {
            TextEditor textEditor = this.generatedTextEditor;
            if (textEditor == null) {
                Intrinsics.throwNpe();
            }
            FileEditorState fileEditorState2 = textEditor.getState(level);
            fileEditorState = fileEditorState2;
            Intrinsics.checkExpressionValueIsNotNull((Object)fileEditorState2, (String)"generatedTextEditor!!.getState(level)");
        }
        return fileEditorState;
    }

    public void setState(@NotNull FileEditorState state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        if (this.generatedTextEditor != null && state instanceof TextEditorState) {
            TextEditor textEditor = this.generatedTextEditor;
            if (textEditor == null) {
                Intrinsics.throwNpe();
            }
            textEditor.setState(state);
        }
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void selectNotify() {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(this){
            final /* synthetic */ SourcemapFileViewer this$0;

            public final void run() {
                if (SourcemapFileViewer.access$getGeneratedTextEditor$p(this.this$0) != null) {
                    TextEditor textEditor = SourcemapFileViewer.access$getGeneratedTextEditor$p(this.this$0);
                    if (textEditor == null) {
                        Intrinsics.throwNpe();
                    }
                    textEditor.selectNotify();
                }
            }
            {
                this.this$0 = sourcemapFileViewer;
            }
        });
    }

    public void deselectNotify() {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(this){
            final /* synthetic */ SourcemapFileViewer this$0;

            public final void run() {
                if (SourcemapFileViewer.access$getGeneratedTextEditor$p(this.this$0) != null) {
                    TextEditor textEditor = SourcemapFileViewer.access$getGeneratedTextEditor$p(this.this$0);
                    if (textEditor == null) {
                        Intrinsics.throwNpe();
                    }
                    textEditor.deselectNotify();
                }
            }
            {
                this.this$0 = sourcemapFileViewer;
            }
        });
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        FileEditorLocation fileEditorLocation;
        if (this.generatedTextEditor == null) {
            fileEditorLocation = null;
        } else {
            TextEditor textEditor = this.generatedTextEditor;
            if (textEditor == null) {
                Intrinsics.throwNpe();
            }
            fileEditorLocation = textEditor.getCurrentLocation();
        }
        return fileEditorLocation;
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public void dispose() {
    }

    public SourcemapFileViewer(final @NotNull Project project, final @NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this.mainPanel = new JPanel(new BorderLayout());
        final Pair<SourceMap, Exception> result2 = BaseSourceMapAction.Companion.compute(file);
        this.map = (SourceMap)result2.first;
        if (this.map == null) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public final void run() {
                    String string = result2.second == null ? "Map is empty" : "Cannot decode sourcemap";
                    Icon icon = result2.second == null ? AllIcons.General.Information : AllIcons.General.ExclMark;
                    Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"if (result.second == nul\u2026AllIcons.General.ExclMark");
                    this.addEditorNotification(project, string, icon);
                }
            }, project.getDisposed());
        } else {
            VirtualFile generatedFile = null;
            if (this.map.getOutFile() != null) {
                VirtualFile virtualFile;
                VirtualFile virtualFile2 = file.getParent();
                String string = this.map.getOutFile();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                if ((virtualFile = virtualFile2.findFileByRelativePath(string)) == null) {
                    String string2 = this.map.getOutFile();
                    if (string2 == null) {
                        Intrinsics.throwNpe();
                    }
                    virtualFile = generatedFile = LocalFileFinder.findFile((String)string2);
                }
            }
            if (generatedFile == null) {
                String string = file.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.name");
                String fileName = string;
                if (StringsKt.endsWith$default((String)fileName, (String)".map", (boolean)false, (int)2, null)) {
                    String string3 = fileName;
                    int n = 0;
                    int n2 = fileName.length() - ".map".length();
                    VirtualFile virtualFile = file.getParent();
                    String string4 = string3;
                    if (string4 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string5 = string4.substring(n, n2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    String string6 = string5;
                    generatedFile = virtualFile.findChild(string6);
                }
            }
            if (generatedFile == null) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public final void run() {
                        Icon icon = AllIcons.General.ExclMark;
                        Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"AllIcons.General.ExclMark");
                        final EditorNotificationPanel notificationPanel = this.addEditorNotification(project, "Cannot find generated file", icon);
                        notificationPanel.createActionLabel("Browse", new Runnable(){

                            @Override
                            public final void run() {
                                FileChooserDescriptor descriptor;
                                FileChooserDescriptor fileChooserDescriptor = descriptor = FileChooserDescriptorFactory.createSingleFileDescriptor((FileType)((FileType)JavaScriptFileType.INSTANCE));
                                Intrinsics.checkExpressionValueIsNotNull((Object)fileChooserDescriptor, (String)"descriptor");
                                fileChooserDescriptor.setTitle("Select Generated File");
                                FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)project, (VirtualFile)file.getParent(), (Consumer)((Consumer)new Consumer<VirtualFile>(){

                                    public final void consume(VirtualFile file) {
                                        FileEditorManager.getInstance((Project)project).removeTopComponent((FileEditor)this, (JComponent)notificationPanel);
                                        SourcemapFileViewer sourcemapFileViewer = this;
                                        SourceMap sourceMap = map;
                                        Project project = project;
                                        VirtualFile virtualFile = file;
                                        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"file");
                                        sourcemapFileViewer.visualize(sourceMap, project, virtualFile);
                                    }
                                }));
                            }
                        });
                    }
                });
            } else {
                this.visualize(this.map, project, generatedFile);
            }
        }
    }

    @Nullable
    public static final /* synthetic */ TextEditor access$getGeneratedTextEditor$p(SourcemapFileViewer $this) {
        return $this.generatedTextEditor;
    }

    public static final /* synthetic */ void access$setGeneratedTextEditor$p(SourcemapFileViewer $this, @Nullable TextEditor textEditor) {
        $this.generatedTextEditor = textEditor;
    }
}

