/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.scripts;

import com.intellij.javascript.debugger.scripts.FileInfo;
import com.intellij.javascript.debugger.scripts.FileNode;
import com.intellij.javascript.debugger.scripts.SourcesTreeComponent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0018\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH$J\u0010\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0014\u0010\u0007\u001a\u00020\b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\nR\u0014\u0010\f\u001a\u00020\r8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001f"}, d2={"Lcom/intellij/javascript/debugger/scripts/ScriptTreeActionBase;", "Lcom/intellij/openapi/actionSystem/AnAction;", "treeComponent", "Lcom/intellij/javascript/debugger/scripts/SourcesTreeComponent;", "text", "", "(Lcom/intellij/javascript/debugger/scripts/SourcesTreeComponent;Ljava/lang/String;)V", "invisibleIfDisabled", "", "getInvisibleIfDisabled", "()Z", "isOnlyFile", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getTreeComponent", "()Lcom/intellij/javascript/debugger/scripts/SourcesTreeComponent;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isApplicable", "info", "Lcom/intellij/javascript/debugger/scripts/FileInfo;", "perform", "node", "Lcom/intellij/javascript/debugger/scripts/FileNode;", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "update", "intellij.javascript.debugger"})
public abstract class ScriptTreeActionBase
extends AnAction {
    @NotNull
    private final SourcesTreeComponent treeComponent;

    protected boolean isOnlyFile() {
        return true;
    }

    protected boolean getInvisibleIfDisabled() {
        return true;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        FileNode node = this.treeComponent.getSelectedNode();
        boolean applicable = node != null && (!this.isOnlyFile() || node.getFileInfo().isFile()) && this.isApplicable(node.getFileInfo());
        Presentation presentation = e.getPresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
        presentation.setEnabled(applicable);
        if (this.getInvisibleIfDisabled()) {
            Presentation presentation2 = e.getPresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation2, (String)"e.presentation");
            presentation2.setVisible(applicable);
        }
    }

    protected boolean isApplicable(@NotNull FileInfo info) {
        Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
        return true;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        FileNode node = this.treeComponent.getSelectedNode();
        if (node != null) {
            DataContext dataContext = e.getDataContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)dataContext, (String)"e.dataContext");
            this.perform(node, dataContext);
        }
    }

    @NotNull
    protected final Project getProject() {
        XDebugSession xDebugSession = this.treeComponent.getDebugProcess().getSession();
        Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"treeComponent.debugProcess.session");
        Project project = xDebugSession.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"treeComponent.debugProcess.session.project");
        return project;
    }

    protected abstract void perform(@NotNull FileNode var1, @NotNull DataContext var2);

    @NotNull
    protected final SourcesTreeComponent getTreeComponent() {
        return this.treeComponent;
    }

    public ScriptTreeActionBase(@NotNull SourcesTreeComponent treeComponent, @Nullable String text) {
        Intrinsics.checkParameterIsNotNull((Object)treeComponent, (String)"treeComponent");
        super(text);
        this.treeComponent = treeComponent;
    }
}

