/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.ApiClass;
import com.android.tools.lint.checks.ApiClassOwner;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class ApiParser
extends DefaultHandler {
    private static final String NODE_CLASS = "class";
    private static final String NODE_FIELD = "field";
    private static final String NODE_METHOD = "method";
    private static final String NODE_EXTENDS = "extends";
    private static final String NODE_IMPLEMENTS = "implements";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_SINCE = "since";
    private static final String ATTR_DEPRECATED = "deprecated";
    private static final String ATTR_REMOVED = "removed";
    private final Map<String, ApiClass> mClasses = new HashMap<String, ApiClass>(6000);
    private final Map<String, ApiClassOwner> mContainers = new HashMap<String, ApiClassOwner>();
    private ApiClass mCurrentClass;

    ApiParser() {
    }

    Map<String, ApiClass> getClasses() {
        return this.mClasses;
    }

    Map<String, ApiClassOwner> getContainers() {
        return this.mContainers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (localName == null || localName.isEmpty()) {
            localName = qName;
        }
        try {
            if (NODE_METHOD.equals(localName)) {
                String name = attributes.getValue(ATTR_NAME);
                int since = this.getSince(attributes);
                int deprecatedIn = this.getDeprecatedIn(attributes);
                int removedIn = this.getRemovedIn(attributes);
                this.mCurrentClass.addMethod(name, since, deprecatedIn, removedIn);
            } else if (NODE_FIELD.equals(localName)) {
                String name = attributes.getValue(ATTR_NAME);
                int since = this.getSince(attributes);
                int deprecatedIn = this.getDeprecatedIn(attributes);
                int removedIn = this.getRemovedIn(attributes);
                this.mCurrentClass.addField(name, since, deprecatedIn, removedIn);
            } else if (NODE_IMPLEMENTS.equals(localName)) {
                String name = attributes.getValue(ATTR_NAME);
                int since = this.getSince(attributes);
                int removedIn = this.getRemovedIn(attributes);
                this.mCurrentClass.addInterface(name, since, removedIn);
            } else if (NODE_EXTENDS.equals(localName)) {
                String name = attributes.getValue(ATTR_NAME);
                int since = this.getSince(attributes);
                int removedIn = this.getRemovedIn(attributes);
                this.mCurrentClass.addSuperClass(name, since, removedIn);
            } else if (NODE_CLASS.equals(localName)) {
                String name = attributes.getValue(ATTR_NAME);
                int since = this.getAttributeValue(attributes, ATTR_SINCE, 1);
                int deprecatedIn = this.getAttributeValue(attributes, ATTR_DEPRECATED, 0);
                int removedIn = this.getAttributeValue(attributes, ATTR_REMOVED, 0);
                this.mCurrentClass = this.addClass(name, since, deprecatedIn, removedIn);
            }
        }
        finally {
            super.startElement(uri, localName, qName, attributes);
        }
    }

    private ApiClass addClass(String name, int apiLevel, int deprecatedIn, int removedIn) {
        ApiClass cls = this.mClasses.get(name);
        assert (cls == null);
        cls = new ApiClass(name, apiLevel, deprecatedIn, removedIn);
        this.mClasses.put(name, cls);
        String containerName = cls.getContainerName();
        int len = containerName.length();
        boolean isClass = len < name.length() && name.charAt(len) == '$';
        ApiClassOwner container = this.mContainers.get(containerName);
        if (container == null) {
            container = new ApiClassOwner(containerName, isClass);
            this.mContainers.put(containerName, container);
        } else if (container.isClass() != isClass) {
            throw new RuntimeException("\"" + containerName + "\" is both a package and a class");
        }
        container.addClass(cls);
        return cls;
    }

    private int getSince(Attributes attributes) {
        return this.getAttributeValue(attributes, ATTR_SINCE, this.mCurrentClass.getSince());
    }

    private int getDeprecatedIn(Attributes attributes) {
        return this.getAttributeValue(attributes, ATTR_DEPRECATED, this.mCurrentClass.getDeprecatedIn());
    }

    private int getRemovedIn(Attributes attributes) {
        return this.getAttributeValue(attributes, ATTR_REMOVED, this.mCurrentClass.getRemovedIn());
    }

    private int getAttributeValue(Attributes attributes, String attributeName, int defaultValue) {
        String attributeValue = attributes.getValue(attributeName);
        return attributeValue == null ? defaultValue : Integer.parseInt(attributeValue);
    }
}

