/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.webservice.compatibility;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.OMNodeEx;
import org.apache.axiom.om.impl.exception.OMBuilderException;
import org.apache.axiom.soap.SOAP11Constants;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axiom.soap.SOAPFaultReason;
import org.apache.axiom.soap.SOAPProcessingException;
import org.jetbrains.tfsIntegration.webservice.compatibility.CustomSOAPBuilderHelper;
import org.jetbrains.tfsIntegration.webservice.compatibility.CustomStAXSOAPModelBuilder;
import org.w3c.dom.Element;

public class CustomSOAP11BuilderHelper
extends CustomSOAPBuilderHelper
implements SOAP11Constants {
    private final SOAPFactory factory;
    private boolean faultcodePresent = false;
    private boolean faultstringPresent = false;

    public CustomSOAP11BuilderHelper(CustomStAXSOAPModelBuilder builder) {
        super(builder);
        this.factory = builder.getSoapFactory();
    }

    @Override
    public OMElement handleEvent(XMLStreamReader parser, OMElement parent, int elementLevel) throws SOAPProcessingException {
        this.parser = parser;
        OMElement element = null;
        String localName = parser.getLocalName();
        if (elementLevel == 4) {
            if ("faultcode".equals(localName)) {
                SOAPFaultCode code = this.factory.createSOAPFaultCode((SOAPFault)parent, (OMXMLParserWrapper)this.builder);
                this.processNamespaceData((OMElement)code, false);
                this.processAttributes((OMElement)code);
                this.processText(parser, (OMElement)code);
                ((OMNodeEx)code).setComplete(true);
                element = code;
                this.builder.adjustElementLevel(-1);
                this.faultcodePresent = true;
            } else if ("faultstring".equals(localName)) {
                SOAPFaultReason reason = this.factory.createSOAPFaultReason((SOAPFault)parent, (OMXMLParserWrapper)this.builder);
                this.processNamespaceData((OMElement)reason, false);
                this.processAttributes((OMElement)reason);
                this.processText(parser, (OMElement)reason);
                ((OMNodeEx)reason).setComplete(true);
                element = reason;
                this.builder.adjustElementLevel(-1);
                this.faultstringPresent = true;
            } else if ("faultactor".equals(localName)) {
                element = this.factory.createSOAPFaultRole((SOAPFault)parent, (OMXMLParserWrapper)this.builder);
                this.processNamespaceData(element, false);
                this.processAttributes(element);
            } else if ("detail".equals(localName)) {
                element = this.factory.createSOAPFaultDetail((SOAPFault)parent, (OMXMLParserWrapper)this.builder);
                this.processNamespaceData(element, false);
                this.processAttributes(element);
            } else {
                element = this.factory.createOMElement(localName, null, (OMContainer)parent, (OMXMLParserWrapper)this.builder);
                this.processNamespaceData(element, false);
                this.processAttributes(element);
            }
        } else if (elementLevel == 5) {
            String parentTagName = "";
            parentTagName = parent instanceof Element ? ((Element)parent).getTagName() : parent.getLocalName();
            if (parentTagName.equals("faultcode")) {
                throw new OMBuilderException("faultcode element should not have children");
            }
            if (parentTagName.equals("faultstring")) {
                throw new OMBuilderException("faultstring element should not have children");
            }
            if (parentTagName.equals("faultactor")) {
                throw new OMBuilderException("faultactor element should not have children");
            }
            element = this.factory.createOMElement(localName, null, (OMContainer)parent, (OMXMLParserWrapper)this.builder);
            this.processNamespaceData(element, false);
            this.processAttributes(element);
        } else if (elementLevel > 5) {
            element = this.factory.createOMElement(localName, null, (OMContainer)parent, (OMXMLParserWrapper)this.builder);
            this.processNamespaceData(element, false);
            this.processAttributes(element);
        }
        return element;
    }

    private void processText(XMLStreamReader parser, OMElement value) {
        try {
            int token = parser.next();
            while (token != 2) {
                if (token == 4) {
                    this.factory.createOMText((OMContainer)value, parser.getText());
                } else if (token == 12) {
                    this.factory.createOMText((OMContainer)value, parser.getText());
                } else {
                    throw new SOAPProcessingException("Only Characters are allowed here");
                }
                token = parser.next();
            }
        }
        catch (XMLStreamException e) {
            throw new SOAPProcessingException((Throwable)e);
        }
    }
}

