/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;
import org.jetbrains.tfsIntegration.core.tfs.version.VersionSpecBase;
import org.jetbrains.tfsIntegration.ui.MergeBranchForm;

public class MergeBranchDialog
extends DialogWrapper {
    private final String mySourcePath;
    private final boolean mySourceIsDirectory;
    private final Project myProject;
    private final WorkspaceInfo myWorkspace;
    private MergeBranchForm myMergeBranchForm;

    public MergeBranchDialog(Project project, WorkspaceInfo workspace, String sourcePath, boolean sourceIsDirectory, String title) {
        super(project, true);
        this.myProject = project;
        this.myWorkspace = workspace;
        this.mySourcePath = sourcePath;
        this.mySourceIsDirectory = sourceIsDirectory;
        this.setTitle(title);
        this.setResizable(true);
        this.init();
    }

    public String getSourcePath() {
        return this.myMergeBranchForm.getSourcePath();
    }

    public String getTargetPath() {
        return this.myMergeBranchForm.getTargetPath();
    }

    @Nullable
    public VersionSpecBase getFromVersion() {
        return this.myMergeBranchForm.getFromVersion();
    }

    @Nullable
    public VersionSpecBase getToVersion() {
        return this.myMergeBranchForm.getToVersion();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        this.myMergeBranchForm = new MergeBranchForm(this.myProject, this.myWorkspace, this.mySourcePath, this.mySourceIsDirectory, this.getTitle());
        this.myMergeBranchForm.addListener(new MergeBranchForm.Listener(){

            @Override
            public void stateChanged(boolean canFinish) {
                MergeBranchDialog.this.setOKActionEnabled(canFinish);
            }
        });
        return this.myMergeBranchForm.getContentPanel();
    }

    protected void doOKAction() {
        this.myMergeBranchForm.close();
        super.doOKAction();
    }

    public void doCancelAction() {
        this.myMergeBranchForm.close();
        super.doCancelAction();
    }

    protected String getDimensionServiceKey() {
        return "TFS.MergeBranch";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myMergeBranchForm.getPreferredFocusedComponent();
    }
}

