/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui;

import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.BranchRelative;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ExtendedItem;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ItemType;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.tfsIntegration.core.TFSBundle;
import org.jetbrains.tfsIntegration.core.tfs.ChangeTypeMask;
import org.jetbrains.tfsIntegration.core.tfs.VersionControlPath;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;
import org.jetbrains.tfsIntegration.ui.UiConstants;
import org.jetbrains.tfsIntegration.ui.treetable.CellRenderer;
import org.jetbrains.tfsIntegration.ui.treetable.ContentProvider;
import org.jetbrains.tfsIntegration.ui.treetable.CustomTreeTable;
import org.jetbrains.tfsIntegration.ui.treetable.TreeTableColumn;

public class ItemInfoForm {
    private JLabel myServerNameLabel;
    private JLabel myLocalNameLabel;
    private JLabel myLatestVersionLabel;
    private JLabel myWorkspaceVersionLabel;
    private JLabel myEncodingLabel;
    private JLabel myPendingChangesLabel;
    private JLabel myBranchesLabel;
    private CustomTreeTable<BranchRelative> myBranchesTree;
    private JPanel myPanel;
    private JLabel myDeletionIdLabel;
    private JLabel myLockLabel;
    private JScrollPane myTreePane;
    private JLabel myWorkspaceLabel;
    private final Collection<? extends BranchRelative> myBranches;
    private static final TreeTableColumn<BranchRelative> SERVER_PATH_COLUMN = new TreeTableColumn<BranchRelative>("Server path", 350){

        @Override
        public String getPresentableString(BranchRelative value) {
            return value.getBranchToItem().getItem();
        }
    };
    private static final TreeTableColumn<BranchRelative> TREE_TABLE_COLUMN = new TreeTableColumn<BranchRelative>("Branched from version", 150){

        @Override
        public String getPresentableString(BranchRelative value) {
            if (value.getBranchFromItem() != null) {
                return MessageFormat.format("{0}", value.getBranchFromItem().getCs());
            }
            return "";
        }
    };

    public ItemInfoForm(WorkspaceInfo workspace, ExtendedItem item, Collection<? extends BranchRelative> branches) {
        this.myBranches = branches;
        this.$$$setupUI$$$();
        this.myServerNameLabel.setText(item.getTitem() != null ? item.getTitem() : item.getSitem());
        this.myLocalNameLabel.setText(VersionControlPath.localPathFromTfsRepresentation(item.getLocal()));
        this.myLatestVersionLabel.setText(String.valueOf(item.getLatest()));
        this.myWorkspaceVersionLabel.setText(String.valueOf(item.getLver()));
        this.myEncodingLabel.setText(item.getEnc() != Integer.MIN_VALUE ? String.valueOf(item.getEnc()) : TFSBundle.message("encoding.not.applicable", new Object[0]));
        this.myPendingChangesLabel.setText(new ChangeTypeMask(item.getChg()).toString());
        this.myDeletionIdLabel.setText(item.getDid() != Integer.MIN_VALUE ? String.valueOf(item.getDid()) : TFSBundle.message("not.deleted", new Object[0]));
        this.myLockLabel.setText(item.getLock() != null ? TFSBundle.message("locked.for.by", item.getLock().getValue(), item.getLowner()) : TFSBundle.message("locked.none", new Object[0]));
        this.myWorkspaceLabel.setText(MessageFormat.format("{0} on server {1}", workspace.getName(), workspace.getServer().getPresentableUri()));
        if (this.myBranches.size() < 2) {
            this.myTreePane.setVisible(false);
            this.myBranchesLabel.setText("No branches");
        }
    }

    public JComponent getPanel() {
        return this.myPanel;
    }

    private void createUIComponents() {
        List<TreeTableColumn> columns = Arrays.asList(SERVER_PATH_COLUMN, TREE_TABLE_COLUMN);
        this.myBranchesTree = new CustomTreeTable<BranchRelative>(columns, new ContentProviderImpl(), new CellRendererImpl(), false, false);
        this.myBranchesTree.expandAll();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JLabel jLabel2;
        JLabel jLabel3;
        JLabel jLabel4;
        JLabel jLabel5;
        JLabel jLabel6;
        JLabel jLabel7;
        JLabel jLabel8;
        JLabel jLabel9;
        JLabel jLabel10;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(12, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myServerNameLabel = jLabel10 = new JLabel();
        jLabel10.setText("Label");
        jPanel.add((Component)jLabel10, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel11 = new JLabel();
        jLabel11.setText("Local name:");
        jPanel.add((Component)jLabel11, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLocalNameLabel = jLabel9 = new JLabel();
        jLabel9.setText("Label");
        jPanel.add((Component)jLabel9, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel12 = new JLabel();
        jLabel12.setText("Latest version:");
        jPanel.add((Component)jLabel12, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLatestVersionLabel = jLabel8 = new JLabel();
        jLabel8.setText("Label");
        jPanel.add((Component)jLabel8, new GridConstraints(3, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel13 = new JLabel();
        jLabel13.setText("Local version:");
        jPanel.add((Component)jLabel13, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myWorkspaceVersionLabel = jLabel7 = new JLabel();
        jLabel7.setText("Label");
        jPanel.add((Component)jLabel7, new GridConstraints(4, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel14 = new JLabel();
        jLabel14.setText("Codepage:");
        jPanel.add((Component)jLabel14, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myEncodingLabel = jLabel6 = new JLabel();
        jLabel6.setText("Label");
        jPanel.add((Component)jLabel6, new GridConstraints(5, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel15 = new JLabel();
        jLabel15.setText("Pending changes:");
        jPanel.add((Component)jLabel15, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPendingChangesLabel = jLabel5 = new JLabel();
        jLabel5.setText("Label");
        jPanel.add((Component)jLabel5, new GridConstraints(6, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myBranchesLabel = jLabel4 = new JLabel();
        jLabel4.setText("Branches:");
        jPanel.add((Component)jLabel4, new GridConstraints(9, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(11, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        JLabel jLabel16 = new JLabel();
        jLabel16.setText("Server name:");
        jPanel.add((Component)jLabel16, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        this.myTreePane = jBScrollPane;
        jPanel.add((Component)jBScrollPane, new GridConstraints(10, 0, 1, 2, 0, 3, 7, 7, null, null, null));
        CustomTreeTable<BranchRelative> customTreeTable = this.myBranchesTree;
        jBScrollPane.setViewportView((Component)((Object)customTreeTable));
        JLabel jLabel17 = new JLabel();
        jLabel17.setText("Deleted at:");
        jPanel.add((Component)jLabel17, new GridConstraints(7, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDeletionIdLabel = jLabel3 = new JLabel();
        jLabel3.setText("Label");
        jPanel.add((Component)jLabel3, new GridConstraints(7, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel18 = new JLabel();
        jLabel18.setText("Lock:");
        jPanel.add((Component)jLabel18, new GridConstraints(8, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLockLabel = jLabel2 = new JLabel();
        jLabel2.setText("Label");
        jPanel.add((Component)jLabel2, new GridConstraints(8, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel19 = new JLabel();
        jLabel19.setText("Workspace:");
        jPanel.add((Component)jLabel19, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myWorkspaceLabel = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        jLabel11.setLabelFor(jLabel9);
        jLabel12.setLabelFor(jLabel8);
        jLabel13.setLabelFor(jLabel7);
        jLabel14.setLabelFor(jLabel6);
        jLabel15.setLabelFor(jLabel5);
        jLabel4.setLabelFor((Component)jBScrollPane);
        jLabel16.setLabelFor(jLabel10);
        jLabel17.setLabelFor(jLabel5);
        jLabel18.setLabelFor(jLabel5);
        jLabel19.setLabelFor(jLabel5);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private static class CellRendererImpl
    extends CellRenderer<BranchRelative> {
        private CellRendererImpl() {
        }

        @Override
        public void render(CustomTreeTable<BranchRelative> treeTable, TreeTableColumn<BranchRelative> column, BranchRelative value, JLabel cell) {
            super.render(treeTable, column, value, cell);
            Font defaultFont = treeTable.getFont();
            Font boldFont = new Font(defaultFont.getName(), 1, defaultFont.getSize());
            cell.setFont(value.getReqstd() ? boldFont : defaultFont);
            if (column == SERVER_PATH_COLUMN) {
                cell.setIcon(value.getBranchToItem().getType() == ItemType.Folder ? UiConstants.ICON_FOLDER : UiConstants.ICON_FILE);
            }
        }
    }

    private class ContentProviderImpl
    implements ContentProvider<BranchRelative> {
        private ContentProviderImpl() {
        }

        @Override
        public Collection<BranchRelative> getRoots() {
            for (BranchRelative branch : ItemInfoForm.this.myBranches) {
                if (branch.getRelfromid() != 0) continue;
                return Collections.singletonList(branch);
            }
            return Collections.emptyList();
        }

        @Override
        public Collection<BranchRelative> getChildren(@NotNull BranchRelative parent) {
            if (parent == null) {
                ContentProviderImpl.$$$reportNull$$$0(0);
            }
            ArrayList<BranchRelative> children = new ArrayList<BranchRelative>();
            for (BranchRelative branch : ItemInfoForm.this.myBranches) {
                if (branch.getRelfromid() != parent.getReltoid()) continue;
                children.add(branch);
            }
            return children;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/tfsIntegration/ui/ItemInfoForm$ContentProviderImpl", "getChildren"));
        }
    }
}

