/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core.tfs.operations;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.GetOperation;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.tfsIntegration.core.TFSBundle;
import org.jetbrains.tfsIntegration.core.tfs.ItemPath;
import org.jetbrains.tfsIntegration.core.tfs.ResultWithFailures;
import org.jetbrains.tfsIntegration.core.tfs.TfsFileUtil;
import org.jetbrains.tfsIntegration.core.tfs.TfsUtil;
import org.jetbrains.tfsIntegration.core.tfs.VersionControlPath;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;
import org.jetbrains.tfsIntegration.exceptions.TfsException;

public class ScheduleForAddition {
    public static Collection<VcsException> execute(Project project, WorkspaceInfo workspace, List<ItemPath> paths) {
        try {
            ResultWithFailures<GetOperation> serverResults = workspace.getServer().getVCS().scheduleForAddition(workspace.getName(), workspace.getOwnerName(), paths, project, TFSBundle.message("scheduling.for.addition", new Object[0]));
            for (GetOperation getOp : serverResults.getResult()) {
                VirtualFile file = VersionControlPath.getVirtualFile(getOp.getTlocal());
                if (file == null || !file.isValid()) continue;
                TfsFileUtil.markFileDirty(project, file);
            }
            return TfsUtil.getVcsExceptions(serverResults.getFailures());
        }
        catch (TfsException e) {
            return Collections.singletonList(new VcsException((Throwable)e));
        }
    }
}

