/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core.tfs;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Calendar;
import java.util.List;
import org.apache.axis2.databinding.utils.ConverterUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.tfsIntegration.core.TfsBeansHolder;
import org.jetbrains.tfsIntegration.core.tfs.ServerInfo;
import org.jetbrains.tfsIntegration.core.tfs.WorkingFolderInfo;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class WorkstationCacheReader
extends DefaultHandler {
    @NotNull
    private final List<ServerInfo> myServerInfos = ContainerUtil.newArrayList();
    private ServerInfo myCurrentServerInfo;
    private WorkspaceInfo myCurrentWorkspaceInfo;

    WorkstationCacheReader() {
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        throw e;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("ServerInfo".equals(qName)) {
            try {
                URI serverUri = new URI(attributes.getValue("uri"));
                this.myCurrentServerInfo = new ServerInfo(serverUri, attributes.getValue("repositoryGuid"), new TfsBeansHolder(serverUri));
            }
            catch (URISyntaxException e) {
                throw new SAXException(e);
            }
        } else if ("WorkspaceInfo".equals(qName)) {
            String name = attributes.getValue("name");
            String owner = attributes.getValue("ownerName");
            String computer = attributes.getValue("computer");
            String comment = attributes.getValue("comment");
            Calendar timestamp = ConverterUtil.convertToDateTime((String)attributes.getValue("LastSavedCheckinTimeStamp"));
            String localWorkspace = attributes.getValue("isLocalWorkspace");
            String ownerDisplayName = attributes.getValue("ownerDisplayName");
            String securityToken = attributes.getValue("securityToken");
            int options = ConverterUtil.convertToInt((String)attributes.getValue("options"));
            this.myCurrentWorkspaceInfo = new WorkspaceInfo(this.myCurrentServerInfo, name, owner, computer, comment, timestamp, Boolean.parseBoolean(localWorkspace), ownerDisplayName, securityToken, options);
        } else if ("MappedPath".equals(qName)) {
            this.myCurrentWorkspaceInfo.addWorkingFolderInfo(new WorkingFolderInfo(VcsUtil.getFilePath((String)attributes.getValue("path"), (boolean)true)));
        } else if ("OwnerAlias".equals(qName)) {
            this.myCurrentWorkspaceInfo.addOwnerAlias(attributes.getValue("OwnerAlias"));
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("ServerInfo".equals(qName)) {
            this.myServerInfos.add(this.myCurrentServerInfo);
            this.myCurrentServerInfo = null;
        } else if ("WorkspaceInfo".equals(qName)) {
            this.myCurrentServerInfo.addWorkspaceInfo(this.myCurrentWorkspaceInfo);
            this.myCurrentWorkspaceInfo = null;
        }
    }

    @NotNull
    public List<ServerInfo> getServers() {
        List<ServerInfo> list = this.myServerInfos;
        if (list == null) {
            WorkstationCacheReader.$$$reportNull$$$0(0);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/core/tfs/WorkstationCacheReader", "getServers"));
    }
}

