/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core.tfs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.ui.GuiUtils;
import com.intellij.util.io.ReadOnlyAttributeUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.tfsIntegration.core.TFSVcs;
import org.jetbrains.tfsIntegration.exceptions.TfsException;

public class TfsFileUtil {
    public static List<FilePath> getFilePaths(@NotNull VirtualFile[] files) {
        if (files == null) {
            TfsFileUtil.$$$reportNull$$$0(0);
        }
        return TfsFileUtil.getFilePaths(Arrays.asList(files));
    }

    public static List<FilePath> getFilePaths(@NotNull Collection<? extends VirtualFile> files) {
        if (files == null) {
            TfsFileUtil.$$$reportNull$$$0(1);
        }
        ArrayList<FilePath> paths = new ArrayList<FilePath>(files.size());
        for (VirtualFile virtualFile : files) {
            paths.add(TfsFileUtil.getFilePath(virtualFile));
        }
        return paths;
    }

    public static FilePath getFilePath(@NotNull VirtualFile f) {
        if (f == null) {
            TfsFileUtil.$$$reportNull$$$0(2);
        }
        return VcsContextFactory.SERVICE.getInstance().createFilePathOn(f);
    }

    public static void setReadOnly(VirtualFile file, boolean status) throws IOException {
        TfsFileUtil.setReadOnly(Collections.singletonList(file), status);
    }

    public static void setReadOnly(Collection<? extends VirtualFile> files, boolean status) throws IOException {
        Ref exception = new Ref();
        try {
            GuiUtils.runOrInvokeAndWait(() -> ApplicationManager.getApplication().runWriteAction(() -> {
                try {
                    for (VirtualFile file : files) {
                        ReadOnlyAttributeUtil.setReadOnlyAttribute((VirtualFile)file, (boolean)status);
                    }
                }
                catch (IOException e) {
                    exception.set((Object)e);
                }
            }));
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!exception.isNull()) {
            throw (IOException)exception.get();
        }
    }

    private static void setReadOnly(String path, boolean status) throws IOException {
        Ref exception = new Ref();
        try {
            GuiUtils.runOrInvokeAndWait(() -> {
                try {
                    ReadOnlyAttributeUtil.setReadOnlyAttribute((String)path, (boolean)status);
                }
                catch (IOException e) {
                    exception.set((Object)e);
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!exception.isNull()) {
            throw (IOException)exception.get();
        }
    }

    public static void markFileDirty(Project project, @NotNull FilePath file) {
        if (file == null) {
            TfsFileUtil.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            if (file == null) {
                TfsFileUtil.$$$reportNull$$$0(8);
            }
            VcsDirtyScopeManager.getInstance((Project)project).fileDirty(file);
        });
    }

    public static void markDirtyRecursively(Project project, Collection<? extends FilePath> roots) {
        if (roots.isEmpty()) {
            return;
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            for (FilePath root : roots) {
                VcsDirtyScopeManager.getInstance((Project)project).dirDirtyRecursively(root);
            }
        });
    }

    public static void markDirty(Project project, Collection<? extends FilePath> roots, Collection<? extends FilePath> files) {
        if (roots.isEmpty() && files.isEmpty()) {
            return;
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            for (FilePath root : roots) {
                VcsDirtyScopeManager.getInstance((Project)project).dirDirtyRecursively(root);
            }
            for (FilePath file : files) {
                VcsDirtyScopeManager.getInstance((Project)project).fileDirty(file);
            }
        });
    }

    public static void markDirtyRecursively(Project project, FilePath rootDir) {
        ApplicationManager.getApplication().runReadAction(() -> VcsDirtyScopeManager.getInstance((Project)project).dirDirtyRecursively(rootDir));
    }

    public static void markFileDirty(Project project, @NotNull VirtualFile file) {
        if (file == null) {
            TfsFileUtil.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            if (file == null) {
                TfsFileUtil.$$$reportNull$$$0(7);
            }
            VcsDirtyScopeManager.getInstance((Project)project).fileDirty(file);
        });
    }

    public static void refreshAndMarkDirty(Project project, Collection<? extends VirtualFile> roots, boolean async) {
        TfsFileUtil.refreshAndMarkDirty(project, VfsUtil.toVirtualFileArray(roots), async);
    }

    public static void refreshAndInvalidate(Project project, FilePath[] roots, boolean async) {
        VirtualFile[] files = new VirtualFile[roots.length];
        for (int i = 0; i < roots.length; ++i) {
            files[i] = roots[i].getVirtualFile();
        }
        TfsFileUtil.refreshAndMarkDirty(project, files, async);
    }

    public static void refreshAndMarkDirty(Project project, VirtualFile[] roots, boolean async) {
        RefreshQueue.getInstance().refresh(async, true, () -> {
            for (VirtualFile root : roots) {
                try {
                    TFSVcs.assertTrue(root != null);
                    VcsDirtyScopeManager.getInstance((Project)project).dirDirtyRecursively(root);
                }
                catch (RuntimeException e) {
                    TFSVcs.error("Error in refresh delegate: " + e);
                }
            }
        }, roots);
    }

    public static void refreshAndFindFile(FilePath path) {
        try {
            GuiUtils.runOrInvokeAndWait(() -> ApplicationManager.getApplication().runWriteAction(() -> VirtualFileManager.getInstance().refreshAndFindFileByUrl(path.getPath())));
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setFileContent(@NotNull File destination, @NotNull ContentWriter contentWriter) throws TfsException, IOException {
        if (destination == null) {
            TfsFileUtil.$$$reportNull$$$0(5);
        }
        if (contentWriter == null) {
            TfsFileUtil.$$$reportNull$$$0(6);
        }
        TFSVcs.assertTrue(!destination.isDirectory(), destination + " expected to be a file");
        OutputStream fileStream = null;
        try {
            if (destination.exists() && !destination.canWrite()) {
                TfsFileUtil.setReadOnly(destination.getPath(), false);
            }
            fileStream = new FileOutputStream(destination);
            contentWriter.write(fileStream);
        }
        finally {
            if (fileStream != null) {
                try {
                    fileStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static boolean hasWritableChildFile(File file) {
        File[] files = file.listFiles();
        if (files != null) {
            for (File child : files) {
                if ((!child.isFile() || !child.canWrite()) && !TfsFileUtil.hasWritableChildFile(child)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isFileWritable(FilePath localPath) {
        VirtualFile file = localPath.getVirtualFile();
        return file.isWritable() && !file.isDirectory();
    }

    public static boolean localItemExists(FilePath localPath) {
        VirtualFile file = localPath.getVirtualFile();
        return file != null && file.isValid() && file.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] calculateMD5(File file) throws IOException {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        InputStream is = null;
        try {
            int read;
            is = new BufferedInputStream(new FileInputStream(file));
            byte[] buffer = new byte[8192];
            while ((read = is.read(buffer)) > 0) {
                digest.update(buffer, 0, read);
            }
            byte[] byArray = digest.digest();
            return byArray;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destination";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentWriter";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/tfsIntegration/core/tfs/TfsFileUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getFilePaths";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getFilePath";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "markFileDirty";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "setFileContent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$markFileDirty$7";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$markFileDirty$3";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface ContentWriter {
        public void write(OutputStream var1) throws TfsException;
    }
}

