/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core.tfs;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.vcsUtil.VcsUtil;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ChangeType_type0;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ExtendedItem;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ItemSpec;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ItemType;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.PendingChange;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.RecursionType;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.TFSBundle;
import org.jetbrains.tfsIntegration.core.TFSProgressUtil;
import org.jetbrains.tfsIntegration.core.TFSVcs;
import org.jetbrains.tfsIntegration.core.tfs.ChangeTypeMask;
import org.jetbrains.tfsIntegration.core.tfs.ItemPath;
import org.jetbrains.tfsIntegration.core.tfs.ServerStatus;
import org.jetbrains.tfsIntegration.core.tfs.StatusVisitor;
import org.jetbrains.tfsIntegration.core.tfs.TfsFileUtil;
import org.jetbrains.tfsIntegration.core.tfs.VersionControlPath;
import org.jetbrains.tfsIntegration.core.tfs.VersionControlServer;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;
import org.jetbrains.tfsIntegration.exceptions.TfsException;

public class StatusProvider {
    public static void visitByStatus(@NotNull WorkspaceInfo workspace, List<? extends ItemPath> roots, boolean recursive, @Nullable ProgressIndicator progress, @NotNull StatusVisitor statusVisitor, Object projectOrComponent) throws TfsException {
        if (workspace == null) {
            StatusProvider.$$$reportNull$$$0(0);
        }
        if (statusVisitor == null) {
            StatusProvider.$$$reportNull$$$0(1);
        }
        if (roots.isEmpty()) {
            return;
        }
        ArrayList<ItemSpec> itemSpecs = new ArrayList<ItemSpec>(roots.size());
        for (ItemPath itemPath : roots) {
            VirtualFile file = itemPath.getLocalPath().getVirtualFile();
            RecursionType recursionType = recursive && (file == null || !file.exists() || file.isDirectory()) ? RecursionType.Full : RecursionType.None;
            itemSpecs.add(VersionControlServer.createItemSpec(itemPath.getLocalPath(), recursionType));
        }
        VersionControlServer.ExtendedItemsAndPendingChanges extendedItemsAndPendingChanges = workspace.getServer().getVCS().getExtendedItemsAndPendingChanges(workspace.getName(), workspace.getOwnerName(), itemSpecs, ItemType.Any, projectOrComponent, TFSBundle.message("loading.changes", new Object[0]));
        HashMap<Integer, PendingChange> hashMap = new HashMap<Integer, PendingChange>(extendedItemsAndPendingChanges.pendingChanges.size());
        for (PendingChange pendingChange : extendedItemsAndPendingChanges.pendingChanges) {
            hashMap.put(pendingChange.getItemid(), pendingChange);
        }
        HashMap<Integer, ExtendedItem> extendedItems = new HashMap<Integer, ExtendedItem>();
        for (ExtendedItem extendedItem : extendedItemsAndPendingChanges.extendedItems) {
            extendedItems.put(extendedItem.getItemid(), extendedItem);
        }
        TFSProgressUtil.checkCanceled(progress);
        for (ItemPath itemPath : roots) {
            HashSet<FilePath> localItems = new HashSet<FilePath>();
            localItems.add(itemPath.getLocalPath());
            if (recursive) {
                StatusProvider.addExistingFilesRecursively(localItems, itemPath.getLocalPath().getVirtualFile());
            }
            for (FilePath localItem : localItems) {
                boolean localItemExists;
                ExtendedItem extendedItem = null;
                PendingChange pendingChange = null;
                for (PendingChange candidate : hashMap.values()) {
                    if (!StatusProvider.equals(localItem, VersionControlPath.localPathFromTfsRepresentation(candidate.getLocal()))) continue;
                    extendedItem = (ExtendedItem)extendedItems.remove(candidate.getItemid());
                    pendingChange = candidate;
                    break;
                }
                if (extendedItem == null) {
                    for (PendingChange candidate : extendedItems.values()) {
                        if (!StatusProvider.equals(localItem, VersionControlPath.localPathFromTfsRepresentation(candidate.getLocal()))) continue;
                        extendedItem = (ExtendedItem)extendedItems.remove(candidate.getItemid());
                        break;
                    }
                }
                if (!(localItemExists = TfsFileUtil.localItemExists(localItem)) && extendedItem != null) {
                    localItem = VcsUtil.getFilePath((String)localItem.getPath(), (extendedItem.getType() == ItemType.Folder ? 1 : 0) != 0);
                }
                StatusProvider.determineServerStatus(pendingChange, extendedItem).visitBy(localItem, localItemExists, statusVisitor);
            }
            TFSProgressUtil.checkCanceled(progress);
        }
        if (recursive) {
            for (ExtendedItem extendedItem : extendedItems.values()) {
                PendingChange pendingChange = (PendingChange)hashMap.get(extendedItem.getItemid());
                if (pendingChange == null && extendedItem.getLocal() == null) continue;
                FilePath localPath = VersionControlPath.getFilePath(pendingChange != null ? pendingChange.getLocal() : extendedItem.getLocal(), extendedItem.getType() == ItemType.Folder);
                StatusProvider.determineServerStatus(pendingChange, extendedItem).visitBy(localPath, false, statusVisitor);
            }
        }
    }

    private static void addExistingFilesRecursively(final @NotNull Collection<? super FilePath> result, @Nullable VirtualFile root) {
        if (result == null) {
            StatusProvider.$$$reportNull$$$0(2);
        }
        if (root != null && root.exists()) {
            VfsUtilCore.visitChildrenRecursively((VirtualFile)root, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

                public boolean visitFile(@NotNull VirtualFile file) {
                    if (file == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    result.add(TfsFileUtil.getFilePath(file));
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/tfsIntegration/core/tfs/StatusProvider$1", "visitFile"));
                }
            });
        }
    }

    private static ServerStatus determineServerStatus(@Nullable PendingChange pendingChange, @Nullable ExtendedItem item) {
        if (item == null) {
            return ServerStatus.Unversioned.INSTANCE;
        }
        ChangeTypeMask change = new ChangeTypeMask(item.getChg());
        change.remove(ChangeType_type0.None, ChangeType_type0.Lock);
        if (item.getLocal() == null && change.isEmpty()) {
            return ServerStatus.Unversioned.INSTANCE;
        }
        if (change.isEmpty()) {
            TFSVcs.assertTrue(item.getLver() != Integer.MIN_VALUE);
            if (item.getLver() < item.getLatest()) {
                return new ServerStatus.OutOfDate(item);
            }
            return new ServerStatus.UpToDate(item);
        }
        if (change.containsAny(ChangeType_type0.Add) || change.containsAny(ChangeType_type0.Merge, ChangeType_type0.Branch) && item.getLatest() == Integer.MIN_VALUE) {
            TFSVcs.assertTrue(change.containsAny(ChangeType_type0.Encoding));
            TFSVcs.assertTrue(item.getLatest() == Integer.MIN_VALUE);
            TFSVcs.assertTrue(item.getLver() == Integer.MIN_VALUE);
            if (pendingChange != null) {
                return new ServerStatus.ScheduledForAddition(pendingChange);
            }
            return new ServerStatus.ScheduledForAddition(item);
        }
        if (change.contains(ChangeType_type0.Delete)) {
            if (pendingChange != null) {
                return new ServerStatus.ScheduledForDeletion(pendingChange);
            }
            return new ServerStatus.ScheduledForDeletion(item);
        }
        if (change.containsAny(ChangeType_type0.Edit, ChangeType_type0.Merge) && !change.contains(ChangeType_type0.Rename)) {
            TFSVcs.assertTrue(item.getLatest() != Integer.MIN_VALUE);
            if (item.getLver() != Integer.MIN_VALUE) {
                TFSVcs.assertTrue(item.getLocal() != null);
                if (pendingChange != null) {
                    return new ServerStatus.CheckedOutForEdit(pendingChange);
                }
                return new ServerStatus.CheckedOutForEdit(item);
            }
            return new ServerStatus.ScheduledForAddition(item);
        }
        if (change.containsAny(ChangeType_type0.Merge, ChangeType_type0.Rename) && !change.contains(ChangeType_type0.Edit)) {
            if (pendingChange != null) {
                return new ServerStatus.Renamed(pendingChange);
            }
            return new ServerStatus.Renamed(item);
        }
        if (change.containsAll(ChangeType_type0.Rename, ChangeType_type0.Edit)) {
            TFSVcs.assertTrue(item.getLatest() != Integer.MIN_VALUE);
            TFSVcs.assertTrue(item.getLver() != Integer.MIN_VALUE);
            TFSVcs.assertTrue(item.getLocal() != null);
            if (pendingChange != null) {
                return new ServerStatus.RenamedCheckedOut(pendingChange);
            }
            return new ServerStatus.RenamedCheckedOut(item);
        }
        if (change.contains(ChangeType_type0.Undelete)) {
            if (pendingChange != null) {
                return new ServerStatus.Undeleted(pendingChange);
            }
            return new ServerStatus.Undeleted(item);
        }
        TFSVcs.LOG.error("Uncovered case for item " + (item.getLocal() != null ? VersionControlPath.localPathFromTfsRepresentation(item.getLocal()) : item.getTitem()));
        return null;
    }

    private static boolean equals(FilePath path1, String path2) {
        if (path2 == null) {
            return path1 == null;
        }
        return path1.getIOFile().equals(new File(path2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workspace";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusVisitor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/tfsIntegration/core/tfs/StatusProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitByStatus";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addExistingFilesRecursively";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

