/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core.configuration;

import com.intellij.openapi.util.PasswordUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.TFSBundle;
import org.jetbrains.tfsIntegration.core.tfs.TfsUtil;

@Tag(value="credentials")
public class Credentials {
    @NotNull
    private String myUserName;
    @NotNull
    private String myDomain;
    @Nullable
    private String myPassword;
    private boolean myStorePassword;
    private Type myType;

    public static Credentials createNative() {
        return new Credentials("", "", "", true, Type.NtlmNative);
    }

    public Credentials() {
        this("", "", null, false, Type.NtlmExplicit);
    }

    public Credentials(@NotNull String userName, @NotNull String domain, @Nullable String password, boolean storePassword, Type type) {
        if (userName == null) {
            Credentials.$$$reportNull$$$0(0);
        }
        if (domain == null) {
            Credentials.$$$reportNull$$$0(1);
        }
        this.myUserName = userName;
        this.myDomain = domain;
        this.myPassword = password;
        this.myStorePassword = storePassword;
        this.myType = type;
    }

    public Credentials(@NotNull String credentials, @Nullable String password, boolean storePassword, Type type) {
        if (credentials == null) {
            Credentials.$$$reportNull$$$0(2);
        }
        int i = credentials.indexOf(92);
        this.myDomain = i != -1 ? credentials.substring(0, i) : "";
        this.myUserName = i != -1 ? credentials.substring(i + 1) : credentials;
        this.myPassword = password;
        this.myStorePassword = storePassword;
        this.myType = type;
    }

    @Nullable
    public String getPassword() {
        return this.myPassword;
    }

    public void resetPassword() {
        this.myPassword = null;
        this.myStorePassword = false;
    }

    @Tag(value="password")
    @Nullable
    public String getEncodedPassword() {
        return this.myStorePassword && this.myPassword != null ? PasswordUtil.encodePassword((String)this.myPassword) : null;
    }

    public void setEncodedPassword(String encodedPassword) {
        this.myPassword = encodedPassword != null ? PasswordUtil.decodePassword((String)encodedPassword) : null;
        this.myStorePassword = true;
    }

    public boolean isStorePassword() {
        return this.myStorePassword;
    }

    @Tag(value="domain")
    @NotNull
    public String getDomain() {
        String string = this.myDomain;
        if (string == null) {
            Credentials.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void setDomain(@NotNull String domain) {
        if (domain == null) {
            Credentials.$$$reportNull$$$0(4);
        }
        this.myDomain = domain;
    }

    @Tag(value="username")
    @NotNull
    public String getUserName() {
        String string = this.myUserName;
        if (string == null) {
            Credentials.$$$reportNull$$$0(5);
        }
        return string;
    }

    public void setUserName(@NotNull String userName) {
        if (userName == null) {
            Credentials.$$$reportNull$$$0(6);
        }
        this.myUserName = userName;
    }

    public Type getType() {
        return this.myType;
    }

    @Attribute(value="nativeAuth")
    public String getUseNativeSerialized() {
        return null;
    }

    public void setUseNativeSerialized(String useNative) {
        if (UseNative.Yes.name().equals(useNative)) {
            this.myType = Type.NtlmNative;
            this.myPassword = "";
        } else if (UseNative.Reset.name().equals(useNative)) {
            this.myType = Type.NtlmNative;
            this.myPassword = null;
        } else {
            this.myType = Type.NtlmExplicit;
        }
    }

    @Attribute(value="type")
    public String getTypeSerialized() {
        return this.myType.name();
    }

    public void setTypeSerialized(String s) {
        try {
            this.myType = Type.valueOf(s);
        }
        catch (IllegalArgumentException e) {
            this.myType = Type.NtlmExplicit;
        }
    }

    @NotNull
    public String getQualifiedUsername() {
        if (this.getDomain().length() > 0) {
            String string = TfsUtil.getQualifiedUsername(this.getDomain(), this.getUserName());
            if (string == null) {
                Credentials.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = this.getUserName();
        if (string == null) {
            Credentials.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NonNls
    public String toString() {
        return this.myType.name() + ": " + this.getQualifiedUsername() + "," + (this.getPassword() != null ? this.getPassword().replaceAll(".", "x") : "(no password)");
    }

    public boolean shouldShowLoginDialog() {
        return this.myPassword == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userName";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domain";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentials";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/tfsIntegration/core/configuration/Credentials";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/tfsIntegration/core/configuration/Credentials";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDomain";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserName";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedUsername";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setDomain";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setUserName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Type {
        NtlmExplicit,
        NtlmNative,
        Alternate;


        public String getPresentableText() {
            return TFSBundle.message("credentials.type." + this.name(), new Object[0]);
        }
    }

    private static enum UseNative {
        Yes,
        No,
        Reset;

    }
}

