/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.checkin.CheckinChangeListSpecificComponent;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.MultiLineTooltipUI;
import com.intellij.ui.components.labels.BoldLabel;
import com.intellij.util.FunctionUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.PairConsumer;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcsUtil.VcsUtil;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ChangeType_type0;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.CheckinResult;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.CheckinWorkItemAction;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.Failure;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ItemType;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.PendingChange;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.RecursionType;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import javax.swing.plaf.ComponentUI;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.checkin.CheckinParameters;
import org.jetbrains.tfsIntegration.core.TFSBundle;
import org.jetbrains.tfsIntegration.core.TFSProgressUtil;
import org.jetbrains.tfsIntegration.core.TFSVcs;
import org.jetbrains.tfsIntegration.core.tfs.ChangeTypeMask;
import org.jetbrains.tfsIntegration.core.tfs.ItemPath;
import org.jetbrains.tfsIntegration.core.tfs.ResultWithFailures;
import org.jetbrains.tfsIntegration.core.tfs.TfsFileUtil;
import org.jetbrains.tfsIntegration.core.tfs.TfsUtil;
import org.jetbrains.tfsIntegration.core.tfs.VersionControlPath;
import org.jetbrains.tfsIntegration.core.tfs.WorkItemsCheckinParameters;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;
import org.jetbrains.tfsIntegration.core.tfs.WorkstationHelper;
import org.jetbrains.tfsIntegration.core.tfs.operations.ScheduleForAddition;
import org.jetbrains.tfsIntegration.core.tfs.operations.ScheduleForDeletion;
import org.jetbrains.tfsIntegration.core.tfs.workitems.WorkItem;
import org.jetbrains.tfsIntegration.exceptions.OperationFailedException;
import org.jetbrains.tfsIntegration.exceptions.TfsException;
import org.jetbrains.tfsIntegration.ui.CheckinParametersDialog;

public class TFSCheckinEnvironment
implements CheckinEnvironment {
    @NotNull
    private final TFSVcs myVcs;

    public TFSCheckinEnvironment(@NotNull TFSVcs vcs) {
        if (vcs == null) {
            TFSCheckinEnvironment.$$$reportNull$$$0(0);
        }
        this.myVcs = vcs;
    }

    @Nullable
    public RefreshableOnComponent createAdditionalOptionsPanel(final @NotNull CheckinProjectPanel checkinProjectPanel, PairConsumer<Object, Object> additionalDataConsumer) {
        if (checkinProjectPanel == null) {
            TFSCheckinEnvironment.$$$reportNull$$$0(1);
        }
        boolean isAffected = false;
        for (File file : checkinProjectPanel.getFiles()) {
            if (!TFSVcs.isUnderTFS(VcsUtil.getFilePath((File)file), checkinProjectPanel.getProject())) continue;
            isAffected = true;
            break;
        }
        if (!isAffected) {
            return null;
        }
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout(5, 0));
        this.myVcs.getCheckinData().messageLabel = new BoldLabel(){

            public JToolTip createToolTip() {
                JToolTip toolTip = new JToolTip(){
                    {
                        this.setUI((ComponentUI)new MultiLineTooltipUI());
                    }
                };
                toolTip.setComponent((JComponent)((Object)this));
                return toolTip;
            }
        };
        panel.add((Component)this.myVcs.getCheckinData().messageLabel, "West");
        JButton configureButton = new JButton("Configure...");
        panel.add((Component)configureButton, "East");
        configureButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                CheckinParameters copy = ((TFSCheckinEnvironment)TFSCheckinEnvironment.this).myVcs.getCheckinData().parameters.createCopy();
                CheckinParametersDialog d = new CheckinParametersDialog(checkinProjectPanel.getProject(), copy);
                if (d.showAndGet()) {
                    ((TFSCheckinEnvironment)TFSCheckinEnvironment.this).myVcs.getCheckinData().parameters = copy;
                    TFSCheckinEnvironment.updateMessage(TFSCheckinEnvironment.this.myVcs.getCheckinData());
                }
            }
        });
        return new TFSAdditionalOptionsPanel(panel, checkinProjectPanel, configureButton);
    }

    public static void updateMessage(TFSVcs.CheckinData checkinData) {
        if (checkinData.parameters == null) {
            return;
        }
        Pair<String, CheckinParameters.Severity> message = checkinData.parameters.getValidationMessage(CheckinParameters.Severity.BOTH);
        if (message == null) {
            checkinData.messageLabel.setText("<html>Ready to commit</html>");
            checkinData.messageLabel.setIcon(null);
            checkinData.messageLabel.setToolTipText(null);
        } else {
            checkinData.messageLabel.setToolTipText((String)message.first);
            if (message.second == CheckinParameters.Severity.ERROR) {
                checkinData.messageLabel.setText("Errors found");
                checkinData.messageLabel.setIcon(UIUtil.getBalloonErrorIcon());
            } else {
                checkinData.messageLabel.setText("Warnings found");
                checkinData.messageLabel.setIcon(UIUtil.getBalloonWarningIcon());
            }
        }
    }

    @Nullable
    public String getDefaultMessageFor(FilePath[] filesToCheckin) {
        return null;
    }

    @Nullable
    @NonNls
    public String getHelpId() {
        return null;
    }

    public String getCheckinOperationName() {
        return "Checkin";
    }

    @Nullable
    public List<VcsException> commit(List<Change> changes, final String preparedComment, @NotNull NullableFunction<Object, Object> parametersHolder, Set<String> feedback) {
        if (parametersHolder == null) {
            TFSCheckinEnvironment.$$$reportNull$$$0(2);
        }
        this.myVcs.getCheckinData().messageLabel = null;
        final ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        ArrayList<FilePath> files = new ArrayList<FilePath>();
        for (Change change : changes) {
            FilePath path = null;
            ContentRevision beforeRevision = change.getBeforeRevision();
            ContentRevision afterRevision = change.getAfterRevision();
            if (afterRevision != null) {
                path = afterRevision.getFile();
            } else if (beforeRevision != null) {
                path = beforeRevision.getFile();
            }
            if (path == null) continue;
            files.add(path);
        }
        final ArrayList<VcsException> errors = new ArrayList<VcsException>();
        try {
            WorkstationHelper.processByWorkspaces(files, false, this.myVcs.getProject(), new WorkstationHelper.VoidProcessDelegate(){

                @Override
                public void executeRequest(WorkspaceInfo workspace, List<ItemPath> paths) throws TfsException {
                    try {
                        TFSProgressUtil.setProgressText(progressIndicator, TFSBundle.message("loading.pending.changes", new Object[0]));
                        Collection<PendingChange> pendingChanges = workspace.getServer().getVCS().queryPendingSetsByLocalPaths(workspace.getName(), workspace.getOwnerName(), paths, RecursionType.None, TFSCheckinEnvironment.this.myVcs.getProject(), TFSBundle.message("loading.pending.changes", new Object[0]));
                        if (pendingChanges.isEmpty()) {
                            return;
                        }
                        ArrayList<String> checkIn = new ArrayList<String>();
                        TFSProgressUtil.setProgressText(progressIndicator, TFSBundle.message("uploading.files", new Object[0]));
                        for (PendingChange pendingChange : pendingChanges) {
                            ChangeTypeMask changeType;
                            if (pendingChange.getType() == ItemType.File && ((changeType = new ChangeTypeMask(pendingChange.getChg())).contains(ChangeType_type0.Edit) || changeType.contains(ChangeType_type0.Add))) {
                                TFSProgressUtil.setProgressText2(progressIndicator, VersionControlPath.localPathFromTfsRepresentation(pendingChange.getLocal()));
                                workspace.getServer().getVCS().uploadItem(workspace, pendingChange, TFSCheckinEnvironment.this.myVcs.getProject(), null);
                            }
                            checkIn.add(pendingChange.getItem());
                        }
                        TFSProgressUtil.setProgressText2(progressIndicator, "");
                        WorkItemsCheckinParameters state = ((TFSCheckinEnvironment)TFSCheckinEnvironment.this).myVcs.getCheckinData().parameters.getWorkItems(workspace.getServer());
                        Map<WorkItem, CheckinWorkItemAction> workItemActions = state != null ? state.getWorkItemsActions() : Collections.emptyMap();
                        ArrayList<Pair<String, String>> checkinNotes = new ArrayList<Pair<String, String>>(((TFSCheckinEnvironment)TFSCheckinEnvironment.this).myVcs.getCheckinData().parameters.getCheckinNotes(workspace.getServer()).size());
                        for (CheckinParameters.CheckinNote checkinNote : ((TFSCheckinEnvironment)TFSCheckinEnvironment.this).myVcs.getCheckinData().parameters.getCheckinNotes(workspace.getServer())) {
                            checkinNotes.add(Pair.create((Object)checkinNote.name, (Object)StringUtil.notNullize((String)checkinNote.value)));
                        }
                        TFSProgressUtil.setProgressText(progressIndicator, TFSBundle.message("checking.in", new Object[0]));
                        ResultWithFailures<CheckinResult> result = workspace.getServer().getVCS().checkIn(workspace.getName(), workspace.getOwnerName(), checkIn, preparedComment, workItemActions, checkinNotes, ((TFSCheckinEnvironment)TFSCheckinEnvironment.this).myVcs.getCheckinData().parameters.getPolicyOverride(workspace.getServer()), TFSCheckinEnvironment.this.myVcs.getProject(), null);
                        errors.addAll(TfsUtil.getVcsExceptions(result.getFailures()));
                        ArrayList<String> commitFailed = new ArrayList<String>(result.getFailures().size());
                        for (Failure failure : result.getFailures()) {
                            TFSVcs.assertTrue(failure.getItem() != null);
                            commitFailed.add(failure.getItem());
                        }
                        ArrayList<FilePath> invalidateRoots = new ArrayList<FilePath>(pendingChanges.size());
                        ArrayList<FilePath> invalidateFiles = new ArrayList<FilePath>();
                        ArrayList<VirtualFile> makeReadOnly = new ArrayList<VirtualFile>();
                        for (PendingChange pendingChange : pendingChanges) {
                            VirtualFile vcsRoot;
                            VirtualFile file;
                            TFSVcs.assertTrue(pendingChange.getItem() != null);
                            if (commitFailed.contains(pendingChange.getItem())) continue;
                            ChangeTypeMask changeType = new ChangeTypeMask(pendingChange.getChg());
                            if (pendingChange.getType() == ItemType.File && (changeType.contains(ChangeType_type0.Edit) || changeType.contains(ChangeType_type0.Add) || changeType.contains(ChangeType_type0.Rename)) && (file = VersionControlPath.getVirtualFile(pendingChange.getLocal())) != null && file.isValid()) {
                                makeReadOnly.add(file);
                            }
                            FilePath path = VersionControlPath.getFilePath(pendingChange.getLocal(), pendingChange.getType() == ItemType.Folder);
                            invalidateRoots.add(path);
                            if (!changeType.contains(ChangeType_type0.Add) && !changeType.contains(ChangeType_type0.Rename) || (vcsRoot = ProjectLevelVcsManager.getInstance((Project)TFSCheckinEnvironment.this.myVcs.getProject()).getVcsRootFor(path)) == null) continue;
                            FilePath vcsRootPath = TfsFileUtil.getFilePath(vcsRoot);
                            for (FilePath parent = path.getParentPath(); parent != null && parent.isUnder(vcsRootPath, false); parent = parent.getParentPath()) {
                                invalidateFiles.add(parent);
                            }
                        }
                        TfsFileUtil.setReadOnly(makeReadOnly, true);
                        TFSProgressUtil.setProgressText(progressIndicator, TFSBundle.message("updating.work.items", new Object[0]));
                        if (commitFailed.isEmpty()) {
                            CheckinResult checkinResult = result.getResult().iterator().next();
                            workspace.getServer().getVCS().updateWorkItemsAfterCheckin(workspace.getOwnerName(), workItemActions, checkinResult.getCset(), TFSCheckinEnvironment.this.myVcs.getProject(), null);
                        }
                        TfsFileUtil.markDirty(TFSCheckinEnvironment.this.myVcs.getProject(), invalidateRoots, invalidateFiles);
                    }
                    catch (IOException e) {
                        errors.add(new VcsException((Throwable)e));
                    }
                }
            });
        }
        catch (TfsException e) {
            errors.add(new VcsException((Throwable)e));
        }
        this.myVcs.getCheckinData().parameters = null;
        this.myVcs.fireRevisionChanged();
        return errors;
    }

    public List<VcsException> commit(List<Change> changes, String preparedComment) {
        return this.commit(changes, preparedComment, (NullableFunction<Object, Object>)FunctionUtil.nullConstant(), null);
    }

    @Nullable
    public List<VcsException> scheduleMissingFileForDeletion(List<FilePath> files) {
        final ArrayList<VcsException> errors = new ArrayList<VcsException>();
        try {
            WorkstationHelper.processByWorkspaces(files, false, this.myVcs.getProject(), new WorkstationHelper.VoidProcessDelegate(){

                @Override
                public void executeRequest(WorkspaceInfo workspace, List<ItemPath> paths) {
                    Collection<VcsException> schedulingErrors = ScheduleForDeletion.execute(TFSCheckinEnvironment.this.myVcs.getProject(), workspace, paths);
                    errors.addAll(schedulingErrors);
                }
            });
        }
        catch (TfsException e) {
            errors.add(new VcsException((Throwable)e));
        }
        return errors;
    }

    @Nullable
    public List<VcsException> scheduleUnversionedFilesForAddition(List<VirtualFile> files) {
        final ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        try {
            List<FilePath> orphans = WorkstationHelper.processByWorkspaces(TfsFileUtil.getFilePaths(files), false, this.myVcs.getProject(), new WorkstationHelper.VoidProcessDelegate(){

                @Override
                public void executeRequest(WorkspaceInfo workspace, List<ItemPath> paths) {
                    Collection<VcsException> schedulingErrors = ScheduleForAddition.execute(TFSCheckinEnvironment.this.myVcs.getProject(), workspace, paths);
                    exceptions.addAll(schedulingErrors);
                }
            });
            if (!orphans.isEmpty()) {
                StringBuilder s = new StringBuilder();
                for (FilePath orpan : orphans) {
                    if (s.length() > 0) {
                        s.append("\n");
                    }
                    s.append(orpan.getPresentableUrl());
                }
                exceptions.add(new VcsException("Team Foundation Server mapping not found for: " + s.toString()));
            }
        }
        catch (TfsException e) {
            exceptions.add(new VcsException((Throwable)e));
        }
        return exceptions;
    }

    public boolean isRefreshAfterCommitNeeded() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkinProjectPanel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parametersHolder";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/tfsIntegration/core/TFSCheckinEnvironment";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createAdditionalOptionsPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "commit";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class TFSAdditionalOptionsPanel
    implements CheckinChangeListSpecificComponent {
        private final JComponent myPanel;
        private final CheckinProjectPanel myCheckinProjectPanel;
        private final JButton myConfigureButton;
        private LocalChangeList myCurrentList;

        TFSAdditionalOptionsPanel(JComponent panel, CheckinProjectPanel checkinProjectPanel, JButton configureButton) {
            this.myPanel = panel;
            this.myCheckinProjectPanel = checkinProjectPanel;
            this.myConfigureButton = configureButton;
        }

        public JComponent getComponent() {
            return this.myPanel;
        }

        public void refresh() {
        }

        public void saveState() {
        }

        public void restoreState() {
        }

        public void onChangeListSelected(LocalChangeList list) {
            if (this.myCurrentList == list) {
                return;
            }
            this.myCurrentList = list;
            if (!this.myCheckinProjectPanel.hasDiffs()) {
                this.myPanel.setVisible(false);
                return;
            }
            this.myPanel.setVisible(true);
            try {
                ((TFSCheckinEnvironment)TFSCheckinEnvironment.this).myVcs.getCheckinData().parameters = new CheckinParameters(this.myCheckinProjectPanel, true);
                this.myConfigureButton.setEnabled(true);
                TFSCheckinEnvironment.updateMessage(TFSCheckinEnvironment.this.myVcs.getCheckinData());
            }
            catch (OperationFailedException e) {
                ((TFSCheckinEnvironment)TFSCheckinEnvironment.this).myVcs.getCheckinData().parameters = null;
                this.myConfigureButton.setEnabled(false);
                ((TFSCheckinEnvironment)TFSCheckinEnvironment.this).myVcs.getCheckinData().messageLabel.setIcon(UIUtil.getBalloonErrorIcon());
                ((TFSCheckinEnvironment)TFSCheckinEnvironment.this).myVcs.getCheckinData().messageLabel.setText("Validation failed");
                ((TFSCheckinEnvironment)TFSCheckinEnvironment.this).myVcs.getCheckinData().messageLabel.setToolTipText(e.getMessage());
            }
        }
    }
}

