/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils.library.propertiesEditor;

import com.google.common.base.Strings;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.idea.maven.aether.ArtifactKind;

public class RepositoryLibraryPropertiesModel {
    private String b;
    private final EnumSet<ArtifactKind> d = EnumSet.of(ArtifactKind.ARTIFACT);
    private boolean a;
    private List<String> c;

    public RepositoryLibraryPropertiesModel(String version, boolean downloadSources, boolean downloadJavaDocs) {
        this(version, downloadSources, downloadJavaDocs, true, ContainerUtil.emptyList());
    }

    public RepositoryLibraryPropertiesModel(String version, boolean downloadSources, boolean downloadJavaDocs, boolean includeTransitiveDependencies, List<String> excludedDependencies) {
        this(version, ArtifactKind.kindsOf((boolean)downloadSources, (boolean)downloadJavaDocs), includeTransitiveDependencies, excludedDependencies);
    }

    public RepositoryLibraryPropertiesModel(String version, EnumSet<ArtifactKind> artifactKinds, boolean includeTransitiveDependencies, List<String> excludedDependencies) {
        this.b = version;
        this.d.addAll(artifactKinds);
        this.a = includeTransitiveDependencies;
        this.c = new ArrayList<String>(excludedDependencies);
    }

    public RepositoryLibraryPropertiesModel clone() {
        return new RepositoryLibraryPropertiesModel(this.b, this.d, this.a, new ArrayList<String>(this.c));
    }

    public boolean isValid() {
        return !Strings.isNullOrEmpty((String)this.b);
    }

    public boolean isIncludeTransitiveDependencies() {
        return this.a;
    }

    public void setIncludeTransitiveDependencies(boolean includeTransitiveDependencies) {
        this.a = includeTransitiveDependencies;
    }

    public List<String> getExcludedDependencies() {
        return this.c;
    }

    public void setExcludedDependencies(Collection<String> excludedDependencies) {
        this.c = new ArrayList<String>(excludedDependencies);
    }

    public boolean isDownloadSources() {
        return this.d.contains(ArtifactKind.SOURCES);
    }

    public void setDownloadSources(boolean downloadSources) {
        if (downloadSources) {
            this.d.add(ArtifactKind.SOURCES);
        } else {
            this.d.remove(ArtifactKind.SOURCES);
        }
    }

    public boolean isDownloadJavaDocs() {
        return this.d.contains(ArtifactKind.JAVADOC);
    }

    public void setDownloadJavaDocs(boolean downloadJavaDocs) {
        if (downloadJavaDocs) {
            this.d.add(ArtifactKind.JAVADOC);
        } else {
            this.d.remove(ArtifactKind.JAVADOC);
        }
    }

    public boolean isDownloadAnnotations() {
        return this.d.contains(ArtifactKind.ANNOTATIONS);
    }

    public void setDownloadAnnotations(boolean downloadAnnotations) {
        if (downloadAnnotations) {
            this.d.add(ArtifactKind.ANNOTATIONS);
        } else {
            this.d.remove(ArtifactKind.ANNOTATIONS);
        }
    }

    public EnumSet<ArtifactKind> getArtifactKinds() {
        return EnumSet.copyOf(this.d);
    }

    public String getVersion() {
        return this.b;
    }

    public void setVersion(String version) {
        this.b = version;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        RepositoryLibraryPropertiesModel repositoryLibraryPropertiesModel = (RepositoryLibraryPropertiesModel)o2;
        if (!this.d.equals(repositoryLibraryPropertiesModel.d)) {
            return false;
        }
        if (this.a != repositoryLibraryPropertiesModel.a) {
            return false;
        }
        if (this.b != null ? !this.b.equals(repositoryLibraryPropertiesModel.b) : repositoryLibraryPropertiesModel.b != null) {
            return false;
        }
        return this.c.equals(repositoryLibraryPropertiesModel.c);
    }

    public int hashCode() {
        int n2 = this.d.hashCode();
        n2 = 31 * n2 + (this.a ? 1 : 0);
        n2 = 31 * n2 + (this.b != null ? this.b.hashCode() : 0);
        n2 = 31 * n2 + this.c.hashCode();
        return n2;
    }
}

