/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.internal.DumpLookupElementWeights;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.fixtures.impl.CodeInsightTestFixtureImpl;
import com.intellij.ui.breadcrumbs.BreadcrumbsProvider;
import com.intellij.ui.breadcrumbs.BreadcrumbsUtil;
import com.intellij.ui.components.breadcrumbs.Crumb;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public class EditorTestFixture {
    private final Project myProject;
    private final Editor myEditor;
    private final VirtualFile myFile;
    private boolean myEmptyLookup;

    public EditorTestFixture(Project project2, Editor editor, VirtualFile file) {
        this.myProject = project2;
        this.myEditor = editor;
        this.myFile = file;
    }

    public void type(char c10) {
        ApplicationManager.getApplication().invokeAndWait(() -> {
            EditorActionManager actionManager = EditorActionManager.getInstance();
            if (c10 == '\b') {
                this.performEditorAction("EditorBackSpace");
                return;
            }
            if (c10 == '\n') {
                if (this.performEditorAction("EditorChooseLookupItem")) {
                    return;
                }
                if (this.performEditorAction("NextTemplateVariable")) {
                    return;
                }
                this.performEditorAction("EditorEnter");
                return;
            }
            if (c10 == '\t') {
                if (this.performEditorAction("EditorChooseLookupItemReplace")) {
                    return;
                }
                if (this.performEditorAction("ExpandLiveTemplateByTab")) {
                    return;
                }
                if (this.performEditorAction("NextTemplateVariable")) {
                    return;
                }
                if (this.performEditorAction("EditorTab")) {
                    return;
                }
            }
            if (c10 == '\r' && this.performEditorAction("EditorChooseLookupItemCompleteStatement")) {
                return;
            }
            ActionManagerEx.getInstanceEx().fireBeforeEditorTyping(c10, this.getEditorDataContext());
            actionManager.getTypedAction().actionPerformed(this.myEditor, c10, this.getEditorDataContext());
        });
    }

    public void type(@NotNull String s2) {
        if (s2 == null) {
            EditorTestFixture.$$$reportNull$$$0(0);
        }
        for (int i10 = 0; i10 < s2.length(); ++i10) {
            this.type(s2.charAt(i10));
        }
    }

    public boolean performEditorAction(@NotNull String actionId) {
        if (actionId == null) {
            EditorTestFixture.$$$reportNull$$$0(1);
        }
        DataContext dataContext = this.getEditorDataContext();
        ActionManagerEx managerEx = ActionManagerEx.getInstanceEx();
        AnAction action = managerEx.getAction(actionId);
        AnActionEvent event = new AnActionEvent(null, dataContext, "unknown", new Presentation(), (ActionManager)managerEx, 0);
        action.beforeActionPerformedUpdate(event);
        if (!event.getPresentation().isEnabled()) {
            return false;
        }
        ActionUtil.performActionDumbAwareWithCallbacks((AnAction)action, (AnActionEvent)event, (DataContext)dataContext);
        return true;
    }

    @NotNull
    private DataContext getEditorDataContext() {
        DataContext dataContext = ((EditorEx)this.myEditor).getDataContext();
        if (dataContext == null) {
            EditorTestFixture.$$$reportNull$$$0(2);
        }
        return dataContext;
    }

    public PsiFile getFile() {
        return this.myFile != null ? (PsiFile)ReadAction.compute(() -> PsiManager.getInstance((Project)this.myProject).findFile(this.myFile)) : null;
    }

    public List<HighlightInfo> doHighlighting() {
        return this.doHighlighting(false);
    }

    public List<HighlightInfo> doHighlighting(boolean myAllowDirt) {
        EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments()));
        PsiFile file = this.getFile();
        Editor editor = this.myEditor;
        if (editor instanceof EditorWindow) {
            editor = ((EditorWindow)editor).getDelegate();
            file = InjectedLanguageManager.getInstance((Project)file.getProject()).getTopLevelFile((PsiElement)file);
        }
        Assert.assertNotNull((Object)file);
        return CodeInsightTestFixtureImpl.instantiateAndRun(file, editor, ArrayUtil.EMPTY_INT_ARRAY, myAllowDirt);
    }

    @Nullable
    protected Editor getCompletionEditor() {
        return InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit((Editor)this.myEditor, (PsiFile)this.getFile());
    }

    public LookupImpl getLookup() {
        return (LookupImpl)LookupManager.getActiveLookup((Editor)this.myEditor);
    }

    public LookupElement[] complete(@NotNull CompletionType type) {
        if (type == null) {
            EditorTestFixture.$$$reportNull$$$0(3);
        }
        return this.complete(type, 1);
    }

    public LookupElement[] completeBasic() {
        return this.complete(CompletionType.BASIC);
    }

    public LookupElement[] complete(@NotNull CompletionType type, int invocationCount) {
        if (type == null) {
            EditorTestFixture.$$$reportNull$$$0(4);
        }
        this.myEmptyLookup = false;
        ApplicationManager.getApplication().invokeAndWait(() -> {
            if (type == null) {
                EditorTestFixture.$$$reportNull$$$0(9);
            }
            CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
                if (type == null) {
                    EditorTestFixture.$$$reportNull$$$0(10);
                }
                CodeCompletionHandlerBase handler = new CodeCompletionHandlerBase(type){

                    protected void completionFinished(CompletionProgressIndicator indicator, boolean hasModifiers) {
                        EditorTestFixture.this.myEmptyLookup = indicator.getLookup().getItems().isEmpty();
                        super.completionFinished(indicator, hasModifiers);
                    }
                };
                Editor editor = this.getCompletionEditor();
                Assert.assertNotNull((Object)editor);
                handler.invokeCompletion(this.myProject, editor, invocationCount);
                PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
            }, null, null, this.myEditor.getDocument());
        });
        return this.getLookupElements();
    }

    @Nullable
    public LookupElement[] getLookupElements() {
        LookupImpl lookup = this.getLookup();
        if (lookup == null) {
            return this.myEmptyLookup ? LookupElement.EMPTY_ARRAY : null;
        }
        List list2 = lookup.getItems();
        return list2.toArray(LookupElement.EMPTY_ARRAY);
    }

    public List<String> getLookupElementStrings() {
        Object[] elements = this.getLookupElements();
        if (elements == null) {
            return null;
        }
        return ContainerUtil.map((Object[])elements, LookupElement::getLookupString);
    }

    @NotNull
    public final List<LookupElement> completeBasicAllCarets(@Nullable Character charToTypeAfterCompletion) {
        CaretModel caretModel = this.myEditor.getCaretModel();
        List carets = caretModel.getAllCarets();
        ArrayList<Integer> originalOffsets = new ArrayList<Integer>(carets.size());
        for (Caret caret : carets) {
            originalOffsets.add(caret.getOffset());
        }
        caretModel.removeSecondaryCarets();
        Collections.reverse(originalOffsets);
        ArrayList<LookupElement> result = new ArrayList<LookupElement>();
        Iterator iterator = originalOffsets.iterator();
        while (iterator.hasNext()) {
            int originalOffset = (Integer)iterator.next();
            caretModel.moveToOffset(originalOffset);
            LookupElement[] lookupElements = this.completeBasic();
            if (charToTypeAfterCompletion != null) {
                this.type(charToTypeAfterCompletion.charValue());
            }
            if (lookupElements == null) continue;
            result.addAll(Arrays.asList(lookupElements));
        }
        ArrayList<LookupElement> arrayList = result;
        if (arrayList == null) {
            EditorTestFixture.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    public void assertPreferredCompletionItems(int selected, String ... expected) {
        if (expected == null) {
            EditorTestFixture.$$$reportNull$$$0(6);
        }
        LookupImpl lookup = this.getLookup();
        Assert.assertNotNull((String)"No lookup is shown", (Object)lookup);
        JList list2 = lookup.getList();
        List<String> strings = this.getLookupElementStrings();
        Assert.assertNotNull(strings);
        List<String> actual = strings.subList(0, Math.min(expected.length, strings.size()));
        if (!actual.equals(Arrays.asList(expected))) {
            UsefulTestCase.assertOrderedEquals(DumpLookupElementWeights.getLookupElementWeights((LookupImpl)lookup, (boolean)false), expected);
        }
        if (selected != list2.getSelectedIndex()) {
            System.out.println(DumpLookupElementWeights.getLookupElementWeights((LookupImpl)lookup, (boolean)false));
        }
        Assert.assertEquals((long)selected, (long)list2.getSelectedIndex());
    }

    public void finishLookup(char completionChar) {
        Runnable command = () -> {
            LookupImpl lookup = (LookupImpl)LookupManager.getActiveLookup((Editor)this.myEditor);
            Assert.assertNotNull((Object)lookup);
            lookup.finishLookup(completionChar);
        };
        CommandProcessor.getInstance().executeCommand(this.myProject, command, null, null, this.myEditor.getDocument());
    }

    public PsiElement getElementAtCaret() {
        int findTargetFlags;
        Editor editor = this.getCompletionEditor();
        PsiElement element = TargetElementUtil.findTargetElement((Editor)editor, (int)(findTargetFlags = 3));
        if (element == null && editor instanceof EditorWindow) {
            element = TargetElementUtil.findTargetElement((Editor)((EditorWindow)editor).getDelegate(), (int)findTargetFlags);
        }
        if (element == null) {
            Assert.fail((String)("element not found in file " + this.myFile.getName() + " at caret position offset " + this.myEditor.getCaretModel().getOffset() + ", psi structure:\n" + DebugUtil.psiToString((PsiElement)this.getFile(), (boolean)true, (boolean)true)));
        }
        return element;
    }

    public <T extends PsiElement> T findElementByText(@NotNull String text2, @NotNull Class<T> elementClass) {
        if (text2 == null) {
            EditorTestFixture.$$$reportNull$$$0(7);
        }
        if (elementClass == null) {
            EditorTestFixture.$$$reportNull$$$0(8);
        }
        Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(this.getFile());
        Assert.assertNotNull((Object)document);
        int pos = document.getText().indexOf(text2);
        Assert.assertTrue((String)text2, (pos >= 0 ? 1 : 0) != 0);
        return (T)PsiTreeUtil.getParentOfType((PsiElement)this.getFile().findElementAt(pos), elementClass);
    }

    public List<IntentionAction> getAllQuickFixes() {
        List<HighlightInfo> infos = this.doHighlighting();
        ArrayList<IntentionAction> actions = new ArrayList<IntentionAction>();
        for (HighlightInfo info : infos) {
            if (info.quickFixActionRanges == null) continue;
            for (Pair pair2 : info.quickFixActionRanges) {
                actions.add(((HighlightInfo.IntentionActionDescriptor)pair2.getFirst()).getAction());
            }
        }
        return actions;
    }

    public List<Crumb> getBreadcrumbsAtCaret() {
        PsiElement element = this.getFile().findElementAt(this.myEditor.getCaretModel().getOffset());
        if (element == null) {
            return Collections.emptyList();
        }
        Language language = element.getContainingFile().getLanguage();
        BreadcrumbsProvider provider = BreadcrumbsUtil.getInfoProvider((Language)language);
        if (provider == null) {
            return Collections.emptyList();
        }
        ArrayList<Crumb.Impl> result = new ArrayList<Crumb.Impl>();
        while (element != null) {
            if (provider.acceptElement(element)) {
                result.add(new Crumb.Impl(provider, element));
            }
            element = provider.getParent(element);
        }
        return ContainerUtil.reverse(result);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 5: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/fixtures/EditorTestFixture";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expected";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementClass";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/fixtures/EditorTestFixture";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorDataContext";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "completeBasicAllCarets";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "type";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "performEditorAction";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "complete";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "assertPreferredCompletionItems";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findElementByText";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$complete$4";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

