/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.concurrency.IdeaForkJoinWorkerThreadFactory;
import com.intellij.concurrency.JobSchedulerImpl;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.testFramework.CpuUsageData;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.TeamCityLogger;
import com.intellij.testFramework.Timings;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ThrowableRunnable;
import junit.framework.AssertionFailedError;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class PerformanceTestInfo {
    private final ThrowableRunnable<?> test;
    private final int expectedMs;
    private ThrowableRunnable<?> setup;
    private int usedReferenceCpuCores;
    private int attempts;
    private final String what;
    private boolean adjustForIO;
    private boolean adjustForCPU;
    private boolean useLegacyScaling;

    PerformanceTestInfo(@NotNull ThrowableRunnable test, int expectedMs, @NotNull String what) {
        if (test == null) {
            PerformanceTestInfo.$$$reportNull$$$0(0);
        }
        if (what == null) {
            PerformanceTestInfo.$$$reportNull$$$0(1);
        }
        this.usedReferenceCpuCores = 1;
        this.attempts = 4;
        this.adjustForIO = false;
        this.adjustForCPU = true;
        this.test = test;
        this.expectedMs = expectedMs;
        assert (expectedMs > 0) : "Expected must be > 0. Was: " + expectedMs;
        this.what = what;
    }

    @Contract(pure=true)
    public PerformanceTestInfo setup(@NotNull ThrowableRunnable setup) {
        if (setup == null) {
            PerformanceTestInfo.$$$reportNull$$$0(2);
        }
        assert (this.setup == null);
        this.setup = setup;
        return this;
    }

    @Contract(pure=true)
    public PerformanceTestInfo usesAllCPUCores() {
        return this.usesMultipleCPUCores(8);
    }

    @Contract(pure=true)
    public PerformanceTestInfo usesMultipleCPUCores(int maxCores) {
        assert (this.adjustForCPU) : "This test configured to be io-bound, it cannot use all cores";
        this.usedReferenceCpuCores = maxCores;
        return this;
    }

    @Contract(pure=true)
    public PerformanceTestInfo ioBound() {
        this.adjustForIO = true;
        this.adjustForCPU = false;
        return this;
    }

    @Contract(pure=true)
    public PerformanceTestInfo attempts(int attempts) {
        this.attempts = attempts;
        return this;
    }

    @Deprecated
    @Contract(pure=true)
    public PerformanceTestInfo useLegacyScaling() {
        this.useLegacyScaling = true;
        return this;
    }

    public void assertTiming() {
        if (PlatformTestUtil.COVERAGE_ENABLED_BUILD) {
            return;
        }
        Timings.getStatistics();
        if (this.attempts == 1) {
            System.gc();
        }
        boolean testShouldPass = false;
        while (true) {
            CpuUsageData data;
            --this.attempts;
            try {
                if (this.setup != null) {
                    this.setup.run();
                }
                PlatformTestUtil.waitForAllBackgroundActivityToCalmDown();
                data = CpuUsageData.measureCpuUsage(this.test);
            }
            catch (Throwable throwable) {
                ExceptionUtil.rethrowUnchecked((Throwable)throwable);
                throw new RuntimeException(throwable);
            }
            int expectedOnMyMachine = this.getExpectedTimeOnThisMachine();
            IterationResult iterationResult = data.durationMs < (long)expectedOnMyMachine ? IterationResult.acceptable : ((double)data.durationMs < (double)expectedOnMyMachine * 1.1 ? IterationResult.borderline : IterationResult.slow);
            testShouldPass |= iterationResult != IterationResult.slow;
            String logMessage = this.formatMessage(data, expectedOnMyMachine, iterationResult);
            if (iterationResult == IterationResult.acceptable) {
                TeamCityLogger.info((String)logMessage);
                System.out.println("\nSUCCESS: " + logMessage);
            } else {
                TeamCityLogger.warning((String)logMessage, null);
                System.out.println("\nWARNING: " + logMessage);
            }
            if (this.attempts == 0 || iterationResult == IterationResult.acceptable) {
                if (testShouldPass) {
                    return;
                }
                throw new AssertionFailedError(logMessage);
            }
            String s2 = "  " + this.attempts + " attempts remain";
            TeamCityLogger.warning((String)s2, null);
            System.out.println(s2);
            System.gc();
        }
    }

    private String formatMessage(CpuUsageData data, int expectedOnMyMachine, IterationResult iterationResult) {
        long duration = data.durationMs;
        int percentage = (int)(100.0 * (double)(duration - (long)expectedOnMyMachine) / (double)expectedOnMyMachine);
        String colorCode = iterationResult == IterationResult.acceptable ? "32;1m" : (iterationResult == IterationResult.borderline ? "33;1m" : "31;1m");
        return String.format("%s took \u001b[%s%d%% %s time\u001b[0m than expected\n  Expected: %sms (%s)\n  Actual:   %sms (%s)\n  Timings:  %s\n  Threads:  %s\n  GC stats: %s", this.what, colorCode, Math.abs(percentage), percentage > 0 ? "more" : "less", expectedOnMyMachine, StringUtil.formatDuration((long)expectedOnMyMachine), duration, StringUtil.formatDuration((long)duration), Timings.getStatistics(), data.getThreadStats(), data.getGcStats());
    }

    private int getExpectedTimeOnThisMachine() {
        int expectedOnMyMachine = this.expectedMs;
        if (this.adjustForCPU) {
            int coreCountUsedHere = this.usedReferenceCpuCores < 8 ? Math.min(JobSchedulerImpl.getJobPoolParallelism(), this.usedReferenceCpuCores) : JobSchedulerImpl.getJobPoolParallelism();
            expectedOnMyMachine *= this.usedReferenceCpuCores;
            expectedOnMyMachine = PerformanceTestInfo.adjust(expectedOnMyMachine, Timings.CPU_TIMING, 200L, this.useLegacyScaling);
            expectedOnMyMachine /= coreCountUsedHere;
        }
        if (this.adjustForIO) {
            expectedOnMyMachine = PerformanceTestInfo.adjust(expectedOnMyMachine, Timings.IO_TIMING, 100L, this.useLegacyScaling);
        }
        return expectedOnMyMachine;
    }

    private static int adjust(int expectedOnMyMachine, long thisTiming, long referenceTiming, boolean useLegacyScaling) {
        if (useLegacyScaling) {
            double speed = 1.0 * (double)thisTiming / (double)referenceTiming;
            double delta = speed < 1.0 ? 0.9 + Math.pow(speed - 0.7, 2.0) : 0.45 + Math.pow(speed - 0.25, 2.0);
            expectedOnMyMachine = (int)((double)expectedOnMyMachine * delta);
            return expectedOnMyMachine;
        }
        return (int)((long)expectedOnMyMachine * thisTiming / referenceTiming);
    }

    static {
        IdeaForkJoinWorkerThreadFactory.setupForkJoinCommonPool((boolean)true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "test";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "what";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setup";
                break;
            }
        }
        objectArray2[1] = "com/intellij/testFramework/PerformanceTestInfo";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setup";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static enum IterationResult {
        acceptable,
        borderline,
        slow;

    }
}

