/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.lang.TokenWrapper;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.testFramework.UsefulTestCase;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LexerTestCase
extends UsefulTestCase {
    protected void doTest(@NonNls String text2) {
        this.doTest(text2, null);
    }

    protected void doTest(@NonNls String text2, @Nullable String expected) {
        this.doTest(text2, expected, this.createLexer());
    }

    protected void doTest(@NonNls String text2, @Nullable String expected, @NotNull Lexer lexer) {
        if (lexer == null) {
            LexerTestCase.$$$reportNull$$$0(0);
        }
        String result = LexerTestCase.printTokens(text2, 0, lexer);
        if (expected != null) {
            LexerTestCase.assertSameLines(expected, result);
        } else {
            LexerTestCase.assertSameLinesWithFile(this.getPathToTestDataFile(this.getExpectedFileExtension()), result);
        }
    }

    @NotNull
    protected String getPathToTestDataFile(String extension) {
        String string = PathManager.getHomePath() + "/" + this.getDirPath() + "/" + this.getTestName(true) + extension;
        if (string == null) {
            LexerTestCase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    protected String getExpectedFileExtension() {
        if (".txt" == null) {
            LexerTestCase.$$$reportNull$$$0(2);
        }
        return ".txt";
    }

    protected void checkZeroState(String text2, TokenSet tokenTypes) {
        IElementType type;
        Lexer lexer = this.createLexer();
        lexer.start((CharSequence)text2);
        while ((type = lexer.getTokenType()) != null) {
            if (tokenTypes.contains(type) && lexer.getState() != 0) {
                LexerTestCase.fail((String)("Non-zero lexer state on token \"" + lexer.getTokenText() + "\" (" + type + ") at " + lexer.getTokenStart()));
            }
            lexer.advance();
        }
    }

    protected void checkCorrectRestart(String text2) {
        IElementType type;
        Lexer mainLexer = this.createLexer();
        String allTokens = LexerTestCase.printTokens(text2, 0, mainLexer);
        Lexer auxLexer = this.createLexer();
        auxLexer.start((CharSequence)text2);
        while ((type = auxLexer.getTokenType()) != null) {
            int tokenStart;
            String subTokens;
            if (auxLexer.getState() == 0 && !allTokens.endsWith(subTokens = LexerTestCase.printTokens(text2, tokenStart = auxLexer.getTokenStart(), mainLexer))) {
                LexerTestCase.assertEquals((String)("Restarting impossible from offset " + tokenStart + "; lexer state should not return 0 at this point"), (String)allTokens, (String)subTokens);
            }
            auxLexer.advance();
        }
    }

    protected String printTokens(String text2, int start) {
        return LexerTestCase.printTokens(text2, start, this.createLexer());
    }

    public static String printTokens(CharSequence text2, int start, Lexer lexer) {
        IElementType tokenType;
        lexer.start(text2, start, text2.length());
        StringBuilder result = new StringBuilder();
        while ((tokenType = lexer.getTokenType()) != null) {
            result.append(LexerTestCase.printSingleToken(text2, tokenType, lexer.getTokenStart(), lexer.getTokenEnd()));
            lexer.advance();
        }
        return result.toString();
    }

    @NotNull
    public static String printTokens(@NotNull HighlighterIterator iterator) {
        if (iterator == null) {
            LexerTestCase.$$$reportNull$$$0(3);
        }
        CharSequence text2 = iterator.getDocument().getCharsSequence();
        StringBuilder result = new StringBuilder();
        while (!iterator.atEnd()) {
            IElementType tokenType = iterator.getTokenType();
            result.append(LexerTestCase.printSingleToken(text2, tokenType, iterator.getStart(), iterator.getEnd()));
            iterator.advance();
        }
        String string = result.toString();
        if (string == null) {
            LexerTestCase.$$$reportNull$$$0(4);
        }
        return string;
    }

    public static String printSingleToken(CharSequence fileText, IElementType tokenType, int start, int end) {
        return tokenType + " ('" + LexerTestCase.getTokenText(tokenType, fileText, start, end) + "')\n";
    }

    protected void doFileTest(@NonNls String fileExt) {
        this.doTest(this.loadTestDataFile("." + fileExt));
    }

    @NotNull
    protected String loadTestDataFile(@NonNls String fileExt) {
        String fileName = this.getPathToTestDataFile(fileExt);
        String text2 = "";
        try {
            String fileText = FileUtil.loadFile((File)new File(fileName));
            text2 = StringUtil.convertLineSeparators((String)(this.shouldTrim() ? fileText.trim() : fileText));
        }
        catch (IOException e10) {
            LexerTestCase.fail((String)("can't load file " + fileName + ": " + e10.getMessage()));
        }
        String string = text2;
        if (string == null) {
            LexerTestCase.$$$reportNull$$$0(5);
        }
        return string;
    }

    protected boolean shouldTrim() {
        return true;
    }

    @NotNull
    private static String getTokenText(IElementType tokenType, CharSequence sequence, int start, int end) {
        if (tokenType instanceof TokenWrapper) {
            String string = ((TokenWrapper)tokenType).getValue();
            if (string == null) {
                LexerTestCase.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = StringUtil.replace((String)sequence.subSequence(start, end).toString(), (String)"\n", (String)"\\n");
        if (string == null) {
            LexerTestCase.$$$reportNull$$$0(7);
        }
        return string;
    }

    protected abstract Lexer createLexer();

    protected abstract String getDirPath();

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lexer";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/LexerTestCase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/LexerTestCase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathToTestDataFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedFileExtension";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "printTokens";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "loadTestDataFile";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenText";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doTest";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "printTokens";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

