/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.impl.event.EditorEventMulticasterImpl;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.util.containers.hash.LinkedHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import org.junit.Assert;

public class EditorListenerTracker {
    private final Map<Class<? extends EventListener>, List<? extends EventListener>> before;
    private final boolean myDefaultProjectInitialized;

    public EditorListenerTracker() {
        EncodingManager.getInstance();
        this.before = ((EditorEventMulticasterImpl)EditorFactory.getInstance().getEventMulticaster()).getListeners();
        this.myDefaultProjectInitialized = ProjectManagerEx.getInstanceEx().isDefaultProjectInitialized();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkListenersLeak() throws AssertionError {
        try {
            Class aClass;
            if (this.myDefaultProjectInitialized != ProjectManagerEx.getInstanceEx().isDefaultProjectInitialized()) {
                return;
            }
            EditorEventMulticasterImpl multicaster = (EditorEventMulticasterImpl)EditorFactory.getInstance().getEventMulticaster();
            Map after2 = multicaster.getListeners();
            LinkedHashMap leaked = new LinkedHashMap();
            for (Map.Entry entry : after2.entrySet()) {
                aClass = (Class)entry.getKey();
                List<? extends EventListener> beforeList = this.before.get(aClass);
                ArrayList afterList = new ArrayList((Collection)entry.getValue());
                if (beforeList != null) {
                    afterList.removeAll(beforeList);
                }
                if (afterList.isEmpty()) continue;
                leaked.put(aClass, afterList);
            }
            for (Map.Entry entry : leaked.entrySet()) {
                aClass = (Class)entry.getKey();
                List list2 = (List)entry.getValue();
                Assert.fail((String)("Listeners leaked for " + aClass + ":\n" + list2));
            }
        }
        finally {
            this.before.clear();
        }
    }
}

