/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import java.lang.management.ManagementFactory;
import java.math.BigInteger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanServer;
import javax.management.ObjectName;

class CpuTimings {
    CpuTimings() {
    }

    static long calcStableCpuTiming() {
        long start = System.currentTimeMillis();
        long minTime = Integer.MAX_VALUE;
        long minIteration = -1L;
        StringBuilder log = new StringBuilder();
        int i10 = 0;
        while (true) {
            long time;
            if ((time = CpuTimings.calcCpuTiming(CpuTimings::addBigIntegers)) < minTime) {
                minTime = time;
                minIteration = i10;
            } else if ((long)i10 - minIteration > 100L) {
                System.out.println(log + "CPU timing: " + minTime + ", calculated in " + (System.currentTimeMillis() - start) + "ms");
                return minTime;
            }
            ++i10;
        }
    }

    private static long calcCpuTiming(Runnable oneIteration) {
        long start = System.currentTimeMillis();
        oneIteration.run();
        return System.currentTimeMillis() - start;
    }

    private static void addBigIntegers() {
        BigInteger k10 = new BigInteger("1");
        for (int i10 = 0; i10 < 1000000; ++i10) {
            k10 = k10.add(new BigInteger("1"));
        }
    }

    private static void mulDiv() {
        long k10 = 241L;
        for (int i10 = 0; i10 < 22222222; ++i10) {
            k10 = i10 % 10 == 3 ? k10 * 239L : k10 % 12342L;
        }
        CpuTimings.ensureOdd(k10);
    }

    private static void ensureOdd(long k10) {
        if (k10 % 2L == 0L) {
            throw new AssertionError((Object)"Should be an odd value");
        }
    }

    private static void mulDivMemAccess() {
        int[] array = new int[240000];
        for (int i10 = 0; i10 < array.length; ++i10) {
            array[i10] = i10 * 42 + 1;
        }
        int k10 = 241;
        for (int i11 = 0; i11 < 5750000; ++i11) {
            k10 *= array[Math.abs(k10) % array.length];
        }
        CpuTimings.ensureOdd(k10);
    }

    public static double getProcessCpuLoad() {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName name2 = ObjectName.getInstance("java.lang:type=OperatingSystem");
            AttributeList list2 = mbs.getAttributes(name2, new String[]{"ProcessCpuLoad"});
            if (list2.isEmpty()) {
                return Double.NaN;
            }
            Attribute att = (Attribute)list2.get(0);
            Double value = (Double)att.getValue();
            if (value == -1.0) {
                return Double.NaN;
            }
            return (double)((int)(value * 1000.0)) / 10.0;
        }
        catch (Exception e10) {
            throw new RuntimeException(e10);
        }
    }

    public static double getSystemCpuLoad() {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName name2 = ObjectName.getInstance("java.lang:type=OperatingSystem");
            AttributeList list2 = mbs.getAttributes(name2, new String[]{"SystemCpuLoad"});
            if (list2.isEmpty()) {
                return Double.NaN;
            }
            Attribute att = (Attribute)list2.get(0);
            Double value = (Double)att.getValue();
            if (value == -1.0) {
                return Double.NaN;
            }
            return (double)((int)(value * 1000.0)) / 10.0;
        }
        catch (Exception e10) {
            throw new RuntimeException(e10);
        }
    }

    public static void main(String[] args) {
        for (int i10 = 0; i10 < 20; ++i10) {
        }
    }
}

