/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter;

import b.a.lb;
import com.intellij.application.options.CodeStyle;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.PathManagerEx;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.LocalTimeCounter;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class FormatterTestCase
extends LightPlatformTestCase {
    protected boolean doReformatRangeTest;
    protected TextRange myTextRange;
    protected EditorImpl myEditor;
    protected PsiFile myFile;
    private static final long a = lb.a(-6033227123786346487L, 374789457153429429L, MethodHandles.lookup().lookupClass()).a(76480792269607L);

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        FormatterTestCase.assertFalse((boolean)CodeStyle.usesOwnSettings((Project)FormatterTestCase.getProject()));
    }

    protected void doTest(String resultNumber) throws Exception {
        this.a(this.getTestName(true), resultNumber);
    }

    protected void doTest() throws Exception {
        this.doTest(null);
    }

    private void a(String string, String string2) throws Exception {
        long l2 = a ^ 0x53AFB76E6399L;
        this.doTest(string + "." + this.getFileExtension(), string + "_after." + this.getFileExtension(), string2);
    }

    protected void doTest(String fileNameBefore, String fileNameAfter, String resultNumber) throws Exception {
        this.doTextTest(this.loadFile(fileNameBefore, null), this.loadFile(fileNameAfter, resultNumber));
    }

    protected final void doTest(@NonNls String fileNameBefore, @NonNls String fileNameAfter) throws Exception {
        this.doTextTest(this.loadFile(fileNameBefore + "." + this.getFileExtension(), null), this.loadFile(fileNameAfter + "." + this.getFileExtension(), null));
    }

    protected void doTextTest(@NonNls String text2, @NonNls String textAfter) throws IncorrectOperationException {
        this.doTextTest(text2, textAfter, CheckPolicy.BOTH);
    }

    protected void doTextTest(String text2, String textAfter, @NotNull CheckPolicy checkPolicy) throws IncorrectOperationException {
        long l2 = a ^ 0x9B8FCFB8E76L;
        if (checkPolicy == null) {
            FormatterTestCase.a(0);
        }
        String string = "before." + this.getFileExtension();
        PsiFile psiFile = this.createFileFromText(text2, string, PsiFileFactory.getInstance((Project)FormatterTestCase.getProject()));
        if (checkPolicy.isCheckDocument()) {
            this.checkDocument(psiFile, text2, textAfter);
        }
        if (checkPolicy.isCheckPsi()) {
            // empty if block
        }
    }

    protected PsiFile createFileFromText(String text2, String fileName, PsiFileFactory fileFactory) {
        return fileFactory.createFileFromText(fileName, this.getFileType(fileName), (CharSequence)text2, LocalTimeCounter.currentTime(), true, false);
    }

    protected FileType getFileType(String fileName) {
        return FileTypeManager.getInstance().getFileTypeByFileName(fileName);
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            if (this.myFile != null) {
                ((UndoManagerImpl)UndoManager.getInstance((Project)FormatterTestCase.getProject())).clearUndoRedoQueueInTests(this.myFile.getVirtualFile());
                FileEditorManager.getInstance((Project)FormatterTestCase.getProject()).closeFile(this.myFile.getVirtualFile());
            }
        }
        finally {
            this.myEditor = null;
            this.myFile = null;
            super.tearDown();
        }
    }

    private void b(PsiFile psiFile, String string) {
        long l2 = a ^ 0x4DD48D631C13L;
        CommandProcessor.getInstance().executeCommand(FormatterTestCase.getProject(), () -> ApplicationManager.getApplication().runWriteAction(() -> {
            Document document = PsiDocumentManager.getInstance((Project)FormatterTestCase.getProject()).getDocument(psiFile);
            document.replaceString(0, document.getTextLength(), (CharSequence)string);
            PsiDocumentManager.getInstance((Project)FormatterTestCase.getProject()).commitDocument(document);
        }), "test", null);
    }

    protected boolean doCheckDocumentUpdate() {
        return false;
    }

    protected void checkDocument(PsiFile file, String text2, String textAfter) {
        Document document = PsiDocumentManager.getInstance((Project)FormatterTestCase.getProject()).getDocument(file);
        if (this.doCheckDocumentUpdate()) {
            EditorImpl editorImpl = (EditorImpl)FileEditorManager.getInstance((Project)FormatterTestCase.getProject()).openTextEditor(new OpenFileDescriptor(FormatterTestCase.getProject(), file.getVirtualFile(), 0), false);
            editorImpl.putUserData(EditorImpl.DO_DOCUMENT_UPDATE_TEST, (Object)Boolean.TRUE);
            if (this.myFile != null) {
                FileEditorManager.getInstance((Project)FormatterTestCase.getProject()).closeFile(this.myFile.getVirtualFile());
            }
            this.myEditor = editorImpl;
            this.myFile = file;
        } else {
            Object var5_6 = null;
        }
        WriteCommandAction.runWriteCommandAction((Project)FormatterTestCase.getProject(), () -> {
            document.replaceString(0, document.getTextLength(), (CharSequence)text2);
            PsiDocumentManager.getInstance((Project)FormatterTestCase.getProject()).commitDocument(document);
            FormatterTestCase.assertEquals((String)file.getText(), (String)document.getText());
            try {
                if (this.doReformatRangeTest) {
                    CodeStyleManager.getInstance((Project)FormatterTestCase.getProject()).reformatRange((PsiElement)file, file.getTextRange().getStartOffset(), file.getTextRange().getEndOffset());
                } else if (this.myTextRange != null) {
                    CodeStyleManager.getInstance((Project)FormatterTestCase.getProject()).reformatText(file, this.myTextRange.getStartOffset(), this.myTextRange.getEndOffset());
                } else {
                    CodeStyleManager.getInstance((Project)FormatterTestCase.getProject()).reformatText(file, file.getTextRange().getStartOffset(), file.getTextRange().getEndOffset());
                }
            }
            catch (IncorrectOperationException incorrectOperationException) {
                FormatterTestCase.fail();
            }
        });
        FormatterTestCase.assertEquals((String)textAfter, (String)document.getText());
        PsiDocumentManager.getInstance((Project)FormatterTestCase.getProject()).commitDocument(document);
        FormatterTestCase.assertEquals((String)textAfter, (String)file.getText());
    }

    private void d(PsiFile psiFile, String string) {
        CommandProcessor.getInstance().executeCommand(FormatterTestCase.getProject(), () -> ApplicationManager.getApplication().runWriteAction(() -> this.performFormatting(psiFile)), "", (Object)"");
        String string2 = psiFile.getText();
        FormatterTestCase.assertEquals((String)string, (String)string2);
    }

    protected void performFormatting(PsiFile file) {
        try {
            if (this.myTextRange == null) {
                CodeStyleManager.getInstance((Project)FormatterTestCase.getProject()).reformat((PsiElement)file);
            } else {
                CodeStyleManager.getInstance((Project)FormatterTestCase.getProject()).reformatRange((PsiElement)file, this.myTextRange.getStartOffset(), this.myTextRange.getEndOffset());
            }
        }
        catch (IncorrectOperationException incorrectOperationException) {
            FormatterTestCase.fail();
        }
    }

    protected void performFormattingWithDocument(PsiFile file) {
        try {
            if (this.myTextRange == null) {
                CodeStyleManager.getInstance((Project)FormatterTestCase.getProject()).reformatText(file, 0, file.getTextLength());
            } else {
                CodeStyleManager.getInstance((Project)FormatterTestCase.getProject()).reformatText(file, this.myTextRange.getStartOffset(), this.myTextRange.getEndOffset());
            }
        }
        catch (IncorrectOperationException incorrectOperationException) {
            FormatterTestCase.fail();
        }
    }

    protected String loadFile(String name2, String resultNumber) throws Exception {
        long l2 = a ^ 0x4A14CD585350L;
        String string = this.getTestDataPath() + File.separatorChar + this.getBasePath() + File.separatorChar + name2;
        String string2 = FileUtil.loadFile((File)new File(string));
        string2 = StringUtil.convertLineSeparators((String)string2);
        if (resultNumber == null) {
            return this.prepareText(string2);
        }
        String string3 = "<<<" + resultNumber + ">>>";
        String string4 = "<<</" + resultNumber + ">>>";
        int n2 = string2.indexOf(string3);
        FormatterTestCase.assertTrue((n2 >= 0 ? 1 : 0) != 0);
        int n3 = string2.indexOf(string4);
        FormatterTestCase.assertTrue((n3 >= 0 ? 1 : 0) != 0);
        return this.prepareText(string2.substring(n2 + string3.length(), n3).trim());
    }

    protected String getTestDataPath() {
        return PathManagerEx.getTestDataPath();
    }

    protected String prepareText(String text2) {
        return text2;
    }

    protected abstract String getBasePath();

    protected abstract String getFileExtension();

    protected static CommonCodeStyleSettings getSettings(Language language) {
        return CodeStyle.getSettings((Project)FormatterTestCase.getProject()).getCommonSettings(language);
    }

    protected CodeStyleSettings getSettings() {
        return CodeStyle.getSettings((Project)FormatterTestCase.getProject());
    }

    protected void doSanityTestForDirectory(File directory, boolean formatWithPsi) throws IOException, IncorrectOperationException {
        long l2 = a ^ 0x254A4D951E80L;
        ArrayList<File> arrayList = new ArrayList<File>();
        this.a(directory, arrayList, formatWithPsi);
        if (!arrayList.isEmpty()) {
            FormatterTestCase.fail((String)("Failed for files: " + this.a(arrayList)));
        }
    }

    private void a(File file, List<File> list2, boolean bl2) throws IOException, IncorrectOperationException {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                this.b(file2, list2, bl2);
                this.a(file2, list2, bl2);
            }
        }
    }

    protected void doSanityTest(boolean formatWithPsi) throws IOException, IncorrectOperationException {
        long l2 = a ^ 0x51BD3BF92CE5L;
        File file = new File(this.getTestDataPath() + File.separatorChar + this.getBasePath(), "sanity");
        File[] fileArray = file.listFiles();
        ArrayList<File> arrayList = new ArrayList<File>();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                this.b(file2, arrayList, formatWithPsi);
            }
            if (!arrayList.isEmpty()) {
                FormatterTestCase.fail((String)("Failed for files: " + this.a(arrayList)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void b(File file, List<File> list2, boolean bl2) throws IOException, IncorrectOperationException {
        long l2 = a ^ 0x6352A22E65AAL;
        if (file.isFile() && file.getName().endsWith(this.getFileExtension())) {
            byte[] byArray = FileUtil.loadFileBytes((File)file);
            String string = new String(byArray);
            String string2 = "before." + this.getFileExtension();
            PsiFile psiFile = PsiFileFactory.getInstance((Project)FormatterTestCase.getProject()).createFileFromText(string2, this.getFileType(string2), (CharSequence)StringUtil.convertLineSeparators((String)string), LocalTimeCounter.currentTime(), true);
            try {
                CommandProcessor.getInstance().executeCommand(FormatterTestCase.getProject(), () -> ApplicationManager.getApplication().runWriteAction(() -> {
                    long l2 = a ^ 0x3AD0AACA1C04L;
                    try {
                        if (bl2) {
                            this.performFormatting(psiFile);
                        } else {
                            this.performFormattingWithDocument(psiFile);
                        }
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        list2.add(file);
                    }
                    System.out.println(file.getPath() + ": finished");
                }), "", null);
            }
            finally {
                VirtualFile virtualFile = psiFile.getVirtualFile();
                if (virtualFile != null) {
                    ((UndoManagerImpl)UndoManager.getInstance((Project)FormatterTestCase.getProject())).clearUndoRedoQueueInTests(virtualFile);
                    ((UndoManagerImpl)UndoManager.getGlobalInstance()).clearUndoRedoQueueInTests(virtualFile);
                }
            }
        }
    }

    private String a(List<File> list2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (File file : list2) {
            stringBuilder.append(file.getPath());
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    private static /* synthetic */ void a(int n2) {
        long l2 = a ^ 0x640B16376DE4L;
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkPolicy", "com/intellij/psi/formatter/FormatterTestCase", "doTextTest"));
    }

    public static final class CheckPolicy
    extends Enum<CheckPolicy> {
        public static final /* enum */ CheckPolicy PSI;
        public static final /* enum */ CheckPolicy DOCUMENT;
        public static final /* enum */ CheckPolicy BOTH;
        private final boolean c;
        private final boolean b;
        private static final /* synthetic */ CheckPolicy[] a;

        public static CheckPolicy[] values() {
            return (CheckPolicy[])a.clone();
        }

        public static CheckPolicy valueOf(String name2) {
            return Enum.valueOf(CheckPolicy.class, name2);
        }

        private CheckPolicy(boolean checkPsi, boolean checkDocument) {
            this.b = checkDocument;
            this.c = checkPsi;
        }

        public boolean isCheckPsi() {
            return this.c;
        }

        public boolean isCheckDocument() {
            return this.b;
        }

        static {
            long l2 = lb.a(6088603156532637471L, 9360412577576711L, MethodHandles.lookup().lookupClass()).a(92441341331363L) ^ 0x7AC9D4983A6FL;
            PSI = new CheckPolicy(true, false);
            DOCUMENT = new CheckPolicy(false, true);
            BOTH = new CheckPolicy(true, true);
            a = new CheckPolicy[]{PSI, DOCUMENT, BOTH};
        }
    }
}

