/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.ui.actions;

import b.a.lb;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.deployment.DeploymentUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.elements.ArtifactRootElement;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.PackagingElementPath;
import com.intellij.packaging.impl.elements.ArchivePackagingElement;
import com.intellij.util.PathUtil;
import com.intellij.util.io.zip.JBZipEntry;
import com.intellij.util.io.zip.JBZipFile;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PackageFileWorker {
    private static final Logger b;
    private final File c;
    private final String a;
    private final boolean d;
    private static final long e;

    private PackageFileWorker(File file, String relativeOutputPath, boolean packIntoArchives) {
        this.c = file;
        this.a = relativeOutputPath;
        this.d = packIntoArchives;
    }

    public static void startPackagingFiles(Project project2, List<? extends VirtualFile> files, Artifact[] artifacts, @NotNull Runnable onFinishedInAwt) {
        if (onFinishedInAwt == null) {
            PackageFileWorker.a(0);
        }
        PackageFileWorker.startPackagingFiles(project2, files, artifacts, true).doWhenProcessed(() -> {
            if (onFinishedInAwt == null) {
                PackageFileWorker.a(3);
            }
            ApplicationManager.getApplication().invokeLater(onFinishedInAwt);
        });
    }

    public static ActionCallback startPackagingFiles(final Project project2, final List<? extends VirtualFile> files, final Artifact[] artifacts, final boolean packIntoArchives) {
        long l2 = e ^ 0x1D83912A493CL;
        final ActionCallback actionCallback = new ActionCallback();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project2, "Packaging Files"){
            private static final long a = lb.a(3829424963950379557L, 6312194686300563960L, MethodHandles.lookup().lookupClass()).a(3943111675319L);

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.a(0);
                }
                try {
                    for (VirtualFile virtualFile : files) {
                        indicator.checkCanceled();
                        ReadAction.run(() -> {
                            long l2 = a ^ 0x4E99AF17C51DL;
                            try {
                                PackageFileWorker.packageFile(virtualFile, project2, artifacts, packIntoArchives);
                            }
                            catch (IOException iOException) {
                                b.info((Throwable)iOException);
                                String string = CompilerBundle.message((String)"message.tect.package.file.io.error", (Object[])new Object[]{iOException.toString()});
                                Notifications.Bus.notify((Notification)new Notification("Package File", "Cannot package file", string, NotificationType.ERROR));
                            }
                        });
                        actionCallback.setDone();
                    }
                }
                finally {
                    if (!actionCallback.isDone()) {
                        actionCallback.setRejected();
                    }
                }
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x1923F99F3C5L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/packaging/impl/ui/actions/PackageFileWorker$1", "run"));
            }
        });
        return actionCallback;
    }

    public static void packageFile(@NotNull VirtualFile file, @NotNull Project project2, Artifact[] artifacts, boolean packIntoArchives) throws IOException {
        long l2 = e ^ 0x496FD2EDB5ECL;
        if (file == null) {
            PackageFileWorker.a(1);
        }
        if (project2 == null) {
            PackageFileWorker.a(2);
        }
        b.debug("Start packaging file: " + file.getPath());
        Collection<Trinity<Artifact, PackagingElementPath, String>> collection = ArtifactUtil.findContainingArtifactsWithOutputPaths(file, project2, artifacts);
        File file2 = VfsUtilCore.virtualToIoFile((VirtualFile)file);
        for (Trinity<Artifact, PackagingElementPath, String> trinity : collection) {
            Artifact artifact = (Artifact)trinity.getFirst();
            String string = artifact.getOutputPath();
            if (StringUtil.isEmpty((String)string)) continue;
            PackageFileWorker packageFileWorker = new PackageFileWorker(file2, (String)trinity.getThird(), packIntoArchives);
            b.debug(" package to " + string);
            packageFileWorker.b(string, ((PackagingElementPath)trinity.getSecond()).getParents());
        }
    }

    private void b(String string, List<CompositePackagingElement<?>> list2) throws IOException {
        List<Object> list3 = new ArrayList(list2);
        Collections.reverse(list3);
        if (!list3.isEmpty() && list3.get(0) instanceof ArtifactRootElement) {
            list3 = list3.subList(1, list3.size());
        }
        this.a(string, list3);
    }

    private void a(String string, List<CompositePackagingElement<?>> list2) throws IOException {
        long l2 = e ^ 0x255CAE46EDC2L;
        if (list2.isEmpty()) {
            String string2 = DeploymentUtil.appendToPath((String)string, (String)this.a);
            File file = new File(string2);
            if (FileUtil.filesEqual((File)this.c, (File)file)) {
                b.debug("  skipping copying file to itself");
            } else {
                b.debug("  copying to " + string2);
                FileUtil.copy((File)this.c, (File)file);
            }
            return;
        }
        CompositePackagingElement<?> compositePackagingElement = list2.get(0);
        String string3 = string + "/" + compositePackagingElement.getName();
        List<CompositePackagingElement<?>> list3 = list2.subList(1, list2.size());
        if (compositePackagingElement instanceof ArchivePackagingElement) {
            if (this.d) {
                this.a(string3, "", list3);
            }
        } else {
            this.a(string3, list3);
        }
    }

    private void a(String string, String string2, List<CompositePackagingElement<?>> list2) throws IOException {
        long l2 = e ^ 0x22071E369D57L;
        File file = new File(string);
        if (list2.isEmpty()) {
            b.debug("  adding to archive " + string);
            try (JBZipFile jBZipFile = PackageFileWorker.a(file);){
                String string3 = DeploymentUtil.trimForwardSlashes((String)DeploymentUtil.appendToPath((String)string2, (String)this.a));
                JBZipEntry jBZipEntry = jBZipFile.getOrCreateEntry(string3);
                jBZipEntry.setDataFromFile(this.c);
            }
            return;
        }
        CompositePackagingElement<?> compositePackagingElement = list2.get(0);
        String string4 = DeploymentUtil.trimForwardSlashes((String)DeploymentUtil.appendToPath((String)string2, (String)compositePackagingElement.getName()));
        List<CompositePackagingElement<?>> list3 = list2.subList(1, list2.size());
        if (compositePackagingElement instanceof ArchivePackagingElement) {
            try (JBZipFile jBZipFile = PackageFileWorker.a(file);){
                JBZipEntry jBZipEntry = jBZipFile.getOrCreateEntry(string4);
                b.debug("  extracting to temp file: " + string4 + " from " + string);
                File file2 = FileUtil.createTempFile((String)("packageFile" + FileUtil.sanitizeFileName((String)string4)), (String)FileUtilRt.getExtension((String)PathUtil.getFileName((String)string4)));
                if (jBZipEntry.getSize() != -1L) {
                    try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));){
                        jBZipEntry.writeDataTo((OutputStream)bufferedOutputStream);
                    }
                }
                this.a(FileUtil.toSystemIndependentName((String)file2.getAbsolutePath()), "", list3);
                jBZipEntry.setDataFromFile(file2);
                FileUtil.delete((File)file2);
            }
        }
        this.a(string, string4, list3);
    }

    private static JBZipFile a(File file) throws IOException {
        FileUtil.createIfDoesntExist((File)file);
        try {
            return new JBZipFile(file);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException(illegalArgumentException);
        }
    }

    static {
        e = lb.a(-2409115924207066059L, -5679089865183290660L, MethodHandles.lookup().lookupClass()).a(122886494329557L);
        long l2 = e ^ 0x6FAD036BE49EL;
        b = Logger.getInstance((String)"#com.intellij.packaging.impl.ui.actions.PackageFileWorker");
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = e ^ 0x72217D365A09L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onFinishedInAwt";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/packaging/impl/ui/actions/PackageFileWorker";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "startPackagingFiles";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "packageFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$startPackagingFiles$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

