/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import b.a.lb;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.impl.ModuleLibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryEditingUtil;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryRootsComponent;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.FormBuilder;
import java.awt.Component;
import java.lang.invoke.MethodHandles;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nullable;

public abstract class LibraryEditorDialogBase
extends DialogWrapper {
    protected JTextField myNameField;
    private final LibraryRootsComponent a;
    private static final long f = lb.a(-5277195427395198835L, -1049523530992580248L, MethodHandles.lookup().lookupClass()).a(63381155524342L);

    public LibraryEditorDialogBase(Component parent, LibraryRootsComponent libraryRootsComponent) {
        long l2 = f ^ 0x25F716D6B941L;
        super(parent, true);
        this.a = libraryRootsComponent;
        libraryRootsComponent.resetProperties();
        this.setTitle(ProjectBundle.message((String)"library.configure.title", (Object[])new Object[0]));
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.a);
    }

    public void setContextModule(Module module2) {
        this.a.setContextModule(module2);
    }

    protected String getDimensionServiceKey() {
        long l2 = f ^ 0x147F9CC3FE17L;
        return "#com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditorDialog";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField;
    }

    protected final void doOKAction() {
        if (!this.validateAndApply()) {
            return;
        }
        super.doOKAction();
    }

    protected boolean validateAndApply() {
        long l2 = f ^ 0x1B16406C1850L;
        String string = this.myNameField.getText().trim();
        if (string.length() == 0) {
            string = null;
        }
        if (this.shouldCheckName(string)) {
            LibraryTable.ModifiableModel modifiableModel = this.getTableModifiableModel();
            if (modifiableModel != null && !(modifiableModel instanceof ModuleLibraryTable)) {
                if (string == null) {
                    Messages.showErrorDialog((String)ProjectBundle.message((String)"library.name.not.specified.error", (Object[])new Object[]{string}), (String)ProjectBundle.message((String)"library.name.not.specified.title", (Object[])new Object[0]));
                    return false;
                }
                if (LibraryEditingUtil.libraryAlreadyExists(modifiableModel, string)) {
                    Messages.showErrorDialog((String)ProjectBundle.message((String)"library.name.already.exists.error", (Object[])new Object[]{string}), (String)ProjectBundle.message((String)"library.name.already.exists.title", (Object[])new Object[0]));
                    return false;
                }
            }
            this.a.renameLibrary(string);
        }
        this.a.applyProperties();
        return true;
    }

    protected abstract boolean shouldCheckName(String var1);

    @Nullable
    protected LibraryTable.ModifiableModel getTableModifiableModel() {
        return null;
    }

    protected LibraryRootsComponent getLibraryRootsComponent() {
        return this.a;
    }

    protected JComponent createNorthPanel() {
        long l2 = f ^ 0x605EA38A05D3L;
        String string = this.a.getLibraryEditor().getName();
        this.myNameField = new JTextField(string);
        this.myNameField.selectAll();
        FormBuilder formBuilder = FormBuilder.createFormBuilder().addLabeledComponent("&Name:", (JComponent)this.myNameField);
        this.addNorthComponents(formBuilder);
        return formBuilder.addVerticalGap(10).getPanel();
    }

    protected void addNorthComponents(FormBuilder formBuilder) {
    }

    protected JComponent createCenterPanel() {
        return this.a.getComponent();
    }
}

