/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.dependencyAnalysis;

import b.a.lb;
import com.intellij.icons.AllIcons;
import com.intellij.ide.presentation.VirtualFilePresentation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.OrderRootsEnumerator;
import com.intellij.openapi.roots.ui.CellAppearanceEx;
import com.intellij.openapi.roots.ui.OrderEntryAppearanceService;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleDependenciesAnalyzer {
    private final Module f;
    private final boolean c;
    private final boolean e;
    private final boolean b;
    private final List<OrderEntryExplanation> d = new ArrayList<OrderEntryExplanation>();
    private final List<UrlExplanation> a = new ArrayList<UrlExplanation>();

    public ModuleDependenciesAnalyzer(Module module2, boolean production, boolean compile, boolean sdk) {
        this.f = module2;
        this.c = production;
        this.e = compile;
        this.b = sdk;
        this.a();
    }

    public List<UrlExplanation> getUrls() {
        return Collections.unmodifiableList(this.a);
    }

    public List<OrderEntryExplanation> getOrderEntries() {
        return Collections.unmodifiableList(this.d);
    }

    private void a() {
        OrderEnumerator orderEnumerator = ModuleRootManager.getInstance((Module)this.f).orderEntries();
        orderEnumerator.recursively();
        if (!this.b) {
            orderEnumerator.withoutSdk();
        }
        if (this.e) {
            orderEnumerator.compileOnly();
        } else {
            orderEnumerator.runtimeOnly();
        }
        if (this.c) {
            orderEnumerator.productionOnly();
        }
        LinkedHashMap<String, List<OrderPath>> linkedHashMap = new LinkedHashMap<String, List<OrderPath>>();
        OrderRootsEnumerator orderRootsEnumerator = orderEnumerator.classes();
        if (this.e) {
            orderRootsEnumerator.withoutSelfModuleOutput();
        }
        for (String string : orderRootsEnumerator.getUrls()) {
            if (linkedHashMap.containsKey(string)) continue;
            linkedHashMap.put(string, new ArrayList());
        }
        LinkedHashMap linkedHashMap2 = new LinkedHashMap();
        new PathWalker(linkedHashMap, linkedHashMap2).examine(this.f, 0);
        for (Map.Entry entry : linkedHashMap2.entrySet()) {
            this.d.add(new OrderEntryExplanation((OrderEntry)entry.getKey(), (List)entry.getValue()));
        }
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            this.a.add(new UrlExplanation((String)entry.getKey(), (List)entry.getValue()));
        }
    }

    public static class UrlExplanation
    extends Explanation {
        private final String a;

        UrlExplanation(String url, List<OrderPath> paths) {
            super(paths);
            this.a = url;
        }

        public String url() {
            return this.a;
        }

        @Nullable
        public Icon getIcon() {
            VirtualFile virtualFile = this.getLocalFile();
            return virtualFile == null ? AllIcons.General.Error : VirtualFilePresentation.getIcon((VirtualFile)virtualFile);
        }

        @Nullable
        public VirtualFile getLocalFile() {
            VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(this.a);
            if (virtualFile != null) {
                virtualFile = VfsUtil.getLocalFile((VirtualFile)virtualFile);
            }
            return virtualFile;
        }
    }

    public static class OrderEntryExplanation
    extends Explanation {
        private final OrderEntry a;

        OrderEntryExplanation(OrderEntry entry, List<OrderPath> paths) {
            super(paths);
            this.a = entry;
        }

        public OrderEntry entry() {
            return this.a;
        }
    }

    public static class Explanation {
        public final List<OrderPath> myPaths;

        Explanation(List<OrderPath> paths) {
            this.myPaths = Collections.unmodifiableList(paths);
        }

        public List<OrderPath> paths() {
            return this.myPaths;
        }
    }

    public static class OrderEntryPathElement
    extends OrderPathElement {
        private final OrderEntry a;
        private static final long b = lb.a(-8170624307002826178L, 2392185376203289902L, MethodHandles.lookup().lookupClass()).a(154684560529367L);

        public OrderEntryPathElement(OrderEntry entry) {
            this.a = entry;
        }

        public OrderEntry entry() {
            return this.a;
        }

        public int hashCode() {
            return this.a.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OrderEntryPathElement)) {
                return false;
            }
            OrderEntryPathElement orderEntryPathElement = (OrderEntryPathElement)obj;
            return orderEntryPathElement.a == this.a;
        }

        public String toString() {
            return this.a.getPresentableName();
        }

        @Override
        @NotNull
        public CellAppearanceEx getAppearance(boolean isSelected) {
            CellAppearanceEx cellAppearanceEx = OrderEntryAppearanceService.getInstance().forOrderEntry(this.a.getOwnerModule().getProject(), this.a, isSelected);
            if (cellAppearanceEx == null) {
                OrderEntryPathElement.a(0);
            }
            return cellAppearanceEx;
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = b ^ 0x2498B6DCD9E6L;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/dependencyAnalysis/ModuleDependenciesAnalyzer$OrderEntryPathElement", "getAppearance"));
        }
    }

    public static abstract class OrderPathElement {
        @NotNull
        public abstract CellAppearanceEx getAppearance(boolean var1);
    }

    public static class OrderPath {
        private final List<OrderPathElement> a;

        public OrderPath(List<OrderPathElement> entries) {
            this.a = Collections.unmodifiableList(new ArrayList<OrderPathElement>(entries));
        }

        public List<OrderPathElement> entries() {
            return this.a;
        }

        public int hashCode() {
            return this.a.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OrderPath)) {
                return false;
            }
            return this.a.equals(((OrderPath)obj).a);
        }
    }

    private class PathWalker {
        private final Map<String, List<OrderPath>> c;
        private final Map<OrderEntry, List<OrderPath>> d;
        private final ArrayList<OrderPathElement> a = new ArrayList();
        private final HashSet<Module> b = new HashSet();

        PathWalker(Map<String, List<OrderPath>> urlExplanations, Map<OrderEntry, List<OrderPath>> orderExplanations) {
            this.c = urlExplanations;
            this.d = orderExplanations;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void examine(Module m2, int level) {
            if (this.b.contains(m2)) {
                return;
            }
            this.b.add(m2);
            try {
                OrderEnumerator orderEnumerator = ModuleRootManager.getInstance((Module)m2).orderEntries();
                if (!ModuleDependenciesAnalyzer.this.b || level != 0) {
                    orderEnumerator.withoutSdk();
                }
                if (ModuleDependenciesAnalyzer.this.e && level != 0) {
                    orderEnumerator.exportedOnly();
                }
                if (ModuleDependenciesAnalyzer.this.c) {
                    orderEnumerator.productionOnly();
                }
                if (ModuleDependenciesAnalyzer.this.e) {
                    orderEnumerator.compileOnly();
                } else {
                    orderEnumerator.runtimeOnly();
                }
                orderEnumerator.forEach(orderEntry -> {
                    this.a.add(new OrderEntryPathElement((OrderEntry)orderEntry));
                    try {
                        if (orderEntry instanceof ModuleOrderEntry) {
                            ModuleOrderEntry moduleOrderEntry = (ModuleOrderEntry)orderEntry;
                            this.examine(moduleOrderEntry.getModule(), level + 1);
                        } else if (orderEntry instanceof ModuleSourceOrderEntry) {
                            if (!ModuleDependenciesAnalyzer.this.c || !ModuleDependenciesAnalyzer.this.e) {
                                CompilerModuleExtension compilerModuleExtension = CompilerModuleExtension.getInstance((Module)m2);
                                OrderPath orderPath = new OrderPath(this.a);
                                for (String string : compilerModuleExtension.getOutputRootUrls(!ModuleDependenciesAnalyzer.this.e ? !ModuleDependenciesAnalyzer.this.c : level > 0 && !ModuleDependenciesAnalyzer.this.c)) {
                                    this.a(orderPath, string);
                                }
                                this.a((OrderEntry)orderEntry, orderPath);
                            }
                        } else {
                            OrderPath orderPath = new OrderPath(this.a);
                            for (String string : orderEntry.getUrls(OrderRootType.CLASSES)) {
                                this.a(orderPath, string);
                            }
                            this.a((OrderEntry)orderEntry, orderPath);
                        }
                    }
                    finally {
                        this.a.remove(this.a.size() - 1);
                    }
                    return true;
                });
            }
            finally {
                this.b.remove(m2);
            }
        }

        private void a(OrderPath orderPath, String string) {
            List<OrderPath> list2 = this.c.get(string);
            if (list2 != null) {
                list2.add(orderPath);
            }
        }

        private void a(OrderEntry orderEntry, OrderPath orderPath) {
            List<OrderPath> list2 = this.d.get(orderEntry);
            if (list2 == null) {
                list2 = new ArrayList<OrderPath>();
                this.d.put(orderEntry, list2);
            }
            list2.add(orderPath);
        }
    }
}

