/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.dependencyAnalysis;

import b.a.lb;
import com.intellij.ProjectTopics;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ui.CellAppearanceEx;
import com.intellij.openapi.roots.ui.OrderEntryAppearanceService;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.dependencyAnalysis.AnalyzeDependenciesSettings;
import com.intellij.openapi.roots.ui.configuration.dependencyAnalysis.ModuleDependenciesAnalyzer;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.HtmlListCellRenderer;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.PathUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AnalyzeDependenciesComponent
extends MasterDetailsComponent {
    public static final DataKey<ModuleDependenciesAnalyzer.OrderPathElement> ORDER_PATH_ELEMENT_KEY;
    private final Module c;
    private final AnalyzeDependenciesSettings d;
    private final HashMap<Pair<ClasspathType, Boolean>, ModuleDependenciesAnalyzer> a = new HashMap();
    private final MessageBusConnection b;
    private static final long e;

    public AnalyzeDependenciesComponent(Module module2) {
        this.c = module2;
        this.d = AnalyzeDependenciesSettings.getInstance(this.c.getProject());
        this.initTree();
        this.b();
        this.getSplitter().setProportion(0.3f);
        this.b = this.c.getProject().getMessageBus().connect();
        this.b.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){
            private static final long a = lb.a(-2391034339866405409L, 8970327916421070117L, MethodHandles.lookup().lookupClass()).a(246680670034769L);

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    1.a(0);
                }
                AnalyzeDependenciesComponent.this.a.clear();
                AnalyzeDependenciesComponent.this.updateTree();
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x5703C6C06E29L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/roots/ui/configuration/dependencyAnalysis/AnalyzeDependenciesComponent$1", "rootsChanged"));
            }
        });
    }

    public void disposeUIResources() {
        if (this.b != null) {
            this.b.disconnect();
        }
    }

    private void b() {
        this.myTree.setCellRenderer((TreeCellRenderer)new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(JTree tree2, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (value instanceof MasterDetailsComponent.MyNode && !(value instanceof MasterDetailsComponent.MyRootNode)) {
                    MasterDetailsComponent.MyNode myNode = (MasterDetailsComponent.MyNode)value;
                    PathNode pathNode = (PathNode)((Object)myNode.getUserObject());
                    CellAppearanceEx cellAppearanceEx = pathNode.getAppearance(selected, myNode.isDisplayInBold());
                    cellAppearanceEx.customize((SimpleColoredComponent)this);
                }
            }
        });
        this.myTree.setShowsRootHandles(false);
        this.myTree.getSelectionModel().setSelectionMode(1);
        this.reloadTree();
    }

    protected List<AnAction> createActions(boolean fromPopup) {
        if (fromPopup) {
            return super.createActions(true);
        }
        ArrayList<AnAction> arrayList = new ArrayList<AnAction>();
        arrayList.add((AnAction)new ClasspathTypeAction());
        arrayList.add((AnAction)new SdkFilterAction(this));
        arrayList.add((AnAction)new UrlModeAction(this));
        return arrayList;
    }

    @Nls
    public String getDisplayName() {
        long l2 = e ^ 0x8C91C74F82EL;
        return "Classpath Details";
    }

    public void reloadTree() {
        this.myRoot.removeAllChildren();
        ModuleDependenciesAnalyzer moduleDependenciesAnalyzer = this.getAnalyzer();
        if (this.d.isUrlMode()) {
            for (ModuleDependenciesAnalyzer.UrlExplanation urlExplanation : moduleDependenciesAnalyzer.getUrls()) {
                this.myRoot.add((MutableTreeNode)new MasterDetailsComponent.MyNode((NamedConfigurable)new UrlNode(urlExplanation)));
            }
        } else {
            for (ModuleDependenciesAnalyzer.OrderEntryExplanation orderEntryExplanation : moduleDependenciesAnalyzer.getOrderEntries()) {
                this.myRoot.add((MutableTreeNode)new MasterDetailsComponent.MyNode((NamedConfigurable)new OrderEntryNode(orderEntryExplanation)));
            }
        }
        ((DefaultTreeModel)this.myTree.getModel()).reload((TreeNode)this.myRoot);
    }

    public ModuleDependenciesAnalyzer getAnalyzer() {
        Pair pair2 = Pair.create((Object)((Object)this.a()), (Object)this.d.isSdkIncluded());
        ModuleDependenciesAnalyzer moduleDependenciesAnalyzer = this.a.get(pair2);
        if (moduleDependenciesAnalyzer == null) {
            moduleDependenciesAnalyzer = new ModuleDependenciesAnalyzer(this.c, !this.d.isTest(), !this.d.isRuntime(), this.d.isSdkIncluded());
            this.a.put((Pair<ClasspathType, Boolean>)pair2, moduleDependenciesAnalyzer);
        }
        return moduleDependenciesAnalyzer;
    }

    private ClasspathType a() {
        return this.d.isRuntime() ? (this.d.isTest() ? ClasspathType.TEST_RUNTIME : ClasspathType.PRODUCTION_RUNTIME) : (this.d.isTest() ? ClasspathType.TEST_COMPILE : ClasspathType.PRODUCTION_COMPILE);
    }

    void updateTree() {
        this.reloadTree();
    }

    static {
        e = lb.a(-2029595813618901018L, -7243926035867813024L, MethodHandles.lookup().lookupClass()).a(275470381174260L);
        long l2 = e ^ 0x3A6AF994D532L;
        ORDER_PATH_ELEMENT_KEY = DataKey.create((String)"ORDER_PATH_ELEMENT");
    }

    private static final class ClasspathType
    extends Enum<ClasspathType> {
        public static final /* enum */ ClasspathType PRODUCTION_COMPILE;
        public static final /* enum */ ClasspathType PRODUCTION_RUNTIME;
        public static final /* enum */ ClasspathType TEST_RUNTIME;
        public static final /* enum */ ClasspathType TEST_COMPILE;
        private final boolean a;
        private final boolean b;
        private final String c;
        private static final /* synthetic */ ClasspathType[] d;

        public static ClasspathType[] values() {
            return (ClasspathType[])d.clone();
        }

        public static ClasspathType valueOf(String name2) {
            return Enum.valueOf(ClasspathType.class, name2);
        }

        private ClasspathType(boolean isTest, boolean isRuntime, String description) {
            this.a = isTest;
            this.b = isRuntime;
            this.c = description;
        }

        public boolean isTest() {
            return this.a;
        }

        public boolean isRuntime() {
            return this.b;
        }

        public String toString() {
            return this.c;
        }

        public String getDescription() {
            return this.c;
        }

        static {
            long l2 = lb.a(364841114940161008L, 1898518164366636738L, MethodHandles.lookup().lookupClass()).a(261547450116949L) ^ 0x50C838EE2620L;
            PRODUCTION_COMPILE = new ClasspathType(false, false, "Production Compile");
            PRODUCTION_RUNTIME = new ClasspathType(false, true, "Production Runtime");
            TEST_RUNTIME = new ClasspathType(true, true, "Test Runtime");
            TEST_COMPILE = new ClasspathType(true, false, "Test Compile");
            d = new ClasspathType[]{PRODUCTION_COMPILE, PRODUCTION_RUNTIME, TEST_RUNTIME, TEST_COMPILE};
        }
    }

    private class ClasspathTypeAction
    extends ComboBoxAction {
        DefaultActionGroup myItems;
        private static final long a = lb.a(1073957071157628149L, 9015960113526258714L, MethodHandles.lookup().lookupClass()).a(140770944150573L);

        private ClasspathTypeAction() {
        }

        @NotNull
        protected DefaultActionGroup createPopupActionGroup(JComponent button) {
            if (this.myItems == null) {
                this.myItems = new DefaultActionGroup(null, true);
                for (final ClasspathType classpathType : ClasspathType.values()) {
                    this.myItems.addAction((AnAction)new DumbAwareAction(classpathType.getDescription()){
                        private static final long a = lb.a(852252362340437163L, -7739926635511872626L, MethodHandles.lookup().lookupClass()).a(228384332102828L);

                        public void actionPerformed(@NotNull AnActionEvent e10) {
                            if (e10 == null) {
                                1.a(0);
                            }
                            AnalyzeDependenciesComponent.this.d.setRuntime(classpathType.isRuntime());
                            AnalyzeDependenciesComponent.this.d.setTest(classpathType.isTest());
                            AnalyzeDependenciesComponent.this.updateTree();
                        }

                        private static /* synthetic */ void a(int n2) {
                            long l2 = a ^ 0x4CBC9E667DB6L;
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/roots/ui/configuration/dependencyAnalysis/AnalyzeDependenciesComponent$ClasspathTypeAction$1", "actionPerformed"));
                        }
                    });
                }
            }
            DefaultActionGroup defaultActionGroup = this.myItems;
            if (defaultActionGroup == null) {
                ClasspathTypeAction.a(0);
            }
            return defaultActionGroup;
        }

        public void update(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                ClasspathTypeAction.a(1);
            }
            Presentation presentation = e10.getPresentation();
            this.a(presentation);
        }

        private void a(Presentation presentation) {
            ClasspathType classpathType = AnalyzeDependenciesComponent.this.a();
            String string = classpathType.getDescription();
            presentation.setText(string);
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = a ^ 0x78DB3A60F7DCL;
            switch (n2) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 2;
                    break;
                }
                case 1: {
                    n3 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/dependencyAnalysis/AnalyzeDependenciesComponent$ClasspathTypeAction";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createPopupActionGroup";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/dependencyAnalysis/AnalyzeDependenciesComponent$ClasspathTypeAction";
                    break;
                }
            }
            switch (n2) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class UrlModeAction
    extends ToggleAction {
        final /* synthetic */ AnalyzeDependenciesComponent this$0;
        private static final long a = lb.a(-6202926879333079939L, -8403775458888772882L, MethodHandles.lookup().lookupClass()).a(62903448730355L);

        UrlModeAction(AnalyzeDependenciesComponent analyzeDependenciesComponent) {
            long l2 = a ^ 0xCCB41E669B8L;
            this.this$0 = analyzeDependenciesComponent;
            super("Use URL mode", "If selected, the URLs are displayed, otherwise order entries", AllIcons.Nodes.Folder);
        }

        public boolean isSelected(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                UrlModeAction.a(0);
            }
            return this.this$0.d.isUrlMode();
        }

        public void setSelected(@NotNull AnActionEvent e10, boolean state) {
            if (e10 == null) {
                UrlModeAction.a(1);
            }
            this.this$0.d.setUrlMode(state);
            this.this$0.updateTree();
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = a ^ 0xA8AE54F3507L;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/dependencyAnalysis/AnalyzeDependenciesComponent$UrlModeAction";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class SdkFilterAction
    extends ToggleAction {
        final /* synthetic */ AnalyzeDependenciesComponent this$0;
        private static final long a = lb.a(-3797568514422855309L, -1773402712545095230L, MethodHandles.lookup().lookupClass()).a(4638145065693L);

        SdkFilterAction(AnalyzeDependenciesComponent analyzeDependenciesComponent) {
            long l2 = a ^ 0x77B20A2748E2L;
            this.this$0 = analyzeDependenciesComponent;
            super("Include SDK", "If selected, the SDK classes are included", AllIcons.Nodes.PpJdk);
        }

        public boolean isSelected(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                SdkFilterAction.a(0);
            }
            return this.this$0.d.isSdkIncluded();
        }

        public void setSelected(@NotNull AnActionEvent e10, boolean state) {
            if (e10 == null) {
                SdkFilterAction.a(1);
            }
            this.this$0.d.setIncludeSdk(state);
            this.this$0.updateTree();
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = a ^ 0x5739F27E1CDCL;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/dependencyAnalysis/AnalyzeDependenciesComponent$SdkFilterAction";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    class OrderEntryNode
    extends PathNode<ModuleDependenciesAnalyzer.OrderEntryExplanation> {
        private static final long b = lb.a(295367945690228899L, 2404768500276602322L, MethodHandles.lookup().lookupClass()).a(145924087516265L);

        OrderEntryNode(ModuleDependenciesAnalyzer.OrderEntryExplanation orderEntryExplanation) {
            super(AnalyzeDependenciesComponent.this, (ModuleDependenciesAnalyzer.Explanation)orderEntryExplanation);
            this.setNameFieldShown(false);
        }

        @Override
        public CellAppearanceEx getAppearance(boolean selected, boolean isBold) {
            if (((ModuleDependenciesAnalyzer.OrderEntryExplanation)this.myExplanation).entry() instanceof ModuleSourceOrderEntry) {
                ModuleSourceOrderEntry moduleSourceOrderEntry = (ModuleSourceOrderEntry)((ModuleDependenciesAnalyzer.OrderEntryExplanation)this.myExplanation).entry();
                if (moduleSourceOrderEntry.getOwnerModule() == AnalyzeDependenciesComponent.this.c) {
                    return new CellAppearanceEx(){
                        private static final long a = lb.a(6084356148946054742L, 1862301876155056352L, MethodHandles.lookup().lookupClass()).a(141204519612720L);

                        public void customize(@NotNull SimpleColoredComponent component) {
                            long l2 = a ^ 0xD9E510F70AAL;
                            if (component == null) {
                                1.a(0);
                            }
                            component.setIcon(ModuleType.get((Module)AnalyzeDependenciesComponent.this.c).getIcon());
                            component.append("<This Module>", SimpleTextAttributes.SYNTHETIC_ATTRIBUTES);
                        }

                        public void customize(@NotNull HtmlListCellRenderer renderer) {
                            long l2 = a ^ 0x43D483C5A9FBL;
                            if (renderer == null) {
                                1.a(1);
                            }
                            throw new UnsupportedOperationException("Rendering in combo box not supported yet.");
                        }

                        @NotNull
                        public String getText() {
                            long l2 = a ^ 0x5978C2C454AFL;
                            if ("<This Module>" == null) {
                                1.a(2);
                            }
                            return "<This Module>";
                        }

                        private static /* synthetic */ void a(int n2) {
                            RuntimeException runtimeException;
                            Object[] objectArray;
                            Object[] objectArray2;
                            int n3;
                            String string;
                            long l2 = a ^ 0x130192327615L;
                            switch (n2) {
                                default: {
                                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                    break;
                                }
                                case 2: {
                                    string = "@NotNull method %s.%s must not return null";
                                    break;
                                }
                            }
                            switch (n2) {
                                default: {
                                    n3 = 3;
                                    break;
                                }
                                case 2: {
                                    n3 = 2;
                                    break;
                                }
                            }
                            Object[] objectArray3 = new Object[n3];
                            switch (n2) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "component";
                                    break;
                                }
                                case 1: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "renderer";
                                    break;
                                }
                                case 2: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/dependencyAnalysis/AnalyzeDependenciesComponent$OrderEntryNode$1";
                                    break;
                                }
                            }
                            switch (n2) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/dependencyAnalysis/AnalyzeDependenciesComponent$OrderEntryNode$1";
                                    break;
                                }
                                case 2: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "getText";
                                    break;
                                }
                            }
                            switch (n2) {
                                default: {
                                    objectArray = objectArray;
                                    objectArray[2] = "customize";
                                    break;
                                }
                                case 2: {
                                    break;
                                }
                            }
                            String string2 = String.format(string, objectArray);
                            switch (n2) {
                                default: {
                                    runtimeException = new IllegalArgumentException(string2);
                                    break;
                                }
                                case 2: {
                                    runtimeException = new IllegalStateException(string2);
                                    break;
                                }
                            }
                            throw runtimeException;
                        }
                    };
                }
                return OrderEntryAppearanceService.getInstance().forModule(moduleSourceOrderEntry.getOwnerModule());
            }
            return OrderEntryAppearanceService.getInstance().forOrderEntry(AnalyzeDependenciesComponent.this.c.getProject(), ((ModuleDependenciesAnalyzer.OrderEntryExplanation)this.myExplanation).entry(), selected);
        }

        public String getBannerSlogan() {
            long l2 = b ^ 0x6BC0B83F8B22L;
            if (((ModuleDependenciesAnalyzer.OrderEntryExplanation)this.myExplanation).entry() instanceof ModuleSourceOrderEntry) {
                ModuleSourceOrderEntry moduleSourceOrderEntry = (ModuleSourceOrderEntry)((ModuleDependenciesAnalyzer.OrderEntryExplanation)this.myExplanation).entry();
                return this.prefixForBanner("Module " + moduleSourceOrderEntry.getOwnerModule().getName());
            }
            String string = ((ModuleDependenciesAnalyzer.OrderEntryExplanation)this.myExplanation).entry().getPresentableName() + " in module " + ((ModuleDependenciesAnalyzer.OrderEntryExplanation)this.myExplanation).entry().getOwnerModule().getName();
            return this.suffixForBanner(string);
        }

        @Nls
        public String getDisplayName() {
            return ((ModuleDependenciesAnalyzer.OrderEntryExplanation)this.myExplanation).entry().getPresentableName();
        }
    }

    class UrlNode
    extends PathNode<ModuleDependenciesAnalyzer.UrlExplanation> {
        UrlNode(ModuleDependenciesAnalyzer.UrlExplanation url) {
            super(AnalyzeDependenciesComponent.this, (ModuleDependenciesAnalyzer.Explanation)url);
            this.setNameFieldShown(false);
        }

        @Override
        public CellAppearanceEx getAppearance(boolean selected, final boolean isBold) {
            return new CellAppearanceEx(){
                private static final long a = lb.a(7129726704004349417L, 7200273353476289265L, MethodHandles.lookup().lookupClass()).a(222069454716933L);

                public void customize(@NotNull SimpleColoredComponent component) {
                    long l2 = a ^ 0x682C4518145L;
                    if (component == null) {
                        1.a(0);
                    }
                    component.setIcon(UrlNode.this.a());
                    Font font = UIUtil.getTreeFont();
                    if (isBold) {
                        component.setFont(font.deriveFont(1));
                    } else {
                        component.setFont(font.deriveFont(0));
                    }
                    String string = PathUtil.toPresentableUrl((String)((ModuleDependenciesAnalyzer.UrlExplanation)UrlNode.this.getEditableObject()).url());
                    component.append(PathUtil.getFileName((String)string), isBold ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    component.append(" (" + PathUtil.getParentPath((String)string) + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                }

                public void customize(@NotNull HtmlListCellRenderer renderer) {
                    long l2 = a ^ 0x220E3666593CL;
                    if (renderer == null) {
                        1.a(1);
                    }
                    throw new UnsupportedOperationException("Rendering in combo box not supported yet.");
                }

                @NotNull
                public String getText() {
                    String string = UrlNode.this.getDisplayName();
                    if (string == null) {
                        1.a(2);
                    }
                    return string;
                }

                private static /* synthetic */ void a(int n2) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n3;
                    String string;
                    long l2 = a ^ 0x4275B10B6AA7L;
                    switch (n2) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 2: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n2) {
                        default: {
                            n3 = 3;
                            break;
                        }
                        case 2: {
                            n3 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n3];
                    switch (n2) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "component";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "renderer";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/dependencyAnalysis/AnalyzeDependenciesComponent$UrlNode$1";
                            break;
                        }
                    }
                    switch (n2) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/dependencyAnalysis/AnalyzeDependenciesComponent$UrlNode$1";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getText";
                            break;
                        }
                    }
                    switch (n2) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "customize";
                            break;
                        }
                        case 2: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n2) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 2: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
        }

        public String getBannerSlogan() {
            VirtualFile virtualFile = ((ModuleDependenciesAnalyzer.UrlExplanation)this.myExplanation).getLocalFile();
            String string = virtualFile == null ? ((ModuleDependenciesAnalyzer.UrlExplanation)this.myExplanation).url() : virtualFile.getPath();
            string = this.suffixForBanner(string);
            return string;
        }

        private Icon a() {
            return ((ModuleDependenciesAnalyzer.UrlExplanation)this.myExplanation).getIcon();
        }

        @Nls
        public String getDisplayName() {
            return ((ModuleDependenciesAnalyzer.UrlExplanation)this.myExplanation).url();
        }
    }

    static class ExplanationTreeRenderer
    extends ColoredTreeCellRenderer {
        ExplanationTreeRenderer() {
        }

        public void customizeCellRenderer(JTree tree2, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)value;
            Object object = defaultMutableTreeNode.getUserObject();
            if (!(object instanceof ModuleDependenciesAnalyzer.OrderPathElement)) {
                return;
            }
            ModuleDependenciesAnalyzer.OrderPathElement orderPathElement = (ModuleDependenciesAnalyzer.OrderPathElement)object;
            CellAppearanceEx cellAppearanceEx = orderPathElement.getAppearance(selected);
            cellAppearanceEx.customize((SimpleColoredComponent)this);
        }
    }

    static abstract class PathNode<T extends ModuleDependenciesAnalyzer.Explanation>
    extends NamedConfigurable<T>
    implements DataProvider {
        public static final int CUTOFF_LENGTH = 80;
        protected final T myExplanation;
        private Tree a;
        final /* synthetic */ AnalyzeDependenciesComponent this$0;
        private static final long c = lb.a(-3850817680675329526L, 3946445057980704058L, MethodHandles.lookup().lookupClass()).a(57350878943514L);

        PathNode(T explanation) {
            this.this$0 = this$0;
            this.myExplanation = explanation;
        }

        public T getEditableObject() {
            return this.myExplanation;
        }

        private JComponent a() {
            this.a = new Tree((TreeModel)new DefaultTreeModel(this.b()));
            this.a.setRootVisible(false);
            this.a.setCellRenderer((TreeCellRenderer)((Object)new ExplanationTreeRenderer()));
            DataManager.registerDataProvider((JComponent)this.a, (DataProvider)this);
            TreeUtil.expandAll((JTree)this.a);
            NavigateAction navigateAction = new NavigateAction();
            navigateAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(new Shortcut[]{CommonShortcuts.DOUBLE_CLICK_1.getShortcuts()[0]}), (JComponent)this.a);
            DefaultActionGroup defaultActionGroup = new DefaultActionGroup();
            defaultActionGroup.addAction((AnAction)navigateAction);
            PopupHandler.installUnknownPopupHandler((JComponent)this.a, (ActionGroup)defaultActionGroup, (ActionManager)ActionManager.getInstance());
            return new JBScrollPane((Component)this.a);
        }

        public Object getData(@NotNull @NonNls String dataId) {
            Object object;
            if (dataId == null) {
                PathNode.a(0);
            }
            if (CommonDataKeys.PROJECT.is(dataId)) {
                return this.this$0.c.getProject();
            }
            if (LangDataKeys.MODULE.is(dataId)) {
                return this.this$0.c;
            }
            TreePath treePath = this.a.getSelectionPath();
            DefaultMutableTreeNode defaultMutableTreeNode = treePath == null ? null : (DefaultMutableTreeNode)treePath.getLastPathComponent();
            Object object2 = object = defaultMutableTreeNode == null ? null : defaultMutableTreeNode.getUserObject();
            if (object instanceof ModuleDependenciesAnalyzer.OrderPathElement && ORDER_PATH_ELEMENT_KEY.is(dataId)) {
                return object;
            }
            return null;
        }

        private DefaultMutableTreeNode b() {
            long l2 = c ^ 0x7878F6AABBCCL;
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("ROOT");
            for (ModuleDependenciesAnalyzer.OrderPath orderPath : ((ModuleDependenciesAnalyzer.Explanation)this.myExplanation).paths()) {
                this.a(defaultMutableTreeNode, orderPath, 0);
            }
            return defaultMutableTreeNode;
        }

        private void a(DefaultMutableTreeNode defaultMutableTreeNode, ModuleDependenciesAnalyzer.OrderPath orderPath, int n2) {
            DefaultMutableTreeNode defaultMutableTreeNode2;
            if (n2 >= orderPath.entries().size()) {
                return;
            }
            ModuleDependenciesAnalyzer.OrderPathElement orderPathElement = orderPath.entries().get(n2);
            int n3 = defaultMutableTreeNode.getChildCount();
            if (n3 == 0) {
                defaultMutableTreeNode2 = null;
            } else {
                defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n3 - 1);
                if (!defaultMutableTreeNode2.getUserObject().equals(orderPathElement)) {
                    defaultMutableTreeNode2 = null;
                }
            }
            if (defaultMutableTreeNode2 == null) {
                defaultMutableTreeNode2 = new DefaultMutableTreeNode(orderPathElement);
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
            }
            this.a(defaultMutableTreeNode2, orderPath, n2 + 1);
        }

        public void setDisplayName(String name2) {
        }

        public JComponent createOptionsPanel() {
            long l2 = c ^ 0x281FBC0F9751L;
            JComponent jComponent = this.a();
            JPanel jPanel = new JPanel(new BorderLayout());
            JLabel jLabel = new JLabel("Available Through Paths:");
            jLabel.setDisplayedMnemonic('P');
            jLabel.setLabelFor(jComponent);
            jPanel.add((Component)jLabel, "North");
            jPanel.add((Component)jComponent, "Center");
            return jPanel;
        }

        public String getHelpTopic() {
            return null;
        }

        public boolean isModified() {
            return false;
        }

        public void apply() throws ConfigurationException {
        }

        public abstract CellAppearanceEx getAppearance(boolean var1, boolean var2);

        protected String suffixForBanner(String p2) {
            long l2 = c ^ 0x211AFE90BF51L;
            if (p2.length() > 80) {
                p2 = "..." + p2.substring(p2.length() - 80);
            }
            return p2;
        }

        protected String prefixForBanner(String p2) {
            long l2 = c ^ 0x6C1D878FBF1DL;
            if (p2.length() > 80) {
                p2 = p2.substring(0, 80) + "...";
            }
            return p2;
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = c ^ 0x1438B7BC98E6L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/openapi/roots/ui/configuration/dependencyAnalysis/AnalyzeDependenciesComponent$PathNode", "getData"));
        }
    }

    static class NavigateAction
    extends DumbAwareAction {
        private static final long a = lb.a(-1987866643996590120L, -7970816094659475493L, MethodHandles.lookup().lookupClass()).a(184704203861882L);

        NavigateAction() {
            long l2 = a ^ 0x684CB6DCCFA1L;
            super("Navigate to ...", "Navigate to place where path element is defined", null);
        }

        public void actionPerformed(@NotNull AnActionEvent e10) {
            Module module2;
            if (e10 == null) {
                NavigateAction.a(0);
            }
            if ((module2 = (Module)e10.getData(LangDataKeys.MODULE)) == null) {
                return;
            }
            ModuleDependenciesAnalyzer.OrderPathElement orderPathElement = (ModuleDependenciesAnalyzer.OrderPathElement)e10.getData(ORDER_PATH_ELEMENT_KEY);
            if (orderPathElement instanceof ModuleDependenciesAnalyzer.OrderEntryPathElement) {
                ModuleDependenciesAnalyzer.OrderEntryPathElement orderEntryPathElement = (ModuleDependenciesAnalyzer.OrderEntryPathElement)orderPathElement;
                OrderEntry orderEntry = orderEntryPathElement.entry();
                Module module3 = orderEntry.getOwnerModule();
                ProjectStructureConfigurable.getInstance(module2.getProject()).selectOrderEntry(module3, orderEntry);
            }
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = a ^ 0x4CC893D80BADL;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/roots/ui/configuration/dependencyAnalysis/AnalyzeDependenciesComponent$NavigateAction", "actionPerformed"));
        }
    }
}

